/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.ISlice;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.svg.ImageTracer;
import eu.mihosoft.vrl.v3d.svg.SVGLoad;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Scale;

public class Slice {
    private static ISlice sliceEngine = new ISlice(){
        int xPix;
        int yPix;
        boolean done = false;
        boolean first = true;

        int toPix(int x, int y) {
            return x * (this.yPix + 2) + y + 1;
        }

        public boolean containsPoint(Vector3d p, Vertex p1, Vertex p2, double TOL) {
            double PB;
            double AP;
            double x = p.x;
            double x1 = p1.pos.x;
            double x2 = p2.pos.x;
            double y = p.y;
            double y2 = p2.pos.y;
            double y1 = p1.pos.y;
            double AB = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            return Math.abs(AB - ((AP = Math.sqrt((x - x1) * (x - x1) + (y - y1) * (y - y1))) + (PB = Math.sqrt((x2 - x) * (x2 - x) + (y2 - y) * (y2 - y))))) < TOL;
        }

        public boolean polygonContains(Vector3d p, Polygon poly) {
            double px = p.x;
            double py = p.y;
            boolean oddNodes = false;
            double x2 = poly.vertices.get((int)(poly.vertices.size() - 1)).pos.x;
            double y2 = poly.vertices.get((int)(poly.vertices.size() - 1)).pos.y;
            for (int i = 0; i < poly.vertices.size(); ++i) {
                Vertex v2;
                Vertex v1 = poly.vertices.get(i);
                if (this.containsPoint(p, v1, v2 = i < poly.vertices.size() - 1 ? poly.vertices.get(i + 1) : poly.vertices.get(0), 1.0E-7)) {
                    return true;
                }
                double x1 = poly.vertices.get((int)i).pos.x;
                double y1 = poly.vertices.get((int)i).pos.y;
                if ((y1 < py && y2 >= py || y1 >= py && y2 < py) && (py - y1) / (y2 - y1) * (x2 - x1) < px - x1) {
                    oddNodes = !oddNodes;
                }
                x2 = x1;
                y2 = y1;
            }
            return oddNodes;
        }

        @Override
        public List<Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
            if (this.first) {
                new JFXPanel();
            }
            this.first = false;
            ArrayList<Polygon> rawPolygons = new ArrayList<Polygon>();
            CSG planeCSG = incoming.getBoundingBox().toZMin();
            System.out.println("Preparing CSG slice");
            CSG slicePart = incoming.transformed(slicePlane).intersect(planeCSG);
            for (Polygon p : slicePart.getPolygons()) {
                if (!Slice.isPolygonAtZero(p)) continue;
                rawPolygons.add(p);
            }
            double ratio = slicePart.getTotalY() / slicePart.getTotalX();
            double scalePixel = 0.25;
            double size = slicePart.getTotalX() / 0.5 / scalePixel;
            if (slicePart.getTotalY() > slicePart.getTotalX()) {
                size = slicePart.getTotalY() / 0.5 / scalePixel;
                ratio = slicePart.getTotalX() / slicePart.getTotalY();
            }
            this.xPix = (int)(size * (ratio > 1.0 ? 1.0 : ratio));
            this.yPix = (int)(size * (ratio < 1.0 ? 1.0 : ratio));
            int pixels = (this.xPix + 2) * (this.yPix + 2);
            double xOffset = slicePart.getMinX();
            double yOffset = slicePart.getMinY();
            double scale = slicePart.getTotalX() / (double)this.xPix;
            boolean[] pix = new boolean[pixels];
            System.out.println("Image x=" + this.xPix + " by y=" + this.yPix + " at x=" + xOffset + " y=" + yOffset);
            long start = System.currentTimeMillis();
            int imageOffset = 20;
            final WritableImage obj_img = new WritableImage(this.xPix + imageOffset, this.yPix + imageOffset);
            MeshView sliceMesh = slicePart.getMesh();
            sliceMesh.getTransforms().add((Object)javafx.scene.transform.Transform.translate((double)(imageOffset / 10), (double)(imageOffset / 10)));
            AnchorPane anchor = new AnchorPane(new Node[]{sliceMesh});
            AnchorPane.setBottomAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setTopAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)sliceMesh, (Double)0.0);
            AnchorPane.setRightAnchor((Node)sliceMesh, (Double)0.0);
            final Pane snapshotGroup = new Pane(new Node[]{anchor});
            snapshotGroup.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
            final SnapshotParameters snapshotParameters = new SnapshotParameters();
            snapshotParameters.setTransform((javafx.scene.transform.Transform)new Scale(1.0 / scale, 1.0 / scale));
            snapshotParameters.setDepthBuffer(true);
            snapshotParameters.setFill((Paint)Color.TRANSPARENT);
            this.done = false;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    snapshotGroup.snapshot(snapshotParameters, obj_img);
                    done = true;
                }
            };
            Platform.runLater((Runnable)r);
            while (!this.done) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            boolean alpha = false;
            for (int i = 0; i < this.xPix; ++i) {
                for (int j = 0; j < this.yPix; ++j) {
                    int color = obj_img.getPixelReader().getArgb(i, j);
                    pix[this.toPix((int)i, (int)j)] = (color & 0xFF000000) > 0;
                }
            }
            System.out.println("Find boundries ");
            ImageView sliceImage = new ImageView((Image)obj_img);
            sliceImage.getTransforms().add((Object)javafx.scene.transform.Transform.translate((double)(xOffset - (double)(imageOffset / 10)), (double)(yOffset - (double)(imageOffset / 10))));
            sliceImage.getTransforms().add((Object)javafx.scene.transform.Transform.scale((double)scale, (double)scale));
            double MMTOPX = 3.5409643774783404;
            float outputScale = (float)(MMTOPX / scale);
            HashMap<String, Float> options = new HashMap<String, Float>();
            options.put("ltres", Float.valueOf(1.0f));
            options.put("qtres", Float.valueOf(1.0f));
            options.put("pathomit", Float.valueOf(0.02f));
            options.put("colorsampling", Float.valueOf(1.0f));
            options.put("numberofcolors", Float.valueOf(16.0f));
            options.put("mincolorratio", Float.valueOf(0.02f));
            options.put("colorquantcycles", Float.valueOf(1.0f));
            options.put("scale", Float.valueOf(outputScale));
            options.put("simplifytolerance", Float.valueOf(1.0f));
            options.put("roundcoords", Float.valueOf(2.0f));
            options.put("lcpr", Float.valueOf(0.0f));
            options.put("qcpr", Float.valueOf(0.0f));
            options.put("desc", Float.valueOf(0.0f));
            options.put("viewbox", Float.valueOf(1.0f));
            options.put("blurradius", Float.valueOf(0.0f));
            options.put("blurdelta", Float.valueOf(20.0f));
            System.out.print("\nTracing...");
            BufferedImage bi = SwingFXUtils.fromFXImage((Image)obj_img, (BufferedImage)null);
            try {
                String svg = ImageTracer.imageToSVG(bi, options, (byte[][])null);
                int headerStart = svg.indexOf(">") + 1;
                int headerEnd = svg.lastIndexOf("<");
                String header = svg.substring(0, headerStart);
                String footer = svg.substring(headerEnd, svg.length());
                String body = svg.substring(headerStart, headerEnd);
                body = "<g id=\"g37\">\n" + body + "</g>\n";
                svg = header + body + footer;
                File tmpsvg = new File(System.getProperty("java.io.tmpdir") + "/" + Math.random());
                tmpsvg.createNewFile();
                FileWriter fw = new FileWriter(tmpsvg.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(svg);
                bw.close();
                Transform tr = new Transform().translate(xOffset - (double)(imageOffset / 10), yOffset - (double)(imageOffset / 10), 0.0).scale(scale / 28.3);
                List<Polygon> svgPolys = SVGLoad.toPolygons(tmpsvg);
                for (Polygon P : svgPolys) {
                    P.transform(tr);
                }
                tmpsvg.delete();
                System.out.print("Done Slicing! Took " + (double)(System.currentTimeMillis() - start) / 1000.0 + "\n\n");
                svgPolys.remove(0);
                return svgPolys;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return rawPolygons;
            }
        }
    };

    private static boolean isPolygonAtZero(Polygon polygon) {
        for (Vertex v : polygon.vertices) {
            if (Slice.isVertexAtZero(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVertexAtZero(Vertex vertex) {
        double SLICE_UPPER_BOUND = 0.001;
        double SLICE_LOWER_BOUND = -0.001;
        return vertex.getZ() < 0.001 && vertex.getZ() > -0.001;
    }

    public static List<Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
        return Slice.getSliceEngine().slice(incoming, slicePlane, normalInsetDistance);
    }

    public static ISlice getSliceEngine() {
        return sliceEngine;
    }

    public static void setSliceEngine(ISlice sliceEngine) {
        Slice.sliceEngine = sliceEngine;
    }
}

