/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.DTSweepConstraint;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TPoint;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationPoint;
import java.util.ArrayList;

public class DelaunayTriangle {
    public final DelaunayTriangle[] neighbors = new DelaunayTriangle[3];
    public final boolean[] cEdge = new boolean[]{false, false, false};
    public final boolean[] dEdge = new boolean[]{false, false, false};
    protected boolean interior = false;
    public final TriangulationPoint[] points = new TriangulationPoint[3];

    public DelaunayTriangle(TriangulationPoint p1, TriangulationPoint p2, TriangulationPoint p3) {
        this.points[0] = p1;
        this.points[1] = p2;
        this.points[2] = p3;
    }

    public int index(TriangulationPoint p) {
        if (p == this.points[0]) {
            return 0;
        }
        if (p == this.points[1]) {
            return 1;
        }
        if (p == this.points[2]) {
            return 2;
        }
        throw new RuntimeException("Calling index with a point that doesn't exist in triangle");
    }

    public int indexCW(TriangulationPoint p) {
        int index = this.index(p);
        switch (index) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
        }
        return 1;
    }

    public int indexCCW(TriangulationPoint p) {
        int index = this.index(p);
        switch (index) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 0;
    }

    public boolean contains(TriangulationPoint p) {
        return p == this.points[0] || p == this.points[1] || p == this.points[2];
    }

    public boolean contains(DTSweepConstraint e) {
        return this.contains(e.p) && this.contains(e.q);
    }

    public boolean contains(TriangulationPoint p, TriangulationPoint q) {
        return this.contains(p) && this.contains(q);
    }

    private void markNeighbor(TriangulationPoint p1, TriangulationPoint p2, DelaunayTriangle t) {
        if (p1 == this.points[2] && p2 == this.points[1] || p1 == this.points[1] && p2 == this.points[2]) {
            this.neighbors[0] = t;
        } else if (p1 == this.points[0] && p2 == this.points[2] || p1 == this.points[2] && p2 == this.points[0]) {
            this.neighbors[1] = t;
        } else if (p1 == this.points[0] && p2 == this.points[1] || p1 == this.points[1] && p2 == this.points[0]) {
            this.neighbors[2] = t;
        }
    }

    public void markNeighbor(DelaunayTriangle t) {
        if (t.contains(this.points[1], this.points[2])) {
            this.neighbors[0] = t;
            t.markNeighbor(this.points[1], this.points[2], this);
        } else if (t.contains(this.points[0], this.points[2])) {
            this.neighbors[1] = t;
            t.markNeighbor(this.points[0], this.points[2], this);
        } else if (t.contains(this.points[0], this.points[1])) {
            this.neighbors[2] = t;
            t.markNeighbor(this.points[0], this.points[1], this);
        }
    }

    public void clearNeighbors() {
        this.neighbors[2] = null;
        this.neighbors[1] = null;
        this.neighbors[0] = null;
    }

    public void clearNeighbor(DelaunayTriangle triangle) {
        if (this.neighbors[0] == triangle) {
            this.neighbors[0] = null;
        } else if (this.neighbors[1] == triangle) {
            this.neighbors[1] = null;
        } else {
            this.neighbors[2] = null;
        }
    }

    public void clear() {
        for (int i = 0; i < 3; ++i) {
            DelaunayTriangle t = this.neighbors[i];
            if (t == null) continue;
            t.clearNeighbor(this);
        }
        this.clearNeighbors();
        this.points[2] = null;
        this.points[1] = null;
        this.points[0] = null;
    }

    public TriangulationPoint oppositePoint(DelaunayTriangle t, TriangulationPoint p) {
        assert (t != this) : "self-pointer error";
        return this.pointCW(t.pointCW(p));
    }

    public DelaunayTriangle neighborCW(TriangulationPoint point) {
        if (point == this.points[0]) {
            return this.neighbors[1];
        }
        if (point == this.points[1]) {
            return this.neighbors[2];
        }
        return this.neighbors[0];
    }

    public DelaunayTriangle neighborCCW(TriangulationPoint point) {
        if (point == this.points[0]) {
            return this.neighbors[2];
        }
        if (point == this.points[1]) {
            return this.neighbors[0];
        }
        return this.neighbors[1];
    }

    public DelaunayTriangle neighborAcross(TriangulationPoint opoint) {
        if (opoint == this.points[0]) {
            return this.neighbors[0];
        }
        if (opoint == this.points[1]) {
            return this.neighbors[1];
        }
        return this.neighbors[2];
    }

    public TriangulationPoint pointCCW(TriangulationPoint point) {
        if (point == this.points[0]) {
            return this.points[1];
        }
        if (point == this.points[1]) {
            return this.points[2];
        }
        if (point == this.points[2]) {
            return this.points[0];
        }
        throw new RuntimeException("[FIXME] point location error");
    }

    public TriangulationPoint pointCW(TriangulationPoint point) {
        if (point == this.points[0]) {
            return this.points[2];
        }
        if (point == this.points[1]) {
            return this.points[0];
        }
        if (point == this.points[2]) {
            return this.points[1];
        }
        throw new RuntimeException("[FIXME] point location error");
    }

    public void legalize(TriangulationPoint oPoint, TriangulationPoint nPoint) {
        if (oPoint == this.points[0]) {
            this.points[1] = this.points[0];
            this.points[0] = this.points[2];
            this.points[2] = nPoint;
        } else if (oPoint == this.points[1]) {
            this.points[2] = this.points[1];
            this.points[1] = this.points[0];
            this.points[0] = nPoint;
        } else if (oPoint == this.points[2]) {
            this.points[0] = this.points[2];
            this.points[2] = this.points[1];
            this.points[1] = nPoint;
        } else {
            throw new RuntimeException("legalization bug");
        }
    }

    public void printDebug() {
        System.out.println(this.points[0] + "," + this.points[1] + "," + this.points[2]);
    }

    public void markNeighborEdges() {
        block5: for (int i = 0; i < 3; ++i) {
            if (!this.cEdge[i]) continue;
            switch (i) {
                case 0: {
                    if (this.neighbors[0] == null) continue block5;
                    this.neighbors[0].markConstrainedEdge(this.points[1], this.points[2]);
                    continue block5;
                }
                case 1: {
                    if (this.neighbors[1] == null) continue block5;
                    this.neighbors[1].markConstrainedEdge(this.points[0], this.points[2]);
                    continue block5;
                }
                case 2: {
                    if (this.neighbors[2] == null) continue block5;
                    this.neighbors[2].markConstrainedEdge(this.points[0], this.points[1]);
                }
            }
        }
    }

    public void markEdge(DelaunayTriangle triangle) {
        block5: for (int i = 0; i < 3; ++i) {
            if (!this.cEdge[i]) continue;
            switch (i) {
                case 0: {
                    triangle.markConstrainedEdge(this.points[1], this.points[2]);
                    continue block5;
                }
                case 1: {
                    triangle.markConstrainedEdge(this.points[0], this.points[2]);
                    continue block5;
                }
                case 2: {
                    triangle.markConstrainedEdge(this.points[0], this.points[1]);
                }
            }
        }
    }

    public void markEdge(ArrayList<DelaunayTriangle> tList) {
        for (DelaunayTriangle t : tList) {
            block6: for (int i = 0; i < 3; ++i) {
                if (!t.cEdge[i]) continue;
                switch (i) {
                    case 0: {
                        this.markConstrainedEdge(t.points[1], t.points[2]);
                        continue block6;
                    }
                    case 1: {
                        this.markConstrainedEdge(t.points[0], t.points[2]);
                        continue block6;
                    }
                    case 2: {
                        this.markConstrainedEdge(t.points[0], t.points[1]);
                    }
                }
            }
        }
    }

    public void markConstrainedEdge(int index) {
        this.cEdge[index] = true;
    }

    public void markConstrainedEdge(DTSweepConstraint edge) {
        this.markConstrainedEdge(edge.p, edge.q);
        if (edge.q == this.points[0] && edge.p == this.points[1] || edge.q == this.points[1] && edge.p == this.points[0]) {
            this.cEdge[2] = true;
        } else if (edge.q == this.points[0] && edge.p == this.points[2] || edge.q == this.points[2] && edge.p == this.points[0]) {
            this.cEdge[1] = true;
        } else if (edge.q == this.points[1] && edge.p == this.points[2] || edge.q == this.points[2] && edge.p == this.points[1]) {
            this.cEdge[0] = true;
        }
    }

    public void markConstrainedEdge(TriangulationPoint p, TriangulationPoint q) {
        if (q == this.points[0] && p == this.points[1] || q == this.points[1] && p == this.points[0]) {
            this.cEdge[2] = true;
        } else if (q == this.points[0] && p == this.points[2] || q == this.points[2] && p == this.points[0]) {
            this.cEdge[1] = true;
        } else if (q == this.points[1] && p == this.points[2] || q == this.points[2] && p == this.points[1]) {
            this.cEdge[0] = true;
        }
    }

    public double area() {
        double a = (this.points[0].getX() - this.points[2].getX()) * (this.points[1].getY() - this.points[0].getY());
        double b = (this.points[0].getX() - this.points[1].getX()) * (this.points[2].getY() - this.points[0].getY());
        return 0.5 * Math.abs(a - b);
    }

    public TPoint centroid() {
        double cx = (this.points[0].getX() + this.points[1].getX() + this.points[2].getX()) / 3.0;
        double cy = (this.points[0].getY() + this.points[1].getY() + this.points[2].getY()) / 3.0;
        return new TPoint(cx, cy);
    }

    public int edgeIndex(TriangulationPoint p1, TriangulationPoint p2) {
        if (this.points[0] == p1) {
            if (this.points[1] == p2) {
                return 2;
            }
            if (this.points[2] == p2) {
                return 1;
            }
        } else if (this.points[1] == p1) {
            if (this.points[2] == p2) {
                return 0;
            }
            if (this.points[0] == p2) {
                return 2;
            }
        } else if (this.points[2] == p1) {
            if (this.points[0] == p2) {
                return 1;
            }
            if (this.points[1] == p2) {
                return 0;
            }
        }
        return -1;
    }

    public boolean getConstrainedEdgeCCW(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.cEdge[2];
        }
        if (p == this.points[1]) {
            return this.cEdge[0];
        }
        return this.cEdge[1];
    }

    public boolean getConstrainedEdgeCW(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.cEdge[1];
        }
        if (p == this.points[1]) {
            return this.cEdge[2];
        }
        return this.cEdge[0];
    }

    public boolean getConstrainedEdgeAcross(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.cEdge[0];
        }
        if (p == this.points[1]) {
            return this.cEdge[1];
        }
        return this.cEdge[2];
    }

    public void setConstrainedEdgeCCW(TriangulationPoint p, boolean ce) {
        if (p == this.points[0]) {
            this.cEdge[2] = ce;
        } else if (p == this.points[1]) {
            this.cEdge[0] = ce;
        } else {
            this.cEdge[1] = ce;
        }
    }

    public void setConstrainedEdgeCW(TriangulationPoint p, boolean ce) {
        if (p == this.points[0]) {
            this.cEdge[1] = ce;
        } else if (p == this.points[1]) {
            this.cEdge[2] = ce;
        } else {
            this.cEdge[0] = ce;
        }
    }

    public void setConstrainedEdgeAcross(TriangulationPoint p, boolean ce) {
        if (p == this.points[0]) {
            this.cEdge[0] = ce;
        } else if (p == this.points[1]) {
            this.cEdge[1] = ce;
        } else {
            this.cEdge[2] = ce;
        }
    }

    public boolean getDelunayEdgeCCW(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.dEdge[2];
        }
        if (p == this.points[1]) {
            return this.dEdge[0];
        }
        return this.dEdge[1];
    }

    public boolean getDelunayEdgeCW(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.dEdge[1];
        }
        if (p == this.points[1]) {
            return this.dEdge[2];
        }
        return this.dEdge[0];
    }

    public boolean getDelunayEdgeAcross(TriangulationPoint p) {
        if (p == this.points[0]) {
            return this.dEdge[0];
        }
        if (p == this.points[1]) {
            return this.dEdge[1];
        }
        return this.dEdge[2];
    }

    public void setDelunayEdgeCCW(TriangulationPoint p, boolean e) {
        if (p == this.points[0]) {
            this.dEdge[2] = e;
        } else if (p == this.points[1]) {
            this.dEdge[0] = e;
        } else {
            this.dEdge[1] = e;
        }
    }

    public void setDelunayEdgeCW(TriangulationPoint p, boolean e) {
        if (p == this.points[0]) {
            this.dEdge[1] = e;
        } else if (p == this.points[1]) {
            this.dEdge[2] = e;
        } else {
            this.dEdge[0] = e;
        }
    }

    public void setDelunayEdgeAcross(TriangulationPoint p, boolean e) {
        if (p == this.points[0]) {
            this.dEdge[0] = e;
        } else if (p == this.points[1]) {
            this.dEdge[1] = e;
        } else {
            this.dEdge[2] = e;
        }
    }

    public void clearDelunayEdges() {
        this.dEdge[0] = false;
        this.dEdge[1] = false;
        this.dEdge[2] = false;
    }

    public boolean isInterior() {
        return this.interior;
    }

    public void isInterior(boolean b) {
        this.interior = b;
    }

    public Polygon toPolygon() {
        Vector3d normal = new Vector3d(0.0, 0.0, 1.0);
        Vector3d p0 = new Vector3d(this.points[0].getX(), this.points[0].getY(), this.points[0].getZ());
        Vector3d p1 = new Vector3d(this.points[1].getX(), this.points[1].getY(), this.points[1].getZ());
        Vector3d p2 = new Vector3d(this.points[2].getX(), this.points[2].getY(), this.points[2].getZ());
        Vertex v0 = new Vertex(p0, normal);
        Vertex v1 = new Vertex(p1, normal);
        Vertex v2 = new Vertex(p2, normal);
        return new Polygon(v0, v1, v2);
    }
}

