/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class Egg {
    public CSG toCSG() {
        double radius = 22.0;
        double stretch = 1.5;
        int resolution = 64;
        CSG cube = new Cube(2.0 * stretch * radius).toCSG();
        cube = cube.transformed(Transform.unity().translateZ(stretch * radius));
        CSG upperHalf = new Sphere(radius, resolution, resolution / 2).toCSG().transformed(Transform.unity().scaleZ(stretch));
        upperHalf = upperHalf.intersect(cube);
        CSG lowerHalf = new Sphere(radius, resolution, resolution / 2).toCSG();
        lowerHalf = lowerHalf.difference(cube);
        lowerHalf = lowerHalf.transformed(Transform.unity().scaleZ(stretch * 0.72));
        CSG egg = upperHalf.union(lowerHalf);
        return egg;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("egg.stl", new String[0]), new Egg().toCSG().toStlString());
    }
}

