/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Moebiusband {
    public CSG toCSG() {
        double width = 10.0;
        double height = 20.0;
        List<Vector3d> points = Arrays.asList(new Vector3d(-width / 2.0, -height / 2.0), new Vector3d(width / 2.0, -height / 2.0), new Vector3d(width / 2.0, height / 2.0), new Vector3d(-width / 2.0, height / 2.0));
        ArrayList<CSG> originalFacets = new ArrayList<CSG>();
        ArrayList<CSG> facets = new ArrayList<CSG>();
        CSG prev = null;
        for (int i = 0; i < 10; ++i) {
            Transform t = Transform.unity().translateZ(2.0).rotZ(i);
            CSG facet = Extrude.points(new Vector3d(0.0, 0.0, 1.0), points);
            if (prev != null) {
                facets.add(facet.union(prev).hull());
            }
            originalFacets.add(facet);
            points.stream().forEach(p -> t.transform((Vector3d)p));
            prev = facet;
        }
        CSG result = (CSG)facets.get(0);
        for (int i = 1; i < facets.size(); ++i) {
            result = result.union((CSG)facets.get(i));
        }
        CSG originalResult = (CSG)originalFacets.get(0);
        for (int i = 1; i < facets.size(); ++i) {
            originalResult = originalResult.union((CSG)originalFacets.get(i));
        }
        return result.union(originalResult.transformed(Transform.unity().translateX(width * 2.0)));
    }

    public static void main(String[] args) throws IOException {
        System.out.println("RUNNING");
        FileUtil.write(Paths.get("m\u00f6biusband.stl", new String[0]), new Moebiusband().toCSG().toStlString());
    }
}

