/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.RoundedCube;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;

public class QuadrocopterCross {
    public static void main(String[] args) throws IOException {
        CSG.setDefaultOptType(CSG.OptType.NONE);
        CSG result = new QuadrocopterCross().toCSG2();
        FileUtil.write(Paths.get("quadrocopter-cross.stl", new String[0]), result.toStlString());
        result.toObj().toFiles(Paths.get("quadrocopter-cross.obj", new String[0]));
    }

    public void print3d(CSG csg, int n) {
        try {
            FileUtil.write(Paths.get("quadrocopter-cross-" + n + ".stl", new String[0]), csg.toStlString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CSG toCSG(double armHeight, double armScaleFactor, double armCubeWidth, double armCubeThickness, double holderPlatformRadius, double holderPlatformThickness) {
        double widthTol = 2.0;
        double thicknessTol = 0.1;
        double holderWallThickness = 6.0;
        double armOverlap = 30.0;
        double holderCubeDepth = armOverlap + (armCubeThickness += thicknessTol) + holderWallThickness;
        double armWidth = armHeight * armScaleFactor;
        Transform xTransform = Transform.unity().translateX(-holderWallThickness * 2.0);
        Transform yTransform = Transform.unity().translateY(-armCubeThickness / 2.0 - armOverlap / 2.0 + holderWallThickness);
        CSG armCube = new Cube(armCubeWidth + widthTol, armCubeThickness, armHeight).toCSG().transformed(yTransform);
        CSG arm = new Cube(armWidth, holderCubeDepth, armHeight).toCSG().transformed(Transform.unity().translateZ(armHeight / 2.0));
        arm = new Cylinder(armHeight / 2.0, holderCubeDepth, 32).toCSG().transformed(Transform.unity().rotX(90.0).translate(0.0, 0.0, -holderCubeDepth / 2.0).scaleX(armScaleFactor)).union(arm);
        CSG holder = armCube.union(arm).transformed(Transform.unity().rotZ(90.0));
        double sideArmHight = 75.0;
        double sideArmGroundDist = 25.0;
        double sideArmRadius = armHeight / 6.0;
        double sideArmShrinkFactor = 0.6;
        return holder;
    }

    public CSG toCSG2() {
        double platformRadius = 80.0;
        double innerHoleRadius = 50.0;
        double platformThickness = 3.0;
        double armHeight = 18.0;
        double armScaleFactor = 0.65;
        double armCubeWidth = armHeight;
        double armCubeThickness = 4.0;
        double holderPlatformRadius = 20.0;
        double distToInnerHole = 5.0;
        CSG armHolderPrototype = this.toCSG(armHeight, armScaleFactor, armCubeWidth, armCubeThickness, holderPlatformRadius, platformThickness).transformed(Transform.unity().translateX(68.0).translateZ(14.0));
        CSG armHolders = armHolderPrototype.clone();
        CSG quarterPrototype = new RoundedCube(platformRadius).noCenter().cornerRadius(10.0).resolution(16).toCSG().transformed(Transform.unity().rotZ(45.0)).transformed(Transform.unity().scaleY(3.0)).transformed(Transform.unity().translate(innerHoleRadius + distToInnerHole, 0.0, -armHeight / 2.0)).transformed(Transform.unity().rotZ(-45.0));
        CSG quarters = quarterPrototype.clone();
        for (int i = 1; i < 4; ++i) {
            Transform rotTransform = Transform.unity().rotZ(i * 90);
            armHolders = armHolders.union(armHolderPrototype.transformed(rotTransform));
            quarters = quarters.union(quarterPrototype.transformed(rotTransform));
        }
        CSG platform = new Cylinder(platformRadius, armHeight, 64).toCSG();
        CSG innerHole = new Cylinder(innerHoleRadius, armHeight, 64).toCSG();
        platform = platform.difference(armHolders, innerHole, quarters);
        return platform;
    }
}

