/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.samples.RaspberryPeg;
import java.io.IOException;
import java.nio.file.Paths;

public class RaspberryPiBPlusMount {
    public static CSG board() {
        double board_thickness = 2.0;
        double bottom_thickness = 3.0;
        double board_mounting_height = 4.0;
        double outer_offset = 4.0;
        double inner_offset = 4.0;
        double board_width = 85.0;
        double board_height = 56.0;
        double bw = board_width;
        double bh = board_height;
        double sd1 = 14.0;
        double sd2 = 11.0;
        double sd3 = 18.0;
        Polygon board_points_exact = Polygon.fromPoints(new Vector3d(0.0, 0.0), new Vector3d(0.0, bh), new Vector3d(bw, bh), new Vector3d(bw, bh - sd1), new Vector3d(bw - sd3, bh - sd1), new Vector3d(bw - sd3, sd2), new Vector3d(bw, sd2), new Vector3d(bw, 0.0));
        double ox1 = outer_offset;
        double oy1 = outer_offset;
        double ox2 = inner_offset;
        double oy2 = inner_offset;
        CSG outer = Extrude.points(new Vector3d(0.0, 0.0, bottom_thickness), new Vector3d(0.0 - ox1, 0.0 - oy1), new Vector3d(0.0 - ox1, bh + oy1), new Vector3d(bw + ox1, bh + oy1), new Vector3d(bw + ox1, sd2), new Vector3d(bw + ox1, 0.0 - oy1));
        CSG inner = Extrude.points(new Vector3d(0.0, 0.0, bottom_thickness), new Vector3d(0.0 + ox2, 0.0 + oy2), new Vector3d(0.0 + ox2, bh - oy2), new Vector3d(bw - ox2, bh - oy2), new Vector3d(bw - ox2, sd2 - oy2), new Vector3d(bw - ox2, 0.0 + oy2));
        return outer.difference(inner).transformed(Transform.unity().rotX(180.0).translateY(-bh));
    }

    public static CSG boardAndPegs() {
        double board_width = 85.6;
        double board_height = 56.0;
        double bw = board_width;
        double bh = board_height;
        double outer_offset = 4.0;
        double bottom_thickness = 3.0;
        CSG board = RaspberryPiBPlusMount.board();
        CSG peg1 = RaspberryPeg.peg().transformed(Transform.unity().scaleY(0.9)).transformed(Transform.unity().translate(0.0, bh - 36.0, -bottom_thickness));
        CSG peg2 = RaspberryPeg.peg().transformed(Transform.unity().scaleY(2.0)).transformed(Transform.unity().translate(22.0, bh, -bottom_thickness).rotZ(90.0));
        CSG peg3 = RaspberryPeg.peg().transformed(Transform.unity().translate(bw - outer_offset, bh, -bottom_thickness).rotZ(90.0));
        CSG peg4 = RaspberryPeg.peg().transformed(Transform.unity().translate(bw, bh - outer_offset * 2.0, -bottom_thickness).rotZ(180.0));
        CSG peg4b = RaspberryPeg.peg().transformed(Transform.unity().translate(bw, outer_offset, -bottom_thickness).rotZ(180.0));
        CSG peg5 = RaspberryPeg.peg().transformed(Transform.unity().scaleY(2.0)).transformed(Transform.unity().translate(bw - 19.0, 0.0, -bottom_thickness).rotZ(270.0));
        CSG peg6 = RaspberryPeg.peg().transformed(Transform.unity().translate(bw - 62.0, 0.0, -bottom_thickness).rotZ(270.0));
        CSG union = board.union(peg1, peg2, peg3, peg4, peg4b, peg5, peg6);
        return union;
    }

    public static void main(String[] args) throws IOException {
        CSG board = RaspberryPiBPlusMount.boardAndPegs().transformed(Transform.unity().rotX(180.0));
        FileUtil.write(Paths.get("raspberry-pi-bplus-mount-3mm.stl", new String[0]), board.toStlString());
        board.toObj().toFiles(Paths.get("raspberry-pi-bplus-mount-3mm.obj", new String[0]));
    }
}

