/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.samples.Hinge;
import java.io.IOException;
import java.nio.file.Paths;

public class SquareMail {
    private CSG toCSG(int numX, int numY) {
        double w = 10.0;
        double d = 2.2;
        double jointRadius = 1.1;
        double coneLength = 1.8;
        double hingeHoleScale = 1.15;
        double h = w;
        double pinLength = 0.8;
        double pinThickness = 1.2;
        CSG mainCube = new Cube(w, h, d).toCSG();
        Hinge hingePrototype = new Hinge().setJointRadius(jointRadius).setJointLength(pinThickness).setConeLength(coneLength);
        hingePrototype.setJointConnectionThickness(hingePrototype.getJointRadius() * 2.0);
        CSG hinge1 = hingePrototype.toCSG();
        Vector3d hingeBounds = hinge1.getBounds().getBounds();
        hinge1 = hinge1.intersect(new Cube(hingeBounds.x, Math.min(hingeBounds.y, d), hingeBounds.z).toCSG());
        hinge1 = hinge1.transformed(Transform.unity().rotX(90.0));
        CSG pin = new Cube(pinLength + hingePrototype.getJointRadius(), pinThickness, d).toCSG().transformed(Transform.unity().translateX(-(jointRadius + pinLength) * 0.5));
        hinge1 = hinge1.union(pin);
        hinge1 = hinge1.transformed(Transform.unity().translateX(w * 0.5 + hingePrototype.getJointRadius() + pinLength));
        CSG hinge2 = hinge1.transformed(Transform.unity().rotZ(90.0));
        CSG hingeHole1 = hinge1.transformed(Transform.unity().translateX(-w * 0.5 - hingePrototype.getJointRadius() - pinLength));
        hingeHole1 = hingeHole1.transformed(Transform.unity().scale(hingeHoleScale));
        hingeHole1 = hingeHole1.transformed(Transform.unity().translateX(-w * 0.5 + jointRadius * hingeHoleScale));
        CSG hingeHole2 = hingeHole1.transformed(Transform.unity().rotZ(90.0));
        CSG part = mainCube.union(hinge1, hinge2).difference(hingeHole1, hingeHole2);
        Vector3d partBounds = part.getBounds().getBounds();
        CSG result = null;
        for (int y = 0; y < numY; ++y) {
            for (int x = 0; x < numX; ++x) {
                double translateX = (-partBounds.x + jointRadius + jointRadius * hingeHoleScale) * (double)x;
                double translateY = (-partBounds.y + jointRadius + jointRadius * hingeHoleScale) * (double)y;
                CSG part2 = part.transformed(Transform.unity().translate(translateX, translateY, 0.0));
                if (result == null) {
                    result = part2.clone();
                }
                result = result.dumbUnion(part2);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("squaremail-test.stl", new String[0]), new SquareMail().toCSG(12, 4).toStlString());
    }
}

