/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.SVGOMAnimatedPathData;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.parser.PathHandler;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class SVGAnimatedPathDataSupport {
    public static final String D_DEFAULT_VALUE = "";

    public static SVGOMAnimatedPathData getAnimatedPathData(AbstractElement abstractElement) {
        SVGOMAnimatedPathData sVGOMAnimatedPathData = (SVGOMAnimatedPathData)abstractElement.getLiveAttributeValue(null, "d");
        if (sVGOMAnimatedPathData == null) {
            sVGOMAnimatedPathData = new SVGOMAnimatedPathData(abstractElement, null, "d", D_DEFAULT_VALUE);
            SVGOMDocument sVGOMDocument = (SVGOMDocument)abstractElement.getOwnerDocument();
            sVGOMAnimatedPathData.addAnimatedAttributeListener(sVGOMDocument.getAnimatedAttributeListener());
            abstractElement.putLiveAttributeValue(null, "d", sVGOMAnimatedPathData);
        }
        return sVGOMAnimatedPathData;
    }

    public static SVGPathSegList getPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getPathSegList();
    }

    public static SVGPathSegList getNormalizedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getNormalizedPathSegList();
    }

    public static SVGPathSegList getAnimatedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getAnimatedPathSegList();
    }

    public static SVGPathSegList getAnimatedNormalizedPathSegList(AbstractElement abstractElement) {
        return SVGAnimatedPathDataSupport.getAnimatedPathData(abstractElement).getAnimatedNormalizedPathSegList();
    }

    public static void handlePathSegList(SVGPathSegList sVGPathSegList, PathHandler pathHandler) {
        int n = sVGPathSegList.getNumberOfItems();
        pathHandler.startPath();
        block21: for (int i = 0; i < n; ++i) {
            SVGPathSeg sVGPathSeg = sVGPathSegList.getItem(i);
            switch (sVGPathSeg.getPathSegType()) {
                case 1: {
                    pathHandler.closePath();
                    continue block21;
                }
                case 2: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegMovetoAbs)sVGPathSeg;
                    pathHandler.movetoAbs(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 3: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegMovetoRel)sVGPathSeg;
                    pathHandler.movetoRel(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 4: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoAbs)sVGPathSeg;
                    pathHandler.linetoAbs(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 5: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoRel)sVGPathSeg;
                    pathHandler.linetoRel(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 6: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoCubicAbs)sVGPathSeg;
                    pathHandler.curvetoCubicAbs(sVGPathSeg2.getX1(), sVGPathSeg2.getY1(), sVGPathSeg2.getX2(), sVGPathSeg2.getY2(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 7: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoCubicRel)sVGPathSeg;
                    pathHandler.curvetoCubicRel(sVGPathSeg2.getX1(), sVGPathSeg2.getY1(), sVGPathSeg2.getX2(), sVGPathSeg2.getY2(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 8: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoQuadraticAbs)sVGPathSeg;
                    pathHandler.curvetoQuadraticAbs(sVGPathSeg2.getX1(), sVGPathSeg2.getY1(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 9: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoQuadraticRel)sVGPathSeg;
                    pathHandler.curvetoQuadraticRel(sVGPathSeg2.getX1(), sVGPathSeg2.getY1(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 10: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegArcAbs)sVGPathSeg;
                    pathHandler.arcAbs(sVGPathSeg2.getR1(), sVGPathSeg2.getR2(), sVGPathSeg2.getAngle(), sVGPathSeg2.getLargeArcFlag(), sVGPathSeg2.getSweepFlag(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 11: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegArcRel)sVGPathSeg;
                    pathHandler.arcRel(sVGPathSeg2.getR1(), sVGPathSeg2.getR2(), sVGPathSeg2.getAngle(), sVGPathSeg2.getLargeArcFlag(), sVGPathSeg2.getSweepFlag(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 12: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoHorizontalAbs)sVGPathSeg;
                    pathHandler.linetoHorizontalAbs(sVGPathSeg2.getX());
                    continue block21;
                }
                case 13: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoHorizontalRel)sVGPathSeg;
                    pathHandler.linetoHorizontalRel(sVGPathSeg2.getX());
                    continue block21;
                }
                case 14: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoVerticalAbs)sVGPathSeg;
                    pathHandler.linetoVerticalAbs(sVGPathSeg2.getY());
                    continue block21;
                }
                case 15: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegLinetoVerticalRel)sVGPathSeg;
                    pathHandler.linetoVerticalRel(sVGPathSeg2.getY());
                    continue block21;
                }
                case 16: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg;
                    pathHandler.curvetoCubicSmoothAbs(sVGPathSeg2.getX2(), sVGPathSeg2.getY2(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 17: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg;
                    pathHandler.curvetoCubicSmoothRel(sVGPathSeg2.getX2(), sVGPathSeg2.getY2(), sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 18: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg;
                    pathHandler.curvetoQuadraticSmoothAbs(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                    continue block21;
                }
                case 19: {
                    SVGPathSeg sVGPathSeg2 = (SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg;
                    pathHandler.curvetoQuadraticSmoothRel(sVGPathSeg2.getX(), sVGPathSeg2.getY());
                }
            }
        }
        pathHandler.endPath();
    }
}

