/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.Parser;
import org.kabeja.processing.PostProcessor;
import org.kabeja.processing.ProcessPipeline;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.event.ProcessingListener;
import org.kabeja.xml.SAXFilter;
import org.kabeja.xml.SAXGenerator;
import org.kabeja.xml.SAXSerializer;

public class ProcessingManager {
    private Map saxfilters = new HashMap();
    private Map saxserializers = new HashMap();
    private Map postprocessors = new HashMap();
    private Map pipelines = new HashMap();
    private Map saxgenerators = new HashMap();
    private List parsers = new ArrayList();

    public void addSAXFilter(SAXFilter sAXFilter, String string) {
        this.saxfilters.put(string, sAXFilter);
    }

    public SAXFilter getSAXFilter(String string) {
        return (SAXFilter)this.saxfilters.get(string);
    }

    public Map getSAXFilters() {
        return this.saxfilters;
    }

    public void addSAXSerializer(SAXSerializer sAXSerializer, String string) {
        this.saxserializers.put(string, sAXSerializer);
    }

    public SAXSerializer getSAXSerializer(String string) {
        return (SAXSerializer)this.saxserializers.get(string);
    }

    public Map getSAXSerializers() {
        return this.saxserializers;
    }

    public void addPostProcessor(PostProcessor postProcessor, String string) {
        this.postprocessors.put(string, postProcessor);
    }

    public void addParser(Parser parser) {
        this.parsers.add(parser);
    }

    public List getParsers() {
        return this.parsers;
    }

    protected Parser getParser(String string) {
        Iterator iterator = this.parsers.iterator();
        while (iterator.hasNext()) {
            Parser parser = (Parser)iterator.next();
            if (!parser.supportedExtension(string)) continue;
            return parser;
        }
        return null;
    }

    public PostProcessor getPostProcessor(String string) {
        return (PostProcessor)this.postprocessors.get(string);
    }

    public Map getPostProcessors() {
        return this.postprocessors;
    }

    public void addProcessPipeline(ProcessPipeline processPipeline) {
        processPipeline.setProcessorManager(this);
        this.pipelines.put(processPipeline.getName(), processPipeline);
    }

    public ProcessPipeline getProcessPipeline(String string) {
        return (ProcessPipeline)this.pipelines.get(string);
    }

    public Map getProcessPipelines() {
        return this.pipelines;
    }

    public void process(InputStream inputStream, String string, Map map, String string2, OutputStream outputStream) throws ProcessorException {
        Parser parser = this.getParser(string);
        if (parser != null) {
            try {
                parser.parse(inputStream, null);
                DXFDocument dXFDocument = parser.getDocument();
                this.process(dXFDocument, map, string2, outputStream);
            }
            catch (ParseException parseException) {
                throw new ProcessorException(parseException);
            }
        }
    }

    public void process(DXFDocument dXFDocument, Map map, String string, OutputStream outputStream) throws ProcessorException {
        if (!this.pipelines.containsKey(string)) {
            throw new ProcessorException("No pipeline found for name:" + string);
        }
        ProcessPipeline processPipeline = (ProcessPipeline)this.pipelines.get(string);
        processPipeline.prepare();
        processPipeline.process(dXFDocument, map, outputStream);
    }

    public void process(DXFDocument dXFDocument, Map map, String string, String string2) throws ProcessorException {
        if (this.pipelines.containsKey(string)) {
            try {
                ProcessPipeline processPipeline = (ProcessPipeline)this.pipelines.get(string);
                String string3 = processPipeline.getSAXSerializer().getSuffix();
                String string4 = string2.substring(0, string2.lastIndexOf(46) + 1) + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                this.process(dXFDocument, map, string, fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ProcessorException(fileNotFoundException);
            }
        } else {
            throw new ProcessorException("No pipeline found for name:" + string);
        }
    }

    public void addSAXGenerator(SAXGenerator sAXGenerator, String string) {
        this.saxgenerators.put(string, sAXGenerator);
    }

    public SAXGenerator getSAXGenerator(String string) {
        return (SAXGenerator)this.saxgenerators.get(string);
    }

    public Map getSAXGenerators() {
        return this.saxgenerators;
    }

    public void addProcessingListener(ProcessingListener processingListener) {
    }

    public void removeProcessingListener(ProcessingListener processingListener) {
    }
}

