/*
 * Decompiled with CFR 0.152.
 */
package dk.abj.svg.action;

import de.miethxml.toolkit.ui.UIUtils;
import dk.abj.svg.action.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.action.DXFDocumentAction;
import org.kabeja.svg.action.SVGDocumentAction;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class HighlightAction
extends AbstractAction
implements SVGDocumentAction,
EventListener,
ItemListener,
DXFDocumentAction {
    public static final String HIGHLIGHT_STYLE = "stroke:red;fill:blue;fill-opacity:0.25;stroke-width:0.15%";
    public static final String DEFAULT_STYLE = "stroke:black;stroke-width:0.15%";
    private Element elem;
    private Element oldElem;
    private Element labelID;
    private Node text;
    private String oldStyle;
    private DXFDocument dxfDocument;
    protected double STROKE_WIDTH_PRECENTS = 0.002;
    protected double strokeWidth = 0.5;
    protected double fontSize = 12.0;
    protected double highlightStrokeWidth = 1.0;
    protected boolean activated = false;
    static /* synthetic */ Class class$dk$abj$svg$action$HighlightAction;

    public HighlightAction() {
        super("Highlight", new ImageIcon(UIUtils.resourceToBytes((Class)(class$dk$abj$svg$action$HighlightAction == null ? (class$dk$abj$svg$action$HighlightAction = HighlightAction.class$("dk.abj.svg.action.HighlightAction")) : class$dk$abj$svg$action$HighlightAction), (String)"/icons/highlight.png"), Messages.getString("editor.action.highlight")));
    }

    public HighlightAction(String b) {
        super(b);
    }

    public void handleEvent(Event evt) {
        if (this.activated) {
            this.oldElem = this.elem;
            this.elem = (Element)((Object)evt.getTarget());
            if (evt.getType().equals("mouseover")) {
                if (evt.getEventPhase() == 2) {
                    if (this.oldElem != null) {
                        this.unHighlight(this.oldElem);
                    }
                    this.highlight(this.elem);
                    this.showHandle(evt, this.elem);
                }
            } else if (evt.getEventPhase() == 2) {
                this.unHighlight(this.elem);
            }
        }
    }

    protected void highlight(Element el) {
        this.oldStyle = el.getAttribute("style");
        el.setAttribute("style", HIGHLIGHT_STYLE);
    }

    protected void unHighlight(Element el) {
        el.setAttribute("style", this.oldStyle);
        this.labelID.setAttributeNS(null, "visibility", "hidden");
    }

    public void setDocument(SVGDocument doc) {
        Element el = doc.getElementById("draft");
        this.prepare(el.getChildNodes());
        String svgNS = "http://www.w3.org/2000/svg";
        String s = doc.getDocumentElement().getAttribute("viewBox");
        String[] data = s.split("\\s+");
        double y = Double.parseDouble(data[1]);
        double width = Double.parseDouble(data[2]);
        this.fontSize = width / 5.0;
        this.labelID = doc.createElementNS(svgNS, "text");
        this.labelID.setAttributeNS(null, "x", data[0]);
        this.labelID.setAttributeNS(null, "y", "" + (y + this.fontSize));
        this.labelID.setAttributeNS(null, "style", "stroke-width:12pt");
        this.labelID.setAttributeNS(null, "visibility", "hidden");
        this.text = doc.createTextNode("Handle");
        this.labelID.appendChild(this.text);
        doc.getDocumentElement().insertBefore(this.labelID, doc.getDocumentElement().getFirstChild());
    }

    public void prepare(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node instanceof EventTarget && !node.getNodeName().equals("g")) {
                EventTarget t = (EventTarget)((Object)node);
                t.addEventListener("mouseover", this, false);
                t.addEventListener("mouseout", this, false);
            }
            if (!node.hasChildNodes()) continue;
            this.prepare(node.getChildNodes());
        }
    }

    protected void initStrokeWidth() {
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        this.activated = e.getStateChange() == 1;
    }

    protected void showHandle(Event e, Element el) {
        String handle = SVGUtils.reverseID(el.getAttribute("id"));
        DXFEntity entity = this.dxfDocument.getDXFEntityByID(handle);
        System.out.println("Selected Entity=" + handle);
        if (entity != null) {
            System.out.println("Selected Entity-type=" + entity.getType());
        } else {
            System.out.println("No entity found for handle=" + handle);
        }
    }

    public void setDXFDocument(DXFDocument doc) {
        this.dxfDocument = doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

