/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.batik.tools;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.kabeja.xml.AbstractSAXFilter;
import org.kabeja.xml.SAXSerializer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSAXSerializer
extends AbstractSAXFilter
implements SAXSerializer {
    public static final String SUFFIX_JPEG = "jpg";
    public static final String SUFFIX_PNG = "png";
    public static final String SUFFIX_TIFF = "tif";
    public static final String SUFFIX_PDF = "pdf";
    public static final String MIME_TYPE_JPEG = "image/jepg";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_TIFF = "image/tiff";
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_DPI = "dpi";
    public static final String PROPERTY_QUALITY = "quality";
    public static final String PROPERTY_PAPER = "paper";
    public static final String PROPERTY_ORIENTATION = "orientation";
    public static final float INCH_TO_MM = 25.4f;
    public static final float PT_TO_MM = 0.35277778f;
    public int DPI = 96;
    public float PIXEL_UNIT_TO_MM = 25.4f / (float)this.DPI;
    protected OutputStream out;
    protected float width;
    protected float height;
    protected double quality = 0.9;
    protected Transcoder transcoder;
    protected boolean scaleToFit = true;
    protected Document document;

    protected abstract Transcoder createTranscoder();

    public void setProperties(Map properties) {
        String orientation;
        if (properties.containsKey(PROPERTY_DPI)) {
            this.DPI = Integer.parseInt((String)properties.get(PROPERTY_DPI));
            this.PIXEL_UNIT_TO_MM = 25.4f / (float)this.DPI;
        }
        if (properties.containsKey(PROPERTY_PAPER)) {
            this.parsePaper(((String)properties.get(PROPERTY_PAPER)).toLowerCase());
        }
        if (properties.containsKey(PROPERTY_QUALITY)) {
            this.quality = Double.parseDouble((String)properties.get(PROPERTY_QUALITY));
        }
        if (properties.containsKey(PROPERTY_WIDTH)) {
            this.width = this.unitsToPixel(((String)properties.get(PROPERTY_WIDTH)).trim());
        }
        if (properties.containsKey(PROPERTY_HEIGHT)) {
            this.height = this.unitsToPixel(((String)properties.get(PROPERTY_HEIGHT)).trim());
        }
        if (properties.containsKey(PROPERTY_ORIENTATION) && (orientation = ((String)properties.get(PROPERTY_ORIENTATION)).toLowerCase()).equals("landscape")) {
            float w = this.width;
            this.width = this.height;
            this.height = w;
        }
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.transcoder = this.createTranscoder();
            this.setupTranscoder(this.transcoder);
            TranscoderInput transInput = new TranscoderInput(this.document);
            TranscoderOutput transOutput = new TranscoderOutput(this.out);
            this.setupTranscoder(this.transcoder);
            this.transcode(transInput, transOutput);
        }
        catch (TranscoderException e) {
            throw new SAXException(e);
        }
    }

    protected void setupTranscoder(Transcoder t) {
        this.transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, new Float(this.PIXEL_UNIT_TO_MM));
        if ((double)this.width > 0.0) {
            this.transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(this.width));
        }
        if ((double)this.height > 0.0) {
            this.transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(this.height));
        }
    }

    public void startDocument() throws SAXException {
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler f = factory.newTransformerHandler();
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            f.setResult(new DOMResult(this.document));
            super.setContentHandler((ContentHandler)f);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SAXException(e.getException());
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        super.startDocument();
    }

    protected void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        this.transcoder.transcode(input, output);
    }

    protected float unitsToPixel(String size) {
        if (size.endsWith("px")) {
            return Float.parseFloat(size.substring(0, size.length() - 2));
        }
        if (size.endsWith("in")) {
            return Float.parseFloat(size.substring(0, size.length() - 2)) * 25.4f / this.PIXEL_UNIT_TO_MM;
        }
        if (size.endsWith("pt")) {
            return Float.parseFloat(size.substring(0, size.length() - 2)) * 0.35277778f / this.PIXEL_UNIT_TO_MM;
        }
        if (size.endsWith("cm")) {
            float units = Float.parseFloat(size.substring(0, size.length() - 2));
            float pixel = units * 100.0f / this.PIXEL_UNIT_TO_MM;
            return pixel;
        }
        if (size.endsWith("mm")) {
            float units = Float.parseFloat(size.substring(0, size.length() - 2));
            float pixel = units / this.PIXEL_UNIT_TO_MM;
            return pixel;
        }
        if (size.endsWith("m")) {
            float units = Float.parseFloat(size.substring(0, size.length() - 1));
            float pixel = units * 1000.0f / this.PIXEL_UNIT_TO_MM;
            return pixel;
        }
        return Float.parseFloat(size);
    }

    protected void parsePaper(String paper) {
        if (paper.equals("a0")) {
            this.width = 841.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 1189.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a1")) {
            this.width = 594.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 841.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a2")) {
            this.width = 420.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 594.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a3")) {
            this.width = 297.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 420.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a4")) {
            this.width = 210.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 297.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a5")) {
            this.width = 148.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 210.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("a6")) {
            this.width = 105.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 148.0f / this.PIXEL_UNIT_TO_MM;
        } else if (paper.equals("letter")) {
            this.width = 216.0f / this.PIXEL_UNIT_TO_MM;
            this.height = 279.0f / this.PIXEL_UNIT_TO_MM;
        }
    }

    public Map getProperties() {
        return this.properties;
    }
}

