/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg;

import org.kabeja.svg.SVGUtils;
import org.kabeja.xml.AbstractSAXFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class StyleAttributeFilter
extends AbstractSAXFilter {
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        StringBuffer buf = new StringBuffer();
        boolean colorFound = false;
        String color = "currentColor";
        for (int i = 0; i < atts.getLength(); ++i) {
            String bs;
            String gs;
            String value;
            if (atts.getLocalName(i).equals("fill")) {
                buf.append("fill");
                buf.append(':');
                buf.append(atts.getValue(i));
                buf.append(';');
            } else if (atts.getLocalName(i).equals("stroke")) {
                colorFound = true;
            } else if (atts.getLocalName(i).equals("stroke-width")) {
                buf.append("stroke-width");
                buf.append(':');
                buf.append(atts.getValue(i));
                buf.append(';');
            } else {
                attributes.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
            }
            if (!atts.getLocalName(i).equals("color") || !(value = atts.getValue(i).trim()).startsWith("rgb(")) continue;
            int index = 4;
            int end = value.indexOf(44);
            int r = Integer.parseInt(value.substring(index, end));
            index = end + 1;
            end = value.indexOf(44, index);
            int g = Integer.parseInt(value.substring(index, end));
            index = end + 1;
            int b = Integer.parseInt(value.substring(index, value.length() - 1));
            String rs = Integer.toHexString(r);
            if (rs.length() == 1) {
                rs = "0" + rs;
            }
            if ((gs = Integer.toHexString(g)).length() == 1) {
                gs = "0" + gs;
            }
            if ((bs = Integer.toHexString(b)).length() == 1) {
                bs = "0" + bs;
            }
            color = "#" + rs + gs + bs;
            index = 0;
        }
        if (colorFound) {
            buf.append("stroke");
            buf.append(':');
            buf.append(color);
            buf.append(';');
        }
        if (buf.length() > 0) {
            SVGUtils.addAttribute(attributes, "style", buf.toString());
        }
        super.startElement(uri, localName, name, (Attributes)attributes);
    }
}

