/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.ui;

import de.miethxml.toolkit.gui.JGoodiesSeparator;
import de.miethxml.toolkit.ui.UIUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.kabeja.ui.ApplicationToolBar;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.impl.AbstractPropertiesEditor;

public class OutputSettingsUI
extends AbstractPropertiesEditor
implements Serviceable,
org.kabeja.ui.Component {
    private String[] papers = new String[]{"NoPapper", "A0", "A1", "A2", "A3", "A4", "A5", "A6", "Letter"};
    private String[] units = new String[]{"inch", "mm", "px"};
    private String[] layout = new String[]{"Modelspace", "Modelspace-Limits", "Paperspace", "Paperspace-Limits"};
    private JDialog dialog;
    protected JCheckBox customPaper;
    protected JTextField widthField;
    protected JTextField heightField;
    protected JComboBox unitSelection;
    protected JComboBox paperSelection;
    protected JComboBox layoutSelection;
    protected JRadioButton landscapeSelection;
    protected boolean initialized = false;

    public void setServiceManager(ServiceManager manager) {
        org.kabeja.ui.Component[] objects = manager.getServiceComponents(ApplicationToolBar.SERVICE);
        for (int i = 0; i < objects.length; ++i) {
            ((ApplicationToolBar)objects[i]).addAction((Action)new AbstractAction("Output Settings", new ImageIcon(UIUtils.resourceToBytes(((Object)((Object)this)).getClass(), (String)"/icons/paper_settings.gif"))){

                public void actionPerformed(ActionEvent e) {
                    OutputSettingsUI.this.showDialog();
                }
            });
        }
    }

    protected void init() {
        if (!this.initialized) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
            panel.add((Component)new JGoodiesSeparator("Paper Size"), this.createConstraints(0, 0, 3, 1, 2, 10, new Insets(0, 0, 8, 5)));
            panel.add((Component)new JLabel("Paper"), this.createConstraints(0, 1, 1, 1, 0, 13));
            this.paperSelection = new JComboBox<String>(this.papers);
            panel.add((Component)this.paperSelection, this.createConstraints(1, 1, 2, 1, 2, 17));
            panel.add((Component)new JLabel("Custom Paper"), this.createConstraints(0, 2, 1, 1, 0, 13, new Insets(8, 0, 1, 0)));
            this.customPaper = new JCheckBox();
            this.customPaper.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    OutputSettingsUI.this.enableCustomPaper(e.getStateChange() == 1);
                }
            });
            panel.add((Component)this.customPaper, this.createConstraints(1, 2, 1, 1, 0, 17, new Insets(8, 0, 1, 0)));
            panel.add((Component)new JLabel("Unit"), this.createConstraints(0, 3, 1, 1, 0, 13));
            this.unitSelection = new JComboBox<String>(this.units);
            panel.add((Component)this.unitSelection, this.createConstraints(1, 3, 2, 1, 2, 17));
            panel.add((Component)new JLabel("Width"), this.createConstraints(0, 4, 1, 1, 0, 13));
            this.widthField = new JTextField(20);
            panel.add((Component)this.widthField, this.createConstraints(1, 4, 2, 1, 1, 17));
            panel.add((Component)new JLabel("Height"), this.createConstraints(0, 5, 1, 1, 0, 13));
            this.heightField = new JTextField(20);
            panel.add((Component)this.heightField, this.createConstraints(1, 5, 2, 1, 2, 17));
            panel.add((Component)new JGoodiesSeparator("Orientation"), this.createConstraints(0, 6, 3, 1, 2, 10, new Insets(25, 0, 1, 5)));
            ButtonGroup group = new ButtonGroup();
            this.landscapeSelection = new JRadioButton("Landscape");
            group.add(this.landscapeSelection);
            panel.add((Component)this.landscapeSelection, this.createConstraints(1, 7, 2, 1, 2, 17));
            JRadioButton b = new JRadioButton("Portrait");
            b.setSelected(true);
            group.add(b);
            panel.add((Component)b, this.createConstraints(1, 8, 2, 1, 2, 17));
            panel.add((Component)new JGoodiesSeparator("Layout"), this.createConstraints(0, 9, 3, 1, 2, 10, new Insets(25, 0, 1, 5)));
            this.layoutSelection = new JComboBox<String>(this.layout);
            panel.add((Component)this.layoutSelection, this.createConstraints(1, 10, 2, 1, 2, 17));
            JButton button = new JButton("OK");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OutputSettingsUI.this.dialog.setVisible(false);
                            OutputSettingsUI.this.updateProperties();
                        }
                    });
                }
            });
            panel.add((Component)button, this.createConstraints(2, 11, 1, 1, 0, 13, new Insets(12, 0, 1, 0)));
            this.enableCustomPaper(false);
            this.dialog = new JDialog();
            this.dialog.setTitle("Paper Selection");
            this.dialog.getContentPane().add((Component)panel, "North");
            this.dialog.pack();
            this.initialized = true;
        }
    }

    public void showDialog() {
        this.init();
        this.dialog.setVisible(true);
    }

    protected GridBagConstraints createConstraints(int x, int y, int width, int height, int fill, int anchor) {
        return this.createConstraints(x, y, width, height, fill, anchor, new Insets(1, 0, 1, 0));
    }

    protected GridBagConstraints createConstraints(int x, int y, int width, int height, int fill, int anchor, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.ipadx = 9;
        gbc.ipady = 6;
        if (fill != 0) {
            gbc.weightx = 100.0;
        }
        gbc.weighty = 0.0;
        gbc.insets = insets;
        return gbc;
    }

    protected void updateProperties() {
        if (this.customPaper.isSelected()) {
            this.properties.put("paper", "NoPaper");
            this.properties.put("width", this.widthField.getText() + this.unitSelection.getSelectedItem());
            this.properties.put("height", this.heightField.getText() + this.unitSelection.getSelectedItem());
        } else {
            this.properties.put("paper", this.paperSelection.getSelectedItem());
        }
        if (this.landscapeSelection.isSelected()) {
            this.properties.put("orientation", "landscape");
        } else {
            this.properties.put("orientation", "portait");
        }
        this.properties.put("bounds-rule", this.layoutSelection.getSelectedItem().toString());
        this.firePropertiesChangedEvent();
    }

    protected void enableCustomPaper(boolean b) {
        this.paperSelection.setEnabled(!b);
        this.unitSelection.setEnabled(b);
        this.widthField.setEnabled(b);
        this.heightField.setEnabled(b);
    }
}

