/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.Stack;
import java.util.StringTokenizer;
import org.kabeja.dxf.DXFMText;
import org.kabeja.dxf.DXFText;
import org.kabeja.dxf.helpers.DXFUtils;
import org.kabeja.dxf.helpers.StyledTextParagraph;
import org.kabeja.dxf.helpers.TextDocument;

public class DXFTextParser {
    public static TextDocument parseDXFMText(DXFMText dXFMText) {
        TextDocument textDocument = new TextDocument();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StyledTextParagraph styledTextParagraph = new StyledTextParagraph();
        styledTextParagraph.setFontHeight(dXFMText.getHeight());
        styledTextParagraph.setInsertPoint(dXFMText.getInsertPoint());
        switch (dXFMText.getAlignment()) {
            case 1: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 2: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 3: {
                styledTextParagraph.setValign(2);
                break;
            }
            case 4: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 5: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 6: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 7: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 8: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 9: {
                styledTextParagraph.setValign(1);
                break;
            }
            default: {
                styledTextParagraph.setValign(1);
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Stack<StyledTextParagraph> stack = new Stack<StyledTextParagraph>();
        int n = 0;
        String string = dXFMText.getText();
        char c = ' ';
        string = DXFTextParser.parseSymbols(string);
        block24: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\\': {
                    if (bl) {
                        if (!bl3) {
                            DXFTextParser.parseStyledTextParagraphSettings(c, stringBuffer2.toString(), styledTextParagraph);
                            stringBuffer2.delete(0, stringBuffer2.length());
                            bl = true;
                            bl2 = true;
                            continue block24;
                        }
                        stringBuffer.append(c2);
                        bl = false;
                        continue block24;
                    }
                    bl = true;
                    bl2 = true;
                    bl3 = false;
                    continue block24;
                }
                case '~': {
                    if (!bl) continue block24;
                    stringBuffer.append(c2);
                    bl = false;
                    bl2 = false;
                    continue block24;
                }
                case ';': {
                    if (bl) {
                        DXFTextParser.parseStyledTextParagraphSettings(c, stringBuffer2.toString(), styledTextParagraph);
                        stringBuffer2.delete(0, stringBuffer2.length());
                        bl = false;
                        bl3 = true;
                        bl2 = false;
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case '}': {
                    if (bl && bl2) {
                        stringBuffer.append(c2);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    textDocument.addStyledParagraph(styledTextParagraph);
                    styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                    if (stack.size() <= 0) continue block24;
                    styledTextParagraph = (StyledTextParagraph)stack.pop();
                    continue block24;
                }
                case '{': {
                    if (bl && bl2) {
                        stringBuffer.append(c2);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    if (i == 0) continue block24;
                    stack.add(styledTextParagraph);
                    styledTextParagraph = new StyledTextParagraph();
                    continue block24;
                }
                case 'O': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setOverline(true);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case 'o': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setOverline(false);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case 'u': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(false);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case 'L': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(true);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case 'l': {
                    if (bl && bl2) {
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        styledTextParagraph.setUnderline(false);
                        bl = false;
                        bl2 = false;
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                case 'P': {
                    if (bl && bl2) {
                        ++n;
                        styledTextParagraph.setText(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        textDocument.addStyledParagraph(styledTextParagraph);
                        styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                        bl = false;
                        bl2 = false;
                        styledTextParagraph.setLineIndex(n);
                        styledTextParagraph.setNewline(true);
                        continue block24;
                    }
                    if (bl) {
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                    continue block24;
                }
                default: {
                    if (bl) {
                        if (bl2) {
                            c = c2;
                            bl2 = false;
                            continue block24;
                        }
                        stringBuffer2.append(c2);
                        continue block24;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        if (bl) {
            DXFTextParser.parseStyledTextParagraphSettings(c, stringBuffer2.toString(), styledTextParagraph);
        }
        if (stringBuffer.length() > 0) {
            styledTextParagraph.setText(stringBuffer.toString());
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        if (textDocument.getParagraphCount() == 0) {
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        return textDocument;
    }

    protected static StyledTextParagraph createParagraphFromParent(StyledTextParagraph styledTextParagraph) {
        StyledTextParagraph styledTextParagraph2 = new StyledTextParagraph();
        styledTextParagraph2.setValign(styledTextParagraph.getValign());
        styledTextParagraph2.setBold(styledTextParagraph.isBold());
        styledTextParagraph2.setFont(styledTextParagraph.getFont());
        styledTextParagraph2.setItalic(styledTextParagraph.isItalic());
        styledTextParagraph2.setUnderline(styledTextParagraph.isUnderline());
        styledTextParagraph2.setOverline(styledTextParagraph.isOverline());
        styledTextParagraph2.setWidth(styledTextParagraph.getWidth());
        styledTextParagraph2.setFontHeight(styledTextParagraph.getFontHeight());
        styledTextParagraph2.setInsertPoint(styledTextParagraph.getInsertPoint());
        return styledTextParagraph2;
    }

    public static TextDocument parseDXFText(DXFText dXFText) {
        TextDocument textDocument = new TextDocument();
        StringBuffer stringBuffer = new StringBuffer();
        StyledTextParagraph styledTextParagraph = new StyledTextParagraph();
        styledTextParagraph.setFontHeight(dXFText.getHeight());
        styledTextParagraph.setInsertPoint(dXFText.getAlignmentPoint());
        switch (dXFText.getValign()) {
            case 0: {
                if (dXFText.getAlign() == 4) {
                    styledTextParagraph.setValign(4);
                    break;
                }
                styledTextParagraph.setValign(1);
                break;
            }
            case 1: {
                styledTextParagraph.setValign(1);
                break;
            }
            case 2: {
                styledTextParagraph.setValign(4);
                break;
            }
            case 3: {
                styledTextParagraph.setValign(2);
            }
        }
        if (dXFText.getAlign() == 3 || dXFText.getAlign() == 5) {
            double d = DXFUtils.distance(dXFText.getInsertPoint(), dXFText.getAlignmentPoint());
            styledTextParagraph.setWidth(d);
        }
        String string = DXFTextParser.parseSymbols(dXFText.getText());
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                ++n;
                continue;
            }
            if (n == 0) {
                stringBuffer.append(c);
                continue;
            }
            if (n != 2) continue;
            switch (c) {
                case 'o': {
                    styledTextParagraph.setText(stringBuffer.toString());
                    styledTextParagraph.setUnderline(bl2);
                    styledTextParagraph.setOverline(bl);
                    textDocument.addStyledParagraph(styledTextParagraph);
                    styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                    stringBuffer.delete(0, stringBuffer.length());
                    bl = !bl;
                    styledTextParagraph.setOverline(bl);
                    break;
                }
                case 'u': {
                    styledTextParagraph.setText(stringBuffer.toString());
                    styledTextParagraph.setUnderline(bl2);
                    styledTextParagraph.setOverline(bl);
                    textDocument.addStyledParagraph(styledTextParagraph);
                    styledTextParagraph = DXFTextParser.createParagraphFromParent(styledTextParagraph);
                    stringBuffer.delete(0, stringBuffer.length());
                    bl2 = !bl2;
                    styledTextParagraph.setUnderline(bl2);
                }
            }
            n = 0;
        }
        if (n == 1 || n == 3) {
            stringBuffer.append('%');
        }
        if (stringBuffer.length() > 0) {
            styledTextParagraph.setText(stringBuffer.toString());
            textDocument.addStyledParagraph(styledTextParagraph);
        }
        return textDocument;
    }

    public static void parseStyledTextParagraphSettings(char c, String string, StyledTextParagraph styledTextParagraph) {
        switch (c) {
            case 'A': {
                styledTextParagraph.setValign(Integer.parseInt(string));
                break;
            }
            case 'H': {
                if (string.endsWith("x")) {
                    styledTextParagraph.setFontHeight(styledTextParagraph.getFontHeight() * Double.parseDouble(string.substring(0, string.length() - 1)));
                    break;
                }
                styledTextParagraph.setFontHeight(Double.parseDouble(string));
                break;
            }
            case 'Q': {
                styledTextParagraph.setObliquiAngle(Double.parseDouble(string));
                break;
            }
            case 'W': {
                styledTextParagraph.setWidth(Double.parseDouble(string));
                break;
            }
            case 'T': {
                styledTextParagraph.setCharacterspace(Double.parseDouble(string));
                break;
            }
            case 'f': {
                DXFTextParser.parseFontSettings(string.trim(), styledTextParagraph);
                break;
            }
            case 'F': {
                styledTextParagraph.setFontFile(string.trim());
                break;
            }
        }
    }

    public static void parseFontSettings(String string, StyledTextParagraph styledTextParagraph) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        styledTextParagraph.setFont(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            char c = string2.charAt(0);
            int n = Integer.parseInt(string2.substring(1));
            switch (c) {
                case 'b': {
                    styledTextParagraph.setBold(n == 1);
                    break;
                }
                case 'i': {
                    styledTextParagraph.setItalic(n == 1);
                    break;
                }
                case 'c': {
                    break;
                }
            }
        }
    }

    public static String parseSymbols(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (c == '%') {
                if (n == 2) {
                    stringBuffer.append('%');
                    n = 0;
                    continue;
                }
                ++n;
                continue;
            }
            if (c == '^') {
                bl = true;
                continue;
            }
            if (bl) {
                if (Character.isWhitespace(c)) {
                    stringBuffer.append('^');
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                if (string.length() > i + 6 && string.charAt(i + 1) == 'U' && string.charAt(i + 2) == '+') {
                    string2 = string.substring(i + 3, i + 7);
                    int n2 = Integer.parseInt(string2, 16);
                    stringBuffer.append((char)n2);
                    i += 6;
                    continue;
                }
                stringBuffer.append('\\');
                continue;
            }
            if (n == 0) {
                stringBuffer.append(c);
                continue;
            }
            if (n == 1) {
                stringBuffer.append('%');
                n = 0;
                continue;
            }
            if (n == 2) {
                switch (c) {
                    case 'd': {
                        stringBuffer.append('\u00b0');
                        break;
                    }
                    case 'c': {
                        stringBuffer.append('\u2205');
                        break;
                    }
                    case 'p': {
                        stringBuffer.append('\u00b1');
                        break;
                    }
                    default: {
                        if (Character.isDigit(c) && i + 2 < string.length()) {
                            string2 = "" + c + string.charAt(i + 1) + string.charAt(i + 2);
                            try {
                                c = (char)Integer.parseInt(string2);
                                stringBuffer.append(c);
                                i += 2;
                            }
                            catch (NumberFormatException numberFormatException) {
                                stringBuffer.append('?');
                                ++i;
                            }
                            break;
                        }
                        stringBuffer.append("%%");
                        stringBuffer.append(c);
                    }
                }
                n = 0;
                continue;
            }
            if (n != 3) continue;
            stringBuffer.append('%');
            n = 0;
        }
        if (n == 1 || n == 3) {
            stringBuffer.append('%');
        }
        return stringBuffer.toString();
    }
}

