/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.DXFSectionHandler;
import org.kabeja.parser.DXFValue;
import org.kabeja.parser.Handler;
import org.kabeja.parser.HandlerManager;
import org.kabeja.parser.ParseException;
import org.kabeja.parser.Parser;
import org.kabeja.parser.dxf.DXFHandler;
import org.kabeja.parser.dxf.filter.DXFStreamFilter;
import org.kabeja.tools.CodePageParser;

public class DXFParser
implements HandlerManager,
Handler,
Parser,
DXFHandler {
    public static final String PARSER_NAME = "DXFParser";
    public static final String EXTENSION = "dxf";
    private static final String SECTION_START = "SECTION";
    private static final String SECTION_END = "ENDSEC";
    private static final String END_STREAM = "EOF";
    private static final int COMMAND_CODE = 0;
    public static final String DEFAULT_ENCODING = "";
    protected DXFDocument doc;
    protected Hashtable handlers = new Hashtable();
    protected DXFSectionHandler currentHandler;
    private String line;
    protected List streamFilters = new ArrayList();
    protected DXFHandler filter;
    private boolean key = false;
    private boolean sectionstarts = false;
    private int linecount;
    private boolean parse = false;

    public void parse(String string) throws ParseException {
        this.parse(string, DEFAULT_ENCODING);
    }

    public void parse(String string, String string2) throws ParseException {
        try {
            this.parse(new FileInputStream(string), string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public void parse(InputStream inputStream, String string) throws ParseException {
        String string2 = DEFAULT_ENCODING;
        this.key = false;
        this.linecount = 0;
        this.parse = false;
        this.doc = new DXFDocument();
        this.doc.setProperty(DXFDocument.PROPERTY_ENCODING, string);
        this.buildFilterChain();
        BufferedReader bufferedReader = null;
        try {
            if (DEFAULT_ENCODING.equals(string)) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(9000);
                try {
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(bufferedInputStream));
                    CodePageParser codePageParser = new CodePageParser();
                    string = codePageParser.parseEncoding(bufferedReader2);
                    bufferedInputStream.reset();
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string));
                }
                catch (IOException iOException) {
                    bufferedInputStream.reset();
                    bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                }
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            }
            this.key = true;
            this.sectionstarts = false;
            while ((this.line = bufferedReader.readLine()) != null) {
                ++this.linecount;
                if (this.key) {
                    string2 = this.line;
                    this.key = false;
                    continue;
                }
                int n = Integer.parseInt(string2.trim());
                this.filter.parseGroup(n, new DXFValue(this.line.trim()));
                this.key = true;
            }
            bufferedReader.close();
            bufferedReader = null;
            if (this.parse) {
                this.currentHandler.endSection();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    public void parseGroup(int n, DXFValue dXFValue) throws ParseException {
        try {
            if (this.sectionstarts) {
                this.sectionstarts = false;
                if (this.handlers.containsKey(dXFValue.getValue())) {
                    this.currentHandler = (DXFSectionHandler)this.handlers.get(dXFValue.getValue());
                    this.parse = true;
                    this.currentHandler.setDXFDocument(this.doc);
                    this.currentHandler.startSection();
                } else {
                    this.parse = false;
                }
                return;
            }
            if (n == 0 && SECTION_START.equals(dXFValue.getValue()) && !this.sectionstarts) {
                this.sectionstarts = true;
            }
            if (n == 0 && SECTION_END.equals(dXFValue.getValue())) {
                if (this.parse) {
                    this.currentHandler.endSection();
                }
                this.parse = false;
                return;
            }
            if (this.parse) {
                this.currentHandler.parseGroup(n, dXFValue);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new ParseException("Line: " + this.linecount + " unsupported groupcode: " + this.key + " for value:" + dXFValue, numberFormatException);
        }
    }

    public DXFDocument getDocument() {
        return this.doc;
    }

    public void addDXFSectionHandler(DXFSectionHandler dXFSectionHandler) {
        dXFSectionHandler.setDXFDocument(this.doc);
        this.handlers.put(dXFSectionHandler.getSectionKey(), dXFSectionHandler);
    }

    public void addHandler(Handler handler) {
        this.addDXFSectionHandler((DXFSectionHandler)handler);
    }

    public void releaseDXFDocument() {
        this.doc = null;
        Iterator iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            Handler handler = (Handler)iterator.next();
            handler.releaseDXFDocument();
        }
    }

    public void setDXFDocument(DXFDocument dXFDocument) {
        this.doc = dXFDocument;
    }

    public boolean supportedExtension(String string) {
        return string.toLowerCase().equals(EXTENSION);
    }

    public void addDXFStreamFilter(DXFStreamFilter dXFStreamFilter) {
        this.streamFilters.add(dXFStreamFilter);
    }

    public void removeDXFStreamFilter(DXFStreamFilter dXFStreamFilter) {
        this.streamFilters.remove(dXFStreamFilter);
    }

    protected void buildFilterChain() {
        DXFHandler dXFHandler = this;
        for (int i = this.streamFilters.size() - 1; i >= 0; --i) {
            DXFStreamFilter dXFStreamFilter = (DXFStreamFilter)this.streamFilters.get(i);
            dXFStreamFilter.setDXFHandler(dXFHandler);
            dXFHandler = dXFStreamFilter;
        }
        this.filter = dXFHandler;
    }

    public String getName() {
        return PARSER_NAME;
    }
}

