/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.processing.PostProcessorConfig;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.processing.ProcessorException;
import org.kabeja.processing.helper.MergeMap;
import org.kabeja.tools.SAXFilterConfig;
import org.kabeja.xml.SAXGenerator;
import org.kabeja.xml.SAXSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProcessPipeline {
    private ProcessingManager manager;
    private List postProcessorConfigs = new ArrayList();
    private List saxFilterConfigs = new ArrayList();
    private SAXGenerator generator;
    private Map serializerProperties = new HashMap();
    private Map generatorProperties = new HashMap();
    private SAXSerializer serializer;
    private String name;
    private String description = "";

    public void process(DXFDocument dXFDocument, Map map, OutputStream outputStream) throws ProcessorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = null;
        Iterator iterator = this.postProcessorConfigs.iterator();
        while (iterator.hasNext()) {
            object4 = (PostProcessorConfig)iterator.next();
            object3 = this.manager.getPostProcessor(((PostProcessorConfig)object4).getPostProcessorName());
            object2 = object3.getProperties();
            object3.setProperties(new MergeMap(((PostProcessorConfig)object4).getProperties(), map));
            object3.process(dXFDocument, map);
            object3.setProperties((Map)object2);
        }
        object4 = new ArrayList();
        if (this.saxFilterConfigs.size() > 0) {
            iterator = this.saxFilterConfigs.iterator();
            object3 = (SAXFilterConfig)iterator.next();
            object2 = this.manager.getSAXFilter(((SAXFilterConfig)object3).getFilterName());
            object4.add(new MergeMap(object2.getProperties(), map));
            object2.setContentHandler(this.serializer);
            object5 = object2;
            object2.setProperties(((SAXFilterConfig)object3).getProperties());
            while (iterator.hasNext()) {
                object3 = (SAXFilterConfig)iterator.next();
                object = this.manager.getSAXFilter(((SAXFilterConfig)object3).getFilterName());
                object.setContentHandler((ContentHandler)object2);
                object4.add(object.getProperties());
                object.setProperties(((SAXFilterConfig)object3).getProperties());
                object2 = object;
            }
        } else {
            object5 = this.serializer;
        }
        object3 = this.serializer.getProperties();
        this.serializer.setProperties(new MergeMap(this.serializerProperties, map));
        this.serializer.setOutput(outputStream);
        try {
            object2 = this.generator.getProperties();
            this.generator.setProperties(this.generatorProperties);
            this.generator.generate(dXFDocument, (ContentHandler)object5, map);
            this.generator.setProperties((Map)object2);
        }
        catch (SAXException sAXException) {
            throw new ProcessorException(sAXException);
        }
        this.serializer.setProperties((Map)object3);
        for (int i = 0; i < object4.size(); ++i) {
            object = (SAXFilterConfig)this.saxFilterConfigs.get(i);
            this.manager.getSAXFilter(((SAXFilterConfig)object).getFilterName()).setProperties((Map)object4.get(i));
        }
    }

    public SAXSerializer getSAXSerializer() {
        return this.serializer;
    }

    public void setSAXSerializer(SAXSerializer sAXSerializer) {
        this.serializer = sAXSerializer;
    }

    public ProcessingManager getProcessorManager() {
        return this.manager;
    }

    public void setProcessorManager(ProcessingManager processingManager) {
        this.manager = processingManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void prepare() {
    }

    public List getPostProcessorConfigs() {
        return this.postProcessorConfigs;
    }

    public void addSAXFilterConfig(SAXFilterConfig sAXFilterConfig) {
        this.saxFilterConfigs.add(sAXFilterConfig);
    }

    public void addPostProcessorConfig(PostProcessorConfig postProcessorConfig) {
        this.postProcessorConfigs.add(postProcessorConfig);
    }

    public Map getSerializerProperties() {
        return this.serializerProperties;
    }

    public void setSAXSerializerProperties(Map map) {
        this.serializerProperties = map;
    }

    public void setSAXGeneratorProperties(Map map) {
        this.generatorProperties = map;
    }

    public Map getSAXGeneratorProperties(Map map) {
        return this.generatorProperties;
    }

    public void setSAXGenerator(SAXGenerator sAXGenerator) {
        this.generator = sAXGenerator;
    }

    public SAXGenerator getSAXGenerator() {
        return this.generator;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

