/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.io;

import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.FileModelHandler;
import de.miethxml.toolkit.io.VFSFileModel;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VFS;

public class VFSFileModelHandler
implements FileModelHandler {
    private String[] protocols = new String[]{"sftp:", "ftp:", "smb", "zip:", "jar:", "gz:", "bz2:", "http:", "file:", "webdav:"};

    public FileModel createFileModel(String uri) throws FileModelException {
        try {
            FileObject f = VFS.getManager().resolveFile(uri);
            VFSFileModel model = new VFSFileModel(f, null);
            return model;
        }
        catch (FileSystemException e) {
            throw new FileModelException((Exception)((Object)e));
        }
    }

    public boolean isSupported(String uri) {
        int i = 0;
        while (i < this.protocols.length) {
            if (uri.startsWith(this.protocols[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean authenticationRequired(String uri) {
        try {
            FileModel model = this.createFileModel(uri);
            model.getChildren();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public FileModel createFileModel(String uri, String name, char[] password) throws FileModelException {
        StringBuffer buf = new StringBuffer();
        String[] part = uri.split("://");
        buf.append(part[0]);
        buf.append("://");
        buf.append(name);
        buf.append(":");
        buf.append(password);
        buf.append("@");
        buf.append(part[1]);
        try {
            return this.createFileModel(buf.toString());
        }
        catch (FileModelException e) {
            throw new FileModelException(e);
        }
    }
}

