/*
 * Decompiled with CFR 0.152.
 */
package de.miethxml.toolkit.repository.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.miethxml.hawron.gui.context.bookmark.BookmarkView;
import de.miethxml.hawron.gui.context.bookmark.BookmarkViewImpl;
import de.miethxml.hawron.gui.context.search.SearchPanel;
import de.miethxml.hawron.gui.context.search.SearchResultPanel;
import de.miethxml.hawron.search.SearchEngineImpl;
import de.miethxml.hawron.search.SearchResultListener;
import de.miethxml.toolkit.component.GuiConfigurable;
import de.miethxml.toolkit.conf.ConfigManager;
import de.miethxml.toolkit.conf.LocaleImpl;
import de.miethxml.toolkit.io.AuthenticationHandler;
import de.miethxml.toolkit.io.DefaultFileModelHandler;
import de.miethxml.toolkit.io.FileModel;
import de.miethxml.toolkit.io.FileModelException;
import de.miethxml.toolkit.io.FileModelHandler;
import de.miethxml.toolkit.io.FileModelManager;
import de.miethxml.toolkit.locale.impl.DummyLocaleService;
import de.miethxml.toolkit.plugins.PluginManager;
import de.miethxml.toolkit.repository.Reloadable;
import de.miethxml.toolkit.repository.RepositoryModel;
import de.miethxml.toolkit.repository.RepositoryModelImpl;
import de.miethxml.toolkit.repository.RepositorySelectionListener;
import de.miethxml.toolkit.repository.ui.RepositoryModelViewBuilder;
import de.miethxml.toolkit.repository.ui.action.ActionManager;
import de.miethxml.toolkit.repository.ui.editor.EditorManager;
import de.miethxml.toolkit.repository.ui.viewer.ViewerManager;
import de.miethxml.toolkit.setup.ApplicationSetup;
import de.miethxml.toolkit.ui.PanelFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class RepositoryWorkbenchBuilder
implements RepositorySelectionListener,
Serviceable,
Initializable,
Disposable,
GuiConfigurable,
Configurable,
LogEnabled {
    protected ServiceManager manager;
    private JButton edit;
    private JTable table;
    private JTextField currentPathField;
    private SearchResultPanel searchResult;
    private JSplitPane vsplit;
    private JPopupMenu popupmenu;
    private boolean resultView = false;
    private boolean taskView = false;
    private boolean projectView = true;
    private JPanel buttonpanel;
    private JPanel mainpanel;
    private String directoryCache = "";
    private JPanel dockComponent;
    protected String contextBase = "";
    protected Logger logger;
    protected JComboBox destinationList;
    protected JComboBox taskBuildDir;
    private JPanel view;
    protected boolean initialized = false;
    protected RepositoryModel fsModel;
    protected PluginManager pluginManager;
    protected SearchEngineImpl searchEngine;
    protected EditorManager editmanager;
    protected ViewerManager viewermanager;
    protected ActionManager actionmanager;
    protected BookmarkView bookmarkView;
    protected ApplicationSetup appSetup;
    protected FileModelManager fileModelManager = new FileModelManager();
    protected boolean showingTree = false;
    protected boolean showingTable = false;

    public RepositoryWorkbenchBuilder() {
        this("");
    }

    public RepositoryWorkbenchBuilder(String baseDir) {
        this.contextBase = baseDir;
    }

    public void initialize() {
        this.init();
    }

    public void setBaseLocation(String uri) {
        if (!this.directoryCache.equals(uri)) {
            this.currentPathField.setText(uri);
            try {
                this.fsModel.setBase(uri);
                this.directoryCache = uri;
            }
            catch (FileModelException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 2);
            }
        }
    }

    public void directorySelected(Reloadable model, FileModel fm) {
        this.currentPathField.setText(fm.getPath());
    }

    public void fileSelected(Reloadable model, FileModel fm) {
        this.currentPathField.setText(fm.getPath());
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        try {
            this.pluginManager = (PluginManager)manager.lookup(PluginManager.ROLE);
            this.appSetup = (ApplicationSetup)manager.lookup(ApplicationSetup.ROLE);
            this.fileModelManager.setPluginManager(this.pluginManager);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public void showButtonPanels(boolean state) {
        if (Boolean.valueOf(ConfigManager.getInstance().getProperty("view.context.showbuttonpanel")) != state) {
            ConfigManager.getInstance().setProperty("view.context.showbuttonpanel", Boolean.toString(state));
        }
        this.buttonpanel.setVisible(state);
    }

    public boolean isShowButtonPanels() {
        return this.buttonpanel.isVisible();
    }

    public String getLabel(String lang) {
        return LocaleImpl.getInstance().getString("view.project.tab.source");
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent getViewComponent() {
        return this.vsplit;
    }

    public void init() {
        this.fsModel = new RepositoryModelImpl(this.fileModelManager);
        this.fsModel.addRepositorySelectionListener(this);
        this.searchEngine = new SearchEngineImpl();
        this.bookmarkView = new BookmarkViewImpl();
        this.setBaseLocation(this.contextBase);
        this.popupmenu = new JPopupMenu();
        FormLayout panellayout = new FormLayout("3dlu,pref,3dlu,pref,3dlu,fill:10dlu:grow,3dlu,pref,3dlu", "3dlu,p,3dlu");
        PanelBuilder builder = new PanelBuilder(panellayout);
        CellConstraints ccp = new CellConstraints();
        JButton button = new JButton(new ImageIcon("icons/home.gif"));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setToolTipText("Context-Home");
        button.setFocusPainted(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RepositoryWorkbenchBuilder.access$0(1.access$0(this.this$1), "");
                        1.access$0(this.this$1).setBaseLocation(1.access$0(this.this$1).contextBase);
                    }
                });
            }

            static /* synthetic */ RepositoryWorkbenchBuilder access$0(1 var0) {
                return var0.RepositoryWorkbenchBuilder.this;
            }
        });
        builder.add((Component)button, ccp.xy(2, 2));
        builder.addLabel("Location:", ccp.xy(4, 2));
        ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3.access$0(this.this$1).setBaseLocation(RepositoryWorkbenchBuilder.access$1(3.access$0(this.this$1)).getText());
                    }
                });
            }

            static /* synthetic */ RepositoryWorkbenchBuilder access$0(3 var0) {
                return var0.RepositoryWorkbenchBuilder.this;
            }
        };
        this.currentPathField = new JTextField(40);
        this.currentPathField.addActionListener(action);
        builder.add((Component)this.currentPathField, ccp.xy(6, 2));
        JButton go = new JButton("Go");
        go.addActionListener(action);
        builder.add((Component)go, ccp.xy(8, 2));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)builder.getPanel(), "North");
        panellayout = new FormLayout("3dlu,80dlu:grow,6dlu,pref,3dlu", "3dlu,fill:60dlu:grow,3dlu");
        builder = new PanelBuilder(panellayout);
        ccp = new CellConstraints();
        FormLayout buttonlayout = new FormLayout("80dlu", "fill:12dlu:grow,3dlu,fill:12dlu:grow,3dlu,fill:20dlu:grow");
        PanelBuilder buttonbuilder = new PanelBuilder(buttonlayout);
        CellConstraints ccbutton = new CellConstraints();
        DummyLocaleService locale = new DummyLocaleService();
        this.editmanager = new EditorManager(locale);
        this.editmanager.initialize();
        this.pluginManager.addPluginReceiver(this.editmanager);
        this.searchEngine.addFileSystemSelectionListener((RepositorySelectionListener)this.editmanager);
        this.fsModel.addRepositorySelectionListener(this.editmanager);
        this.popupmenu.add(this.editmanager.getEditorMenu());
        JPanel editorpanel = this.editmanager.getButtonPanel();
        buttonbuilder.add((Component)editorpanel, ccbutton.xy(1, 1));
        this.viewermanager = new ViewerManager(locale);
        this.viewermanager.initialize();
        this.pluginManager.addPluginReceiver(this.viewermanager);
        this.searchEngine.addFileSystemSelectionListener((RepositorySelectionListener)this.viewermanager);
        this.fsModel.addRepositorySelectionListener(this.viewermanager);
        this.popupmenu.add(this.viewermanager.getViewerMenu());
        buttonbuilder.add((Component)this.viewermanager.getButtonPanel(), ccbutton.xy(1, 3));
        this.actionmanager = new ActionManager(locale);
        this.actionmanager.initialize();
        this.pluginManager.addPluginReceiver(this.actionmanager);
        this.searchEngine.addFileSystemSelectionListener((RepositorySelectionListener)this.actionmanager);
        this.fsModel.addRepositorySelectionListener(this.actionmanager);
        this.popupmenu.add(this.actionmanager.getActionMenu());
        JPanel actionpanel = this.actionmanager.getButtonPanel();
        buttonbuilder.add((Component)actionpanel, ccbutton.xy(1, 5));
        this.buttonpanel = buttonbuilder.getPanel();
        this.buttonpanel.setPreferredSize(this.buttonpanel.getPreferredSize());
        actionpanel.setPreferredSize(this.buttonpanel.getPreferredSize());
        editorpanel.setPreferredSize(this.buttonpanel.getPreferredSize());
        this.buttonpanel.setPreferredSize(this.buttonpanel.getPreferredSize());
        builder.add((Component)this.buttonpanel, ccp.xy(4, 2));
        RepositoryModelViewBuilder rview = new RepositoryModelViewBuilder((RepositoryModelImpl)this.fsModel, this.popupmenu, null);
        if (this.showingTable && this.showingTree) {
            builder.add((Component)rview.getTreeAndTableView(), ccp.xy(2, 2));
        } else if (this.showingTable) {
            JScrollPane scroll = new JScrollPane(rview.getRepositoryTable());
            scroll.getViewport().setBackground(Color.white);
            scroll.getViewport().setOpaque(true);
            builder.add((Component)scroll, ccp.xy(2, 2));
        } else if (this.showingTree) {
            builder.add((Component)new JScrollPane(rview.getRepositoryTree(true)), ccp.xy(2, 2));
        }
        this.vsplit = PanelFactory.createOneTouchSplitPane(0);
        this.vsplit.setDividerSize(10);
        this.mainpanel = builder.getPanel();
        this.mainpanel.setPreferredSize(this.mainpanel.getPreferredSize());
        panel.add((Component)this.mainpanel, "Center");
        JPopupMenu popupmenu = new JPopupMenu();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(LocaleImpl.getInstance().getString("view.context.setup.checkbox.showbuttonpanel"));
        popupmenu.add(item);
        item = new JCheckBoxMenuItem(LocaleImpl.getInstance().getString("view.context.setup.checkbox.checkextensions"));
        popupmenu.add(item);
        JPanel context = PanelFactory.createTitledPanel((JComponent)panel, "Context", "icons/text_edit.gif", popupmenu);
        context.setMinimumSize(new Dimension(0, 0));
        this.vsplit.setTopComponent(context);
        SearchPanel searchPanel = new SearchPanel(this.searchEngine);
        searchPanel.setPreferredSize(searchPanel.getPreferredSize());
        this.vsplit.setBottomComponent((Component)searchPanel);
        this.searchEngine.addSearchResultListener(new SearchResultListener(){

            public void startSearching() {
            }

            public void finishIndexing() {
            }

            public void finishSearching(int hits) {
                if (hits > 0) {
                    RepositoryWorkbenchBuilder.this.vsplit.setResizeWeight(0.5);
                    RepositoryWorkbenchBuilder.this.vsplit.setDividerLocation((int)RepositoryWorkbenchBuilder.this.vsplit.getTopComponent().getPreferredSize().getHeight());
                }
            }
        });
        Dimension dim = this.vsplit.getPreferredSize();
        this.vsplit.setPreferredSize(new Dimension((int)(dim.getWidth() * 1.1), (int)(dim.getHeight() * 1.3)));
        this.setCheckSupportedExtensions(Boolean.valueOf(ConfigManager.getInstance().getProperty("view.context.checkextensions", "true")));
        this.showButtonPanels(Boolean.valueOf(ConfigManager.getInstance().getProperty("view.context.showbuttonpanel", "true")));
        this.vsplit.setResizeWeight(1.0);
        this.initialized = true;
    }

    public void unselect() {
        this.currentPathField.setText("");
    }

    public void setEnabled(boolean state) {
    }

    public void dispose() {
        this.editmanager.dispose();
        this.viewermanager.dispose();
        this.actionmanager.dispose();
        this.bookmarkView.setConfigLocation("");
    }

    public String getLabel() {
        return "ContextView";
    }

    public JComponent getSetupComponent() {
        return null;
    }

    public boolean isSetup() {
        return false;
    }

    public void setup() {
    }

    public void setCheckSupportedExtensions(boolean b) {
        if (Boolean.valueOf(ConfigManager.getInstance().getProperty("view.context.checkextensions")) != b) {
            ConfigManager.getInstance().setProperty("view.context.checkextensions", Boolean.toString(b));
        }
        this.editmanager.setCheckSupportedExtensions(b);
        this.viewermanager.setCheckSupportedExtensions(b);
        this.actionmanager.setCheckSupportedExtensions(b);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        if ((conf = conf.getChild("repository")) != null) {
            Configuration config;
            Class<?> clazz;
            String classname;
            int i;
            Configuration[] handlers;
            if (conf.getChild("handlers") != null) {
                handlers = conf.getChild("handlers").getChildren("handler");
                if (handlers != null && handlers.length > 0) {
                    i = 0;
                    while (i < handlers.length) {
                        try {
                            classname = handlers[i].getAttribute("class");
                            clazz = this.getClass().getClassLoader().loadClass(classname);
                            FileModelHandler handler = (FileModelHandler)clazz.newInstance();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("adding FileModelHandler:" + classname);
                            }
                            this.fileModelManager.addFileModelHandler(handler);
                        }
                        catch (Exception e) {
                            this.logger.error("configure: adding FileModelHandler", (Throwable)e);
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
            } else {
                this.fileModelManager.addFileModelHandler(new DefaultFileModelHandler());
            }
            if (conf.getChild("authentication-handlers") != null && (handlers = conf.getChild("authentication-handlers").getChildren("authentication-handler")) != null && handlers.length > 0) {
                i = 0;
                while (i < handlers.length) {
                    try {
                        classname = handlers[i].getAttribute("class");
                        clazz = this.getClass().getClassLoader().loadClass(classname);
                        AuthenticationHandler authenticator = (AuthenticationHandler)clazz.newInstance();
                        this.fileModelManager.addAuthenticationHandler(authenticator);
                    }
                    catch (Exception e) {
                        this.logger.error("configure: adding FileModelHandler", (Throwable)e);
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            if ((config = conf.getChild("repository-tree")) != null) {
                try {
                    this.setShowingTree(config.getAttributeAsBoolean("enabled"));
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
            }
            if ((config = conf.getChild("repository-table")) != null) {
                try {
                    this.setShowingTable(config.getAttributeAsBoolean("enabled"));
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    public boolean isShowingTable() {
        return this.showingTable;
    }

    public void setShowingTable(boolean showingTable) {
        this.showingTable = showingTable;
    }

    public boolean isShowingTree() {
        return this.showingTree;
    }

    public void setShowingTree(boolean showingTree) {
        this.showingTree = showingTree;
    }

    static /* synthetic */ void access$0(RepositoryWorkbenchBuilder repositoryWorkbenchBuilder, String string) {
        repositoryWorkbenchBuilder.directoryCache = string;
    }

    static /* synthetic */ JTextField access$1(RepositoryWorkbenchBuilder repositoryWorkbenchBuilder) {
        return repositoryWorkbenchBuilder.currentPathField;
    }
}

