/*
 * Decompiled with CFR 0.152.
 */
package dk.abj.svg.action;

import de.miethxml.toolkit.ui.UIUtils;
import dk.abj.svg.action.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.action.CanvasUpdateManager;
import org.kabeja.svg.action.CanvasUpdateRunnable;
import org.kabeja.svg.action.SVGDocumentAction;
import org.kabeja.ui.PropertiesEditor;
import org.kabeja.ui.PropertiesListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public class LayerSelectionAction
extends AbstractAction
implements SVGDocumentAction,
PropertiesEditor,
CanvasUpdateRunnable {
    protected SVGDocument doc;
    protected Map properties = new HashMap();
    protected List listeners = new ArrayList();
    protected List layers = new ArrayList();
    protected Set disabledLayers = new HashSet();
    protected JCheckBox box;
    protected JDialog dialog;
    protected CanvasUpdateManager updateManager;
    static /* synthetic */ Class class$dk$abj$svg$action$LayerSelectionAction;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public LayerSelectionAction() {
        super("Layers", new ImageIcon(UIUtils.resourceToBytes(class$dk$abj$svg$action$LayerSelectionAction == null ? (class$dk$abj$svg$action$LayerSelectionAction = LayerSelectionAction.class$("dk.abj.svg.action.LayerSelectionAction")) : class$dk$abj$svg$action$LayerSelectionAction, "/icons/layer_select.gif")));
        this.putValue("ShortDescription", Messages.getString("editor.action.layer.selection"));
    }

    public void setDocument(SVGDocument doc) {
        Element el = doc.getElementById("draft");
        NodeList list = el.getElementsByTagName("g");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.hasAttributes() || node.getAttributes().getNamedItem("id") == null) continue;
            this.layers.add(node);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                Frame[] frames = Frame.getFrames();
                if (frames.length > 0) {
                    int i = 0;
                    while (!frames[i].isActive()) {
                        ++i;
                    }
                    LayerSelectionAction.this.dialog = new JDialog(frames[i], true);
                } else {
                    LayerSelectionAction.this.dialog = new JDialog();
                    LayerSelectionAction.this.dialog.setModal(true);
                }
                LayerSelectionAction.this.dialog.setTitle("Layer Tool");
                JTable table = new JTable(new LayerTableModel());
                JScrollPane sp = new JScrollPane(table);
                LayerSelectionAction.this.dialog.getContentPane().add((Component)sp, "Center");
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 2));
                panel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 5));
                LayerSelectionAction.this.box = new JCheckBox();
                LayerSelectionAction.this.box.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).LayerSelectionAction.this.properties.put("layers.merge", Boolean.toString((this).LayerSelectionAction.this.box.isSelected()));
                        LayerSelectionAction.this.firePropertiesUpdated();
                    }
                });
                if (LayerSelectionAction.this.properties.containsKey("layers.merge")) {
                    LayerSelectionAction.this.box.setSelected(Boolean.valueOf((String)LayerSelectionAction.this.properties.get("layers.merge")));
                }
                panel.add(LayerSelectionAction.this.box);
                panel.add(new JLabel(Messages.getString("editor.action.layer.merge")));
                panel.add(Box.createHorizontalGlue());
                JButton button = new JButton(Messages.getString("button.close"));
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        (this).LayerSelectionAction.this.dialog.setVisible(false);
                        (this).LayerSelectionAction.this.dialog.dispose();
                    }
                });
                panel.add(button);
                LayerSelectionAction.this.dialog.getContentPane().add((Component)panel, "South");
                LayerSelectionAction.this.dialog.pack();
                LayerSelectionAction.this.dialog.setVisible(true);
            }
        });
        t.start();
    }

    public void addPropertiesListener(PropertiesListener listener) {
        this.listeners.add(listener);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void removePropertiesListener(PropertiesListener listener) {
        this.listeners.remove(listener);
    }

    public void setProperties(Map props) {
        Iterator i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.properties.put(key, props.get(key));
        }
    }

    protected void firePropertiesUpdated() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            PropertiesListener listener = (PropertiesListener)i.next();
            listener.propertiesChanged(this.properties);
        }
    }

    public void setCanvasUpdateManager(CanvasUpdateManager manager) {
        this.updateManager = manager;
    }

    protected String getDisabledLayersStringList() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.disabledLayers.iterator();
        while (i.hasNext()) {
            String layerName = SVGUtils.reverseID(((Node)i.next()).getAttributes().getNamedItem("id").getNodeValue());
            buf.append(layerName);
            if (!i.hasNext()) continue;
            buf.append("|");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NodeUpdateRunnable
    implements Runnable {
        private boolean visible = false;
        private int nodeIndex;
        private LayerTableModel model;

        public NodeUpdateRunnable(int nodeIndex, boolean visible, LayerTableModel model) {
            this.nodeIndex = nodeIndex;
            this.visible = visible;
            this.model = model;
        }

        public void run() {
            Node node = (Node)LayerSelectionAction.this.layers.get(this.nodeIndex);
            if (this.visible) {
                ((Element)node).setAttributeNS(null, "visibility", "visible");
            } else {
                ((Element)node).setAttributeNS(null, "visibility", "hidden");
            }
            this.model.fireTableCellUpdated(this.nodeIndex, 0);
        }
    }

    private class LayerTableModel
    extends AbstractTableModel {
        private LayerTableModel() {
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("label.enabled");
                }
                case 1: {
                    return "Layer";
                }
            }
            return "" + column;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return LayerSelectionAction.this.layers.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Node node = (Node)LayerSelectionAction.this.layers.get(rowIndex);
            Element el = (Element)node;
            switch (columnIndex) {
                case 0: {
                    if (el.hasAttributeNS(null, "visibility") && el.getAttributeNS(null, "visibility") != null) {
                        boolean b = el.getAttributeNS(null, "visibility").equals("visible");
                        return b;
                    }
                    return Boolean.TRUE;
                }
                case 1: {
                    return SVGUtils.reverseID(node.getAttributes().getNamedItem("id").getNodeValue());
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = LayerSelectionAction.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = LayerSelectionAction.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex < 2;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Boolean b = (Boolean)aValue;
                    try {
                        LayerSelectionAction.this.updateManager.invokeLater(new NodeUpdateRunnable(rowIndex, b, this));
                        if (b.booleanValue()) {
                            LayerSelectionAction.this.disabledLayers.remove(LayerSelectionAction.this.layers.get(rowIndex));
                        } else {
                            LayerSelectionAction.this.disabledLayers.add(LayerSelectionAction.this.layers.get(rowIndex));
                        }
                        LayerSelectionAction.this.properties.put("layers.remove", LayerSelectionAction.this.getDisabledLayersStringList());
                        LayerSelectionAction.this.firePropertiesUpdated();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }
    }
}

