/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Cylinder
extends Primitive {
    private static final double MINIMUM_RADIUS = 0.001;
    private Vector3d start;
    private Vector3d end;
    private double startRadius;
    private double endRadius;
    private int numSlices;
    private final PropertyStorage properties = new PropertyStorage();

    public Cylinder() {
        this.start = new Vector3d(0.0, -0.5, 0.0);
        this.end = new Vector3d(0.0, 0.5, 0.0);
        this.startRadius = 1.0;
        this.endRadius = 1.0;
        this.numSlices = 16;
    }

    public Cylinder(Vector3d start, Vector3d end, double radius, int numSlices) {
        this.start = start;
        this.end = end;
        this.startRadius = radius < 0.001 ? 0.001 : radius;
        this.endRadius = radius < 0.001 ? 0.001 : radius;
        this.numSlices = numSlices;
    }

    public Cylinder(Vector3d start, Vector3d end, double startRadius, double endRadius, int numSlices) {
        this.start = start;
        this.end = end;
        this.startRadius = startRadius < 0.001 ? 0.001 : startRadius;
        this.endRadius = endRadius < 0.001 ? 0.001 : endRadius;
        this.numSlices = numSlices;
    }

    public Cylinder(double radius, double height, int numSlices) {
        this.start = Vector3d.ZERO;
        this.end = Vector3d.Z_ONE.times(height);
        this.startRadius = radius < 0.001 ? 0.001 : radius;
        this.endRadius = radius < 0.001 ? 0.001 : radius;
        this.numSlices = numSlices;
    }

    public Cylinder(double startRadius, double endRadius, double height, int numSlices) {
        this.start = Vector3d.ZERO;
        this.end = Vector3d.Z_ONE.times(height);
        this.startRadius = startRadius < 0.001 ? 0.001 : startRadius;
        this.endRadius = endRadius < 0.001 ? 0.001 : endRadius;
        this.numSlices = numSlices;
    }

    public Cylinder(LengthParameter startRadius, LengthParameter endRadius, LengthParameter height, int numSlices) {
        this(startRadius.getMM(), endRadius.getMM(), height.getMM(), numSlices);
        this.parametrics.add(startRadius);
        this.parametrics.add(endRadius);
        this.parametrics.add(height);
    }

    public Cylinder(LengthParameter startRadius, LengthParameter height, int numSlices) {
        this(startRadius, startRadius, height, numSlices);
    }

    @Override
    public List<Polygon> toPolygons() {
        Vector3d s = this.getStart();
        Vector3d e = this.getEnd();
        Vector3d ray = e.minus(s);
        Vector3d axisZ = ray.normalized();
        boolean isY = Math.abs(axisZ.y) > 0.5;
        Vector3d axisX = new Vector3d(isY ? 1.0 : 0.0, !isY ? 1.0 : 0.0, 0.0).cross(axisZ).normalized();
        Vector3d axisY = axisX.cross(axisZ).normalized();
        Vertex startV = new Vertex(s, axisZ.negated());
        Vertex endV = new Vertex(e, axisZ.normalized());
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.numSlices; ++i) {
            double t0 = (double)i / (double)this.numSlices;
            double t1 = (double)(i + 1) / (double)this.numSlices;
            polygons.add(new Polygon(Arrays.asList(startV, this.cylPoint(axisX, axisY, axisZ, ray, s, this.startRadius, 0.0, t0, -1.0), this.cylPoint(axisX, axisY, axisZ, ray, s, this.startRadius, 0.0, t1, -1.0)), this.properties));
            polygons.add(new Polygon(Arrays.asList(this.cylPoint(axisX, axisY, axisZ, ray, s, this.startRadius, 0.0, t1, 0.0), this.cylPoint(axisX, axisY, axisZ, ray, s, this.startRadius, 0.0, t0, 0.0), this.cylPoint(axisX, axisY, axisZ, ray, s, this.endRadius, 1.0, t0, 0.0), this.cylPoint(axisX, axisY, axisZ, ray, s, this.endRadius, 1.0, t1, 0.0)), this.properties));
            polygons.add(new Polygon(Arrays.asList(endV, this.cylPoint(axisX, axisY, axisZ, ray, s, this.endRadius, 1.0, t1, 1.0), this.cylPoint(axisX, axisY, axisZ, ray, s, this.endRadius, 1.0, t0, 1.0)), this.properties));
        }
        return polygons;
    }

    private Vertex cylPoint(Vector3d axisX, Vector3d axisY, Vector3d axisZ, Vector3d ray, Vector3d s, double r, double stack, double slice, double normalBlend) {
        double angle = slice * Math.PI * 2.0;
        Vector3d out = axisX.times(Math.cos(angle)).plus(axisY.times(Math.sin(angle)));
        Vector3d pos = s.plus(ray.times(stack)).plus(out.times(r));
        Vector3d normal = out.times(1.0 - Math.abs(normalBlend)).plus(axisZ.times(normalBlend));
        return new Vertex(pos, normal);
    }

    public Vector3d getStart() {
        return this.start;
    }

    public void setStart(Vector3d start) {
        this.start = start;
    }

    public Vector3d getEnd() {
        return this.end;
    }

    public void setEnd(Vector3d end) {
        this.end = end;
    }

    public double getStartRadius() {
        return this.startRadius;
    }

    public void setStartRadius(double radius) {
        this.startRadius = radius;
    }

    public double getEndRadius() {
        return this.endRadius;
    }

    public void setEndRadius(double radius) {
        this.endRadius = radius;
    }

    public int getNumSlices() {
        return this.numSlices;
    }

    public void setNumSlices(int numSlices) {
        this.numSlices = numSlices;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }
}

