/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.ISlice;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vertex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.vecmath.Matrix4d;

public class Slice {
    private static ISlice sliceEngine = (incoming, slicePlane, normalInsetDistance) -> {
        ArrayList finalSlice = new ArrayList();
        Matrix4d inverse = slicePlane.scale(1.0 / slicePlane.getScale()).getInternalMatrix();
        inverse.invert();
        CSG planeCSG = new Cube(incoming.getMaxX() - incoming.getMinX(), incoming.getMaxY() - incoming.getMinY(), 1.0).noCenter().toCSG();
        planeCSG = planeCSG.movex((planeCSG.getMaxX() - planeCSG.getMinX()) / -2.0).movey((planeCSG.getMaxY() - planeCSG.getMinY()) / -2.0);
        incoming.getPolygons();
        finalSlice.addAll(incoming.intersect(planeCSG).getPolygons().stream().filter(Slice::isPolygonAtZero).collect(Collectors.toList()));
        int edgeCount = 0;
        TreeSet<Vertex> vertexSet = new TreeSet<Vertex>(new VertexComparator());
        for (Polygon p : finalSlice) {
            for (int i = 0; i < p.vertices.size() - 1; ++i) {
                ++edgeCount;
            }
            ++edgeCount;
            vertexSet.addAll(p.vertices);
        }
        System.out.println(vertexSet.size());
        System.out.println(edgeCount);
        System.out.println(vertexSet.size() - edgeCount + 2 == 2);
        return finalSlice;
    };

    private static boolean isPolygonAtZero(Polygon polygon) {
        for (Vertex v : polygon.vertices) {
            if (Slice.isVertexAtZero(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVertexAtZero(Vertex vertex) {
        double SLICE_UPPER_BOUND = 0.001;
        double SLICE_LOWER_BOUND = -0.001;
        return vertex.getZ() < 0.001 && vertex.getZ() > -0.001;
    }

    public static List<Polygon> slice(CSG incoming, Transform slicePlane, double normalInsetDistance) {
        return Slice.getSliceEngine().slice(incoming, slicePlane, normalInsetDistance);
    }

    public static ISlice getSliceEngine() {
        return sliceEngine;
    }

    public static void setSliceEngine(ISlice sliceEngine) {
        Slice.sliceEngine = sliceEngine;
    }

    private static class VertexComparator
    implements Comparator<Vertex> {
        private VertexComparator() {
        }

        @Override
        public int compare(Vertex o1, Vertex o2) {
            return o1.getX() == o2.getX() && o1.getY() == o2.getY() && o1.getZ() == o2.getZ() ? 0 : 1;
        }
    }
}

