/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.org.poly2tri;

import eu.mihosoft.vrl.v3d.ext.org.poly2tri.ConstrainedPointSet;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.DTSweep;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.DTSweepContext;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PointSet;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Polygon;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonGenerator;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonSet;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.Triangulatable;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationAlgorithm;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationContext;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.TriangulationProcess;

class Poly2Tri {
    private static final TriangulationAlgorithm _defaultAlgorithm = TriangulationAlgorithm.DTSweep;

    Poly2Tri() {
    }

    public static void triangulate(PolygonSet ps) {
        TriangulationContext<?> tcx = Poly2Tri.createContext(_defaultAlgorithm);
        for (Polygon p : ps.getPolygons()) {
            tcx.prepareTriangulation(p);
            Poly2Tri.triangulate(tcx);
            tcx.clear();
        }
    }

    public static void triangulate(Polygon p) {
        Poly2Tri.triangulate(_defaultAlgorithm, p);
    }

    public static void triangulate(ConstrainedPointSet cps) {
        Poly2Tri.triangulate(_defaultAlgorithm, cps);
    }

    public static void triangulate(PointSet ps) {
        Poly2Tri.triangulate(_defaultAlgorithm, ps);
    }

    public static TriangulationContext<?> createContext(TriangulationAlgorithm algorithm) {
        switch (algorithm) {
            default: 
        }
        return new DTSweepContext();
    }

    public static void triangulate(TriangulationAlgorithm algorithm, Triangulatable t) {
        TriangulationContext<?> tcx = Poly2Tri.createContext(algorithm);
        tcx.prepareTriangulation(t);
        Poly2Tri.triangulate(tcx);
    }

    public static void triangulate(TriangulationContext<?> tcx) {
        switch (tcx.algorithm()) {
            default: 
        }
        DTSweep.triangulate((DTSweepContext)tcx);
    }

    public static void warmup() {
        Polygon poly = PolygonGenerator.RandomCircleSweep2(50.0, 50000);
        TriangulationProcess process = new TriangulationProcess();
        process.triangulate(poly);
    }
}

