/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cylinder;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Sphere;
import eu.mihosoft.vrl.v3d.Transform;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;

public class EdgeTest {
    public CSG toCSG(boolean optimized) {
        double radius = 22.0;
        double stretch = 1.5;
        int resolution = 64;
        CSG cylinder = new Cylinder(1.0, 0.3, 8).toCSG();
        CSG sphere = new Sphere(0.1, 8, 4).toCSG().transformed(Transform.unity().translateZ(0.15));
        CSG cyl = new Cylinder(0.08, 0.3, 8).toCSG();
        CSG csg = cylinder.difference(cyl);
        if (!optimized) {
            return csg;
        }
        List<Polygon> boundaryPolygons = Edge.boundaryPolygons(csg);
        System.out.println("#groups: " + boundaryPolygons.size());
        return CSG.fromPolygons(boundaryPolygons);
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("edge-test.stl", new String[0]), new EdgeTest().toCSG(true).toStlString());
        FileUtil.write(Paths.get("edge-test-orig.stl", new String[0]), new EdgeTest().toCSG(false).toStlString());
    }
}

