/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.samples;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.FileUtil;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.samples.PolyMailTile;
import java.io.IOException;
import java.nio.file.Paths;

public class TriMail {
    public CSG toCSG(int numEdges, int numX, int numY) {
        PolyMailTile tile = new PolyMailTile().setNumEdges(numEdges).setPinThickness(2.1).setHingeHoleScale(1.2).setConeLength(1.8);
        double hingeHoleScale = tile.getHingeHoleScale();
        CSG malePart = tile.setMale().toCSG().transformed(Transform.unity().rotZ(360.0 / (double)numEdges * 0.75));
        CSG femalePart = tile.setFemale().toCSG().transformed(Transform.unity().rotZ(360.0 / (double)numEdges * 0.25));
        CSG result = null;
        for (int y = 0; y < numY; ++y) {
            for (int x = 0; x < numX; ++x) {
                double pinOffset = tile.getPinLength() - (tile.getJointRadius() * hingeHoleScale - tile.getJointRadius());
                double xOffset = 0.0;
                double yOffset = 0.0;
                if (y % 2 == 0) {
                    xOffset = tile.getSideLength() * 0.5 + pinOffset * 0.5;
                    if (y / 2 % 2 == 0) {
                        xOffset -= tile.getSideLength() * 0.5 + pinOffset * 0.5;
                    }
                    yOffset = tile.getPinLength() * 3.0;
                }
                double translateX = (-tile.getSideLength() - pinOffset) * (double)x + xOffset;
                double translateY = tile.getRadius() * (double)y - yOffset;
                CSG part2 = y % 2 == 0 ? femalePart.clone() : malePart.clone();
                part2 = part2.transformed(Transform.unity().translate(translateX, translateY, 0.0));
                if (result == null) {
                    result = part2.clone();
                }
                result = result.dumbUnion(part2);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        FileUtil.write(Paths.get("trimail-test.stl", new String[0]), new TriMail().toCSG(3, 3, 3).toStlString());
    }
}

