/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.svg;

import com.piro.bezier.BezierPath;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMSVGElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGLoad {
    private static final String PATH_ELEMENT_NAME = "path";
    private static final String GROUP_ELEMENT_NAME = "g";
    private Document svgDocument;
    boolean holePolarity = true;

    public void setHolePolarity(boolean p) {
        this.holePolarity = p;
    }

    public SVGLoad(URI uri) throws IOException {
        this.setSVGDocument(this.createSVGDocument(uri));
    }

    public ArrayList<CSG> extrude(double thickness) throws IOException {
        return this.extrude(thickness, 0.005);
    }

    public static ArrayList<CSG> extrude(File f, double thickness) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness);
    }

    public static ArrayList<CSG> extrude(File f, double thickness, double resolution) throws IOException {
        return new SVGLoad(f.toURI()).extrude(thickness, resolution);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness) throws IOException {
        return new SVGLoad(uri).extrude(thickness);
    }

    public static ArrayList<CSG> extrude(URI uri, double thickness, double resolution) throws IOException {
        return new SVGLoad(uri).extrude(thickness, resolution);
    }

    private void loadAllGroups(NodeList pn, ArrayList<CSG> sections, double thickness, double resolution, double mvx, double mvy) {
        int pnCount = pn.getLength();
        for (int j = 0; j < pnCount; ++j) {
            if (!SVGOMGElement.class.isInstance(pn.item(j))) continue;
            SVGOMGElement element = (SVGOMGElement)pn.item(j);
            NodeList pathNodes = element.getElementsByTagName(PATH_ELEMENT_NAME);
            Node transforms = element.getAttributes().getNamedItem("transform");
            Node id = element.getAttributes().getNamedItem("id");
            NodeList subgroups = element.getElementsByTagName(GROUP_ELEMENT_NAME);
            String transformValue = "translate(0,0)";
            if (transforms != null) {
                transformValue = transforms.getNodeValue();
            }
            if (transformValue.contains("matrix")) {
                transformValue = "translate(0,0)";
            }
            String[] transformValues = transformValue.replaceAll("translate", "").replaceAll("\\(", "").replaceAll("\\)", "").split("\\,");
            System.out.println(id.getNodeValue() + " " + transformValues);
            mvx = Double.parseDouble(transformValues[0]);
            mvy = Double.parseDouble(transformValues[1]);
            if (subgroups == null || subgroups.getLength() >= 1) continue;
            this.loadAllPaths((SVGOMGElement)pn.item(j), sections, thickness, resolution, mvx, mvy);
        }
    }

    private void loadAllPaths(SVGOMGElement element, ArrayList<CSG> sections, double thickness, double resolution, double mvx, double mvy) {
        ArrayList holes = new ArrayList();
        NodeList pathNodes = element.getElementsByTagName(PATH_ELEMENT_NAME);
        if (pathNodes != null) {
            ArrayList p = new ArrayList();
            double connectorDepth = thickness;
            int pathNodeCount = pathNodes.getLength();
            for (int iPathNode = 0; iPathNode < pathNodeCount; ++iPathNode) {
                Node pathNode = pathNodes.item(iPathNode);
                MetaPostPath2 mpp = new MetaPostPath2(pathNode);
                String code = mpp.toCode();
                this.loadComposite(code, sections, thickness, resolution, mvx, mvy);
            }
        }
    }

    private void loadComposite(String code, ArrayList<CSG> sections, double thickness, double resolution, double mvx, double mvy) {
        ArrayList<CSG> holes = new ArrayList<CSG>();
        int count = code.length() - code.replace("M", "").length();
        if (count < 2) {
            this.setHolePolarity(true);
            try {
                this.loadSingle(code, sections, holes, thickness, resolution, mvx, mvy);
            }
            catch (Exception exception) {}
        } else {
            int i;
            this.setHolePolarity(false);
            String[] pathParts = code.split("M");
            ArrayList<CSG> tmp = new ArrayList<CSG>();
            for (i = 0; i < pathParts.length; ++i) {
                String sectionedPart = "M" + pathParts[i];
                if (sectionedPart.length() <= 1) continue;
                this.loadSingle(sectionedPart, holes, tmp, thickness, resolution, mvx, mvy);
            }
            for (i = 0; i < tmp.size(); ++i) {
                for (CSG h : holes) {
                    CSG cut = ((CSG)tmp.get(i)).difference(h);
                    if (cut.getPolygons().size() <= 0) continue;
                    tmp.set(i, cut);
                }
            }
            sections.addAll(tmp);
        }
        System.out.println("SVG has this many elements loaded: " + sections.size());
    }

    private void loadSingle(String code, ArrayList<CSG> sections, ArrayList<CSG> holes, double thickness, double resolution, double mvx, double mvy) {
        BezierPath path = new BezierPath();
        path.parsePathString(code);
        ArrayList<Vector3d> p = new ArrayList<Vector3d>();
        for (double i = 0.0; i < 1.0; i += resolution) {
            Vector3d point = path.eval((float)i);
            p.add(point);
        }
        p.add(path.eval((float)(1.0 - resolution / 2.0)));
        boolean hole = Extrude.isCCW(Polygon.fromPoints(p));
        if (!this.holePolarity) {
            hole = !hole;
        }
        try {
            CSG newbit = Extrude.points(new Vector3d(0.0, 0.0, thickness), p).movex(mvx).movey(mvy).scale(0.376975);
            if (!hole) {
                sections.add(newbit);
            } else {
                holes.add(newbit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList<CSG> extrude(double thickness, double resolution) throws IOException {
        NodeList pn = this.getSVGDocument().getDocumentElement().getElementsByTagName(GROUP_ELEMENT_NAME);
        ArrayList<CSG> sections = new ArrayList<CSG>();
        this.loadAllGroups(pn, sections, thickness, resolution, 0.0, 0.0);
        return sections;
    }

    private NodeList getPathElements(NodeList group) {
        return this.getSVGDocumentRoot().getElementsByTagName(PATH_ELEMENT_NAME);
    }

    private NodeList getGroupElements() {
        return this.getSVGDocumentRoot().getElementsByTagName(GROUP_ELEMENT_NAME);
    }

    private SVGOMSVGElement getSVGDocumentRoot() {
        return (SVGOMSVGElement)this.getSVGDocument().getDocumentElement();
    }

    public void setSVGDocument(Document document) {
        this.initSVGDOM(document);
        this.svgDocument = document;
    }

    public Document getSVGDocument() {
        return this.svgDocument;
    }

    private void initSVGDOM(Document document) {
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader(userAgent);
        BridgeContext bridgeContext = new BridgeContext(userAgent, loader);
        bridgeContext.setDynamicState(2);
        new GVTBuilder().build(bridgeContext, document);
    }

    private Document createSVGDocument(URI uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        return factory.createDocument(uri.toString());
    }

    class MetaPostPath2 {
        private SVGOMPathElement pathElement;
        private String transform;

        public MetaPostPath2(Node pathNode) {
            this.setPathNode(pathNode);
        }

        public String toCode() {
            StringBuilder sb = new StringBuilder(16384);
            SVGOMPathElement pathElement = this.getPathElement();
            SVGPathSegList pathList = pathElement.getNormalizedPathSegList();
            int pathObjects = pathList.getNumberOfItems();
            for (int i = 0; i < pathObjects; ++i) {
                SVGItem item = (SVGItem)((Object)pathList.getItem(i));
                String itemLine = String.format("%s%n", item.getValueAsString());
                sb.append(itemLine);
            }
            return sb.toString();
        }

        private String getId() {
            return this.getPathElement().getAttributes().getNamedItem("id").getNodeValue();
        }

        private void setPathNode(Node pathNode) {
            this.pathElement = (SVGOMPathElement)pathNode;
        }

        private SVGOMPathElement getPathElement() {
            return this.pathElement;
        }
    }
}

