/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vvecmath;

import eu.mihosoft.vvecmath.Vector3d;

public class Plane {
    public static final double EPS = 1.0E-12;
    public static final Plane XY_PLANE = new Plane(Vector3d.Z_ONE, 1.0);
    public static final Plane XZ_PLANE = new Plane(Vector3d.Y_ONE, 1.0);
    public static final Plane YZ_PLANE = new Plane(Vector3d.X_ONE, 1.0);
    public Vector3d normal;
    private double dist;

    public Plane(Vector3d normal, double dist) {
        this.normal = normal.normalized();
        this.dist = dist;
    }

    public static Plane createFromPoints(Vector3d a, Vector3d b, Vector3d c) {
        Vector3d n = b.minus(a).cross(c.minus(a)).normalized();
        return new Plane(n, n.dot(a));
    }

    public Plane clone() {
        return new Plane(this.normal.clone(), this.dist);
    }

    public void flip() {
        this.normal = this.normal.negated();
        this.dist = -this.dist;
    }

    public double getDist() {
        return this.dist;
    }
}

