/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.AnimatedLiveAttributeValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGOMPolygonElement;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolygonProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPolygonElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    public String getLocalName() {
        return "polygon";
    }

    public Bridge getInstance() {
        return new SVGPolygonElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        try {
            SVGOMPolygonElement sVGOMPolygonElement = (SVGOMPolygonElement)element;
            SVGPointList sVGPointList = sVGOMPolygonElement.getAnimatedPoints();
            int n = sVGPointList.getNumberOfItems();
            if (n == 0) {
                shapeNode.setShape(DEFAULT_SHAPE);
            } else {
                AWTPolygonProducer aWTPolygonProducer = new AWTPolygonProducer();
                aWTPolygonProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolygonProducer.startPoints();
                for (int i = 0; i < n; ++i) {
                    SVGPoint sVGPoint = sVGPointList.getItem(i);
                    aWTPolygonProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolygonProducer.endPoints();
                shapeNode.setShape(aWTPolygonProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

