/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import java.util.List;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.AttributeInitializer;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGExternalResourcesRequiredSupport;
import org.apache.batik.dom.svg.SVGLocatableSupport;
import org.apache.batik.dom.svg.SVGOMAngle;
import org.apache.batik.dom.svg.SVGOMLength;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.dom.svg.SVGPreserveAspectRatioSupport;
import org.apache.batik.dom.svg.SVGSVGContext;
import org.apache.batik.dom.svg.SVGStylableElement;
import org.apache.batik.dom.svg.SVGTestsSupport;
import org.apache.batik.dom.svg.SVGZoomAndPanSupport;
import org.apache.batik.dom.util.ListNodeList;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMSVGElement
extends SVGStylableElement
implements SVGSVGElement {
    protected static final AttributeInitializer attributeInitializer = new AttributeInitializer(7);

    protected SVGOMSVGElement() {
    }

    public SVGOMSVGElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public String getLocalName() {
        return "svg";
    }

    public SVGAnimatedLength getX() {
        return this.getAnimatedLengthAttribute(null, "x", "0", (short)2, false);
    }

    public SVGAnimatedLength getY() {
        return this.getAnimatedLengthAttribute(null, "y", "0", (short)1, false);
    }

    public SVGAnimatedLength getWidth() {
        return this.getAnimatedLengthAttribute(null, "width", "100%", (short)2, true);
    }

    public SVGAnimatedLength getHeight() {
        return this.getAnimatedLengthAttribute(null, "height", "100%", (short)1, true);
    }

    public String getContentScriptType() {
        return this.getAttributeNS(null, "contentScriptType");
    }

    public void setContentScriptType(String string) {
        this.setAttributeNS(null, "contentScriptType", string);
    }

    public String getContentStyleType() {
        return this.getAttributeNS(null, "contentStyleType");
    }

    public void setContentStyleType(String string) {
        this.setAttributeNS(null, "contentStyleType", string);
    }

    public SVGRect getViewport() {
        SVGContext sVGContext = this.getSVGContext();
        return new SVGOMRect(0.0f, 0.0f, sVGContext.getViewportWidth(), sVGContext.getViewportHeight());
    }

    public float getPixelUnitToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getPixelUnitToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public boolean getUseCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getUseCurrentView is not implemented");
    }

    public void setUseCurrentView(boolean bl) throws DOMException {
        throw new UnsupportedOperationException("SVGSVGElement.setUseCurrentView is not implemented");
    }

    public SVGViewSpec getCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getCurrentView is not implemented");
    }

    public float getCurrentScale() {
        AffineTransform affineTransform = this.getSVGContext().getScreenTransform();
        if (affineTransform != null) {
            return (float)Math.sqrt(affineTransform.getDeterminant());
        }
        return 1.0f;
    }

    public void setCurrentScale(float f) throws DOMException {
        SVGContext sVGContext = this.getSVGContext();
        AffineTransform affineTransform = sVGContext.getScreenTransform();
        float f2 = 1.0f;
        if (affineTransform != null) {
            f2 = (float)Math.sqrt(affineTransform.getDeterminant());
        }
        float f3 = f / f2;
        affineTransform = new AffineTransform(affineTransform.getScaleX() * (double)f3, affineTransform.getShearY() * (double)f3, affineTransform.getShearX() * (double)f3, affineTransform.getScaleY() * (double)f3, affineTransform.getTranslateX(), affineTransform.getTranslateY());
        sVGContext.setScreenTransform(affineTransform);
    }

    public SVGPoint getCurrentTranslate() {
        return new SVGPoint(){

            protected AffineTransform getScreenTransform() {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                return sVGContext.getScreenTransform();
            }

            public float getX() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateX();
            }

            public float getY() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateY();
            }

            public void setX(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), (double)f, affineTransform.getTranslateY());
                sVGContext.setScreenTransform(affineTransform);
            }

            public void setY(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), (double)f);
                sVGContext.setScreenTransform(affineTransform);
            }

            public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
                AffineTransform affineTransform = this.getScreenTransform();
                float f = (float)affineTransform.getTranslateX();
                float f2 = (float)affineTransform.getTranslateY();
                float f3 = sVGMatrix.getA() * f + sVGMatrix.getC() * f2 + sVGMatrix.getE();
                float f4 = sVGMatrix.getB() * f + sVGMatrix.getD() * f2 + sVGMatrix.getF();
                return new SVGOMPoint(f3, f4);
            }
        };
    }

    public int suspendRedraw(int n) {
        if (n > 60000) {
            n = 60000;
        } else if (n < 0) {
            n = 0;
        }
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.suspendRedraw(n);
    }

    public void unsuspendRedraw(int n) throws DOMException {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        if (!sVGSVGContext.unsuspendRedraw(n)) {
            throw this.createDOMException((short)8, "invalid.suspend.handle", new Object[]{new Integer(n)});
        }
    }

    public void unsuspendRedrawAll() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unsuspendRedrawAll();
    }

    public void forceRedraw() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.forceRedraw();
    }

    public void pauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.pauseAnimations();
    }

    public void unpauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unpauseAnimations();
    }

    public boolean animationsPaused() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.animationsPaused();
    }

    public float getCurrentTime() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.getCurrentTime();
    }

    public void setCurrentTime(float f) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.setCurrentTime(f);
    }

    public NodeList getIntersectionList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getIntersectionList(sVGRect, sVGElement);
        return new ListNodeList(list);
    }

    public NodeList getEnclosureList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getEnclosureList(sVGRect, sVGElement);
        return new ListNodeList(list);
    }

    public boolean checkIntersection(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkIntersection(sVGElement, sVGRect);
    }

    public boolean checkEnclosure(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkEnclosure(sVGElement, sVGRect);
    }

    public void deselectAll() {
        ((SVGSVGContext)this.getSVGContext()).deselectAll();
    }

    public SVGNumber createSVGNumber() {
        return new SVGNumber(){
            protected float value;

            public float getValue() {
                return this.value;
            }

            public void setValue(float f) {
                this.value = f;
            }
        };
    }

    public SVGLength createSVGLength() {
        return new SVGOMLength(this);
    }

    public SVGAngle createSVGAngle() {
        return new SVGOMAngle();
    }

    public SVGPoint createSVGPoint() {
        return new SVGOMPoint(0.0f, 0.0f);
    }

    public SVGMatrix createSVGMatrix() {
        return new AbstractSVGMatrix(){
            protected AffineTransform at = new AffineTransform();

            protected AffineTransform getAffineTransform() {
                return this.at;
            }
        };
    }

    public SVGRect createSVGRect() {
        return new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public SVGTransform createSVGTransform() {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setType((short)1);
        return sVGOMTransform;
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setMatrix(sVGMatrix);
        return sVGOMTransform;
    }

    public Element getElementById(String string) {
        return this.ownerDocument.getChildElementById(this, string);
    }

    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement(this);
    }

    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement(this);
    }

    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox(this);
    }

    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM(this);
    }

    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM(this);
    }

    public SVGMatrix getTransformToElement(SVGElement sVGElement) throws SVGException {
        return SVGLocatableSupport.getTransformToElement(this, sVGElement);
    }

    public DocumentView getDocument() {
        return (DocumentView)((Object)this.getOwnerDocument());
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        AbstractView abstractView = ((DocumentView)((Object)this.getOwnerDocument())).getDefaultView();
        return ((ViewCSS)abstractView).getComputedStyle(element, string);
    }

    public Event createEvent(String string) throws DOMException {
        return ((DocumentEvent)((Object)this.getOwnerDocument())).createEvent(string);
    }

    public boolean canDispatch(String string, String string2) throws DOMException {
        AbstractDocument abstractDocument = (AbstractDocument)this.getOwnerDocument();
        return abstractDocument.canDispatch(string, string2);
    }

    public StyleSheetList getStyleSheets() {
        return ((DocumentStyle)((Object)this.getOwnerDocument())).getStyleSheets();
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        return ((DocumentCSS)((Object)this.getOwnerDocument())).getOverrideStyle(element, string);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang(this);
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace(this);
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public short getZoomAndPan() {
        return SVGZoomAndPanSupport.getZoomAndPan(this);
    }

    public void setZoomAndPan(short s) {
        SVGZoomAndPanSupport.setZoomAndPan(this, s);
    }

    public SVGAnimatedRect getViewBox() {
        throw new UnsupportedOperationException("SVGFitToViewBox.getViewBox is not implemented");
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return SVGPreserveAspectRatioSupport.getPreserveAspectRatio(this);
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return SVGExternalResourcesRequiredSupport.getExternalResourcesRequired(this);
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures(this);
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions(this);
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage(this);
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension(this, string);
    }

    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMSVGElement();
    }

    public boolean isAttributeAnimatable(String string, String string2) {
        if (string == null && (string2.equals("externalResourcesRequired") || string2.equals("x") || string2.equals("y") || string2.equals("width") || string2.equals("height"))) {
            return true;
        }
        return super.isAttributeAnimatable(string, string2);
    }

    public int getAttributeType(String string, String string2) {
        if (string == null) {
            if (string2.equals("baseProfile") || string2.equals("contentScriptType") || string2.equals("contentStyleType") || string2.equals("version")) {
                return 16;
            }
            if (string2.equals("x") || string2.equals("y") || string2.equals("width") || string2.equals("height")) {
                return 3;
            }
            if (string2.equals("preserveAspectRatio")) {
                return 32;
            }
            if (string2.equals("viewBox")) {
                return 13;
            }
            if (string2.equals("externalResourcesRequired")) {
                return 49;
            }
        }
        return super.getAttributeType(string, string2);
    }

    protected short getAttributePercentageInterpretation(String string, String string2) {
        if (string == null) {
            if (string2.equals("x") || string2.equals("width")) {
                return 1;
            }
            if (string2.equals("y") || string2.equals("height")) {
                return 2;
            }
        }
        return super.getAttributePercentageInterpretation(string, string2);
    }

    public void updateAttributeValue(String string, String string2, AnimatableValue animatableValue) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                this.updateBooleanAttributeValue(this.getExternalResourcesRequired(), animatableValue);
                return;
            }
            if (string2.equals("x")) {
                this.updateLengthAttributeValue(this.getX(), animatableValue);
                return;
            }
            if (string2.equals("y")) {
                this.updateLengthAttributeValue(this.getY(), animatableValue);
                return;
            }
            if (string2.equals("width")) {
                this.updateLengthAttributeValue(this.getWidth(), animatableValue);
                return;
            }
            if (string2.equals("height")) {
                this.updateLengthAttributeValue(this.getHeight(), animatableValue);
                return;
            }
        }
        super.updateAttributeValue(string, string2, animatableValue);
    }

    public AnimatableValue getUnderlyingValue(String string, String string2) {
        if (string == null) {
            if (string2.equals("externalResourcesRequired")) {
                return this.getBaseValue(this.getExternalResourcesRequired());
            }
            if (string2.equals("x")) {
                return this.getBaseValue(this.getX(), (short)1);
            }
            if (string2.equals("y")) {
                return this.getBaseValue(this.getY(), (short)2);
            }
            if (string2.equals("width")) {
                return this.getBaseValue(this.getWidth(), (short)1);
            }
            if (string2.equals("height")) {
                return this.getBaseValue(this.getHeight(), (short)2);
            }
        }
        return super.getUnderlyingValue(string, string2);
    }

    static {
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", "http://www.w3.org/2000/svg");
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        attributeInitializer.addAttribute(null, null, "zoomAndPan", "magnify");
        attributeInitializer.addAttribute(null, null, "version", "1.0");
        attributeInitializer.addAttribute(null, null, "contentScriptType", "text/ecmascript");
        attributeInitializer.addAttribute(null, null, "contentStyleType", "text/css");
    }
}

