/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrappedException;

public class BatikSecurityController
extends SecurityController {
    public GeneratedClassLoader createClassLoader(ClassLoader classLoader, Object object) {
        if (object instanceof RhinoClassLoader) {
            return (RhinoClassLoader)object;
        }
        throw new SecurityException("Script() objects are not supported");
    }

    public Object getDynamicSecurityDomain(Object object) {
        RhinoClassLoader rhinoClassLoader = (RhinoClassLoader)object;
        if (rhinoClassLoader != null) {
            return rhinoClassLoader;
        }
        return AccessController.getContext();
    }

    public Object callWithDomain(Object object, final Context context, final Callable callable, final Scriptable scriptable, final Scriptable scriptable2, final Object[] objectArray) {
        Object object2;
        AccessControlContext accessControlContext;
        if (object instanceof AccessControlContext) {
            accessControlContext = (AccessControlContext)object;
        } else {
            object2 = (RhinoClassLoader)object;
            accessControlContext = ((RhinoClassLoader)object2).rhinoAccessControlContext;
        }
        object2 = new PrivilegedExceptionAction(){

            public Object run() {
                return callable.call(context, scriptable, scriptable2, objectArray);
            }
        };
        try {
            return AccessController.doPrivileged(object2, accessControlContext);
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }
}

