/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXFHatch;
import org.kabeja.dxf.helpers.HatchLineFamily;
import org.kabeja.dxf.helpers.HatchLineSegment;
import org.kabeja.dxf.helpers.ParametricLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.math.MathUtils;

public class HatchLineIterator
implements Iterator {
    public static final double LIMIT = 1.0E-5;
    protected double angle;
    protected Bounds hatchBounds;
    protected HatchLineFamily pattern;
    protected double length;
    protected Vector v;
    protected Vector r;
    protected List bounderyEdges;
    protected ParametricLine patternLine;
    protected double tmin = Double.POSITIVE_INFINITY;
    protected double tmax = Double.NEGATIVE_INFINITY;
    protected double walkingLength;
    protected double currentWalkingStep = 0.0;

    public HatchLineIterator(DXFHatch dXFHatch, HatchLineFamily hatchLineFamily) {
        this.angle = Math.toRadians(hatchLineFamily.getRotationAngle());
        this.hatchBounds = dXFHatch.getBounds();
        this.length = hatchLineFamily.getLength();
        this.bounderyEdges = new ArrayList();
        Point point = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY(), 0.0);
        Point point2 = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(point, MathUtils.getVector(point, point2)));
        point = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY(), 0.0);
        point2 = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(point, MathUtils.getVector(point, point2)));
        point = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY(), 0.0);
        point2 = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(point, MathUtils.getVector(point, point2)));
        point = new Point(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY(), 0.0);
        point2 = new Point(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY(), 0.0);
        this.bounderyEdges.add(new ParametricLine(point, MathUtils.getVector(point, point2)));
        this.pattern = hatchLineFamily;
        this.initialize();
    }

    public boolean hasNext() {
        return this.currentWalkingStep <= this.walkingLength;
    }

    protected void initialize() {
        if (this.length == 0.0) {
            this.length = 1.0;
        }
        Point point = new Point();
        point.setX(this.hatchBounds.getMinimumX() + this.hatchBounds.getWidth() / 2.0);
        point.setY(this.hatchBounds.getMinimumY() + this.hatchBounds.getHeight() / 2.0);
        point.setZ(0.0);
        this.r = new Vector();
        if (Math.abs(this.pattern.getOffsetY()) < 1.0E-5) {
            this.r.setY(0.0);
        } else {
            this.r.setY(this.pattern.getOffsetY());
        }
        if (Math.abs(this.pattern.getOffsetX()) < 1.0E-5) {
            this.r.setX(0.0);
        } else {
            this.r.setX(this.pattern.getOffsetX());
        }
        this.v = new Vector();
        this.v.setX(this.length * Math.cos(this.angle));
        this.v.setY(this.length * Math.sin(this.angle));
        if (Math.abs(this.v.getX()) < 1.0E-5) {
            this.v.setX(0.0);
        }
        if (Math.abs(this.v.getY()) < 1.0E-5) {
            this.v.setY(0.0);
        }
        double[] dArray = this.getRasterValues(point.getX(), point.getY());
        point = this.getPoint(Math.round(dArray[0]), Math.round(dArray[1]));
        this.patternLine = new ParametricLine(point, this.r);
        this.calculateIntersection(this.hatchBounds.getMinimumX(), this.hatchBounds.getMaximumY());
        this.calculateIntersection(this.hatchBounds.getMinimumX(), this.hatchBounds.getMinimumY());
        this.calculateIntersection(this.hatchBounds.getMaximumX(), this.hatchBounds.getMinimumY());
        this.calculateIntersection(this.hatchBounds.getMaximumX(), this.hatchBounds.getMaximumY());
        this.tmin = Math.floor(this.tmin);
        this.tmax = Math.ceil(this.tmax);
        Point point2 = this.patternLine.getPointAt(this.tmin);
        this.patternLine.setStartPoint(point2);
        this.walkingLength = Math.ceil(Math.abs(this.tmax - this.tmin));
    }

    protected void calculateIntersection(double d, double d2) {
        Point point = new Point(d, d2, 0.0);
        ParametricLine parametricLine = new ParametricLine(point, this.v);
        double d3 = this.patternLine.getIntersectionParameter(parametricLine);
        if (d3 < this.tmin) {
            this.tmin = d3;
        }
        if (d3 > this.tmax) {
            this.tmax = d3;
        }
    }

    protected double[] getRasterValues(double d, double d2) {
        double[] dArray = new double[2];
        if (this.r.getX() == 0.0) {
            dArray[0] = (d - this.pattern.getBaseX()) / this.v.getX();
            dArray[1] = (d2 - this.pattern.getBaseY() - this.v.getY() * dArray[0]) / this.r.getY();
        } else if (this.r.getY() == 0.0) {
            dArray[0] = (d2 - this.pattern.getBaseY()) / this.v.getY();
            dArray[1] = (d - this.pattern.getBaseX()) / this.r.getX();
        } else if (this.v.getX() == 0.0) {
            dArray[1] = (d - this.pattern.getBaseX()) / this.r.getX();
            dArray[0] = (d2 - this.pattern.getBaseY() - this.r.getY() * dArray[1]) / this.v.getY();
        } else if (this.v.getY() == 0.0) {
            dArray[1] = (d2 - this.pattern.getBaseY()) / this.r.getY();
            dArray[0] = (d - this.pattern.getBaseX() - this.r.getX() * dArray[1]) / this.v.getX();
        } else {
            double d3 = this.r.getY() / this.r.getX();
            dArray[0] = (d2 - this.pattern.getBaseY() - d * d3 + this.pattern.getBaseX() * d3) / (this.v.getY() - d3 * this.v.getX());
            dArray[1] = (d - this.pattern.getBaseX() - this.v.getX() * dArray[0]) / this.r.getX();
        }
        return dArray;
    }

    public Object next() {
        Object object;
        Point point = this.patternLine.getPointAt(this.currentWalkingStep);
        ParametricLine parametricLine = new ParametricLine(point, this.v);
        Iterator iterator = this.bounderyEdges.iterator();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        while (iterator.hasNext()) {
            ParametricLine parametricLine2 = (ParametricLine)iterator.next();
            double d = parametricLine2.getIntersectionParameter(parametricLine);
            if (!(d >= 0.0) || !(d < 1.0)) continue;
            arrayList.add(parametricLine2.getPointAt(d));
        }
        double d = 0.0;
        double d2 = 0.0;
        if (arrayList.size() == 2) {
            object = (Point)arrayList.get(0);
            double d3 = parametricLine.getParameter((Point)object);
            Point point2 = (Point)arrayList.get(1);
            double d4 = parametricLine.getParameter(point2);
            d = 0.0;
            if (d3 > d4) {
                parametricLine.setStartPoint(point2);
                d = Math.abs(d4 - Math.floor(d4)) * this.length;
            } else {
                parametricLine.setStartPoint((Point)object);
                d = Math.abs(d3 - Math.floor(d3)) * this.length;
            }
            d2 = Math.abs(d4 - d3) * this.length;
        }
        parametricLine.setDirectionVector(MathUtils.normalize(this.v));
        object = new HatchLineSegment(parametricLine, d2, d, this.pattern.getPattern());
        this.currentWalkingStep += 1.0;
        return object;
    }

    public void remove() {
    }

    protected Point getPoint(double d, double d2) {
        Point point = new Point();
        point.setX(d2 * this.r.getX() + this.pattern.getBaseX() + this.v.getX() * d);
        point.setY(d2 * this.r.getY() + this.pattern.getBaseY() + this.v.getY() * d);
        return point;
    }
}

