/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.dxf.helpers;

import org.kabeja.dxf.DXFMLine;
import org.kabeja.dxf.DXFPolyline;
import org.kabeja.dxf.DXFVertex;
import org.kabeja.dxf.helpers.DXFMLineSegment;
import org.kabeja.dxf.helpers.DXFMLineSegmentElement;
import org.kabeja.dxf.helpers.ParametricLine;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;
import org.kabeja.dxf.objects.DXFMLineStyle;
import org.kabeja.dxf.objects.DXFMLineStyleElement;
import org.kabeja.math.MathUtils;

public class MLineConverter {
    public static DXFPolyline[] toDXFPolyline(DXFMLine dXFMLine) {
        Object object;
        Object object2;
        DXFMLineStyle dXFMLineStyle = (DXFMLineStyle)dXFMLine.getDXFDocument().getDXFObjectByID(dXFMLine.getMLineStyleID());
        DXFPolyline[] dXFPolylineArray = new DXFPolyline[dXFMLineStyle.getDXFMLineStyleLElementCount()];
        for (int i = 0; i < dXFPolylineArray.length; ++i) {
            object2 = dXFMLineStyle.getDXFMLineStyleLElement(i);
            dXFPolylineArray[i] = new DXFPolyline();
            dXFPolylineArray[i].setDXFDocument(dXFMLine.getDXFDocument());
            dXFPolylineArray[i].setLineType(((DXFMLineStyleElement)object2).getLineType());
            dXFPolylineArray[i].setColor(((DXFMLineStyleElement)object2).getLineColor());
            if (!dXFMLine.isClosed()) continue;
            dXFPolylineArray[i].setFlags(1);
        }
        Vector vector = new Vector();
        object2 = new Vector();
        ParametricLine parametricLine = new ParametricLine();
        ParametricLine parametricLine2 = new ParametricLine();
        for (int i = 0; i < dXFMLine.getDXFMLineSegmentCount(); ++i) {
            object = dXFMLine.getDXFMLineSegment(i);
            vector = ((DXFMLineSegment)object).getDirection();
            object2 = ((DXFMLineSegment)object).getMiterDirection();
            parametricLine2.setStartPoint(((DXFMLineSegment)object).getStartPoint());
            parametricLine2.setDirectionVector((Vector)object2);
            for (int j = 0; j < ((DXFMLineSegment)object).getDXFMLineSegmentElementCount(); ++j) {
                DXFMLineSegmentElement dXFMLineSegmentElement = ((DXFMLineSegment)object).getDXFMLineSegmentElement(j);
                double[] dArray = dXFMLineSegmentElement.getLengthParameters();
                Point point = parametricLine2.getPointAt(dArray[0]);
                parametricLine.setStartPoint(point);
                parametricLine.setDirectionVector(vector);
                dXFPolylineArray[j].addVertex(new DXFVertex(parametricLine.getPointAt(dArray[1])));
            }
        }
        if (dXFMLineStyle.hasEndRoundCaps()) {
            Point point = dXFPolylineArray[0].getVertex(dXFPolylineArray[0].getVertexCount() - 1).getPoint();
            object = dXFPolylineArray[dXFPolylineArray.length - 1].getVertex(dXFPolylineArray[dXFPolylineArray.length - 1].getVertexCount() - 1).getPoint();
            Vector vector2 = MathUtils.getVector(point, (Point)object);
            double d = vector2.getLength();
            double d2 = d / 2.0;
            double d3 = Math.sqrt(2.0) * d2;
            double d4 = d2 - Math.sqrt(0.5) * d2;
            double d5 = d4 * 2.0 / d3;
            vector2.normalize();
            ParametricLine parametricLine3 = new ParametricLine(point, vector2);
            Point point2 = parametricLine3.getPointAt(d2);
            parametricLine3.setStartPoint(point2);
            vector.normalize();
            parametricLine3.setDirectionVector(vector);
            point2 = parametricLine3.getPointAt(d2);
            dXFPolylineArray[0].getVertex(dXFPolylineArray[0].getVertexCount() - 1).setBulge(-1.0 * d5);
            dXFPolylineArray[0].addVertex(new DXFVertex(point2));
            dXFPolylineArray[dXFPolylineArray.length - 1].getVertex(dXFPolylineArray[dXFPolylineArray.length - 1].getVertexCount() - 1).setBulge(d5);
            dXFPolylineArray[dXFPolylineArray.length - 1].addVertex(new DXFVertex(point2));
        }
        return dXFPolylineArray;
    }
}

