/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.math;

import org.kabeja.dxf.helpers.Point;
import org.kabeja.dxf.helpers.Vector;

public class MathUtils {
    public static final double DISTANCE_DELTA = 1.0E-5;

    public static double scalarProduct(Vector vector, Vector vector2) {
        double d = vector.getX() * vector2.getX() + vector.getY() * vector2.getY() + vector.getZ() * vector2.getZ();
        return d;
    }

    public static double absoluteValue(Vector vector) {
        double d = Math.sqrt(Math.pow(vector.getX(), 2.0) + Math.pow(vector.getY(), 2.0) + Math.pow(vector.getZ(), 2.0));
        return d;
    }

    public static Vector crossProduct(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        vector3.setX(vector.getY() * vector2.getZ() - vector.getZ() * vector2.getY());
        vector3.setY(vector.getZ() * vector2.getX() - vector.getX() * vector2.getZ());
        vector3.setZ(vector.getX() * vector2.getY() - vector.getY() * vector2.getX());
        return vector3;
    }

    public static Vector scaleVector(Vector vector, double d) {
        Vector vector2 = new Vector();
        vector2.setX(vector.getX() * d);
        vector2.setY(vector.getY() * d);
        vector2.setZ(vector.getZ() * d);
        return vector2;
    }

    public static Point getPointOfStraightLine(Point point, Vector vector, double d) {
        Point point2 = new Point();
        Vector vector2 = MathUtils.scaleVector(vector, d);
        point2.setX(point.getX() + vector2.getX());
        point2.setY(point.getY() + vector2.getY());
        point2.setZ(point.getZ() + vector2.getZ());
        return point2;
    }

    public static Vector getVector(Point point, Point point2) {
        Vector vector = new Vector();
        vector.setX(point2.getX() - point.getX());
        vector.setY(point2.getY() - point.getY());
        vector.setZ(point2.getZ() - point.getZ());
        return vector;
    }

    public static Point getIntersection(Point point, Vector vector, Point point2, Vector vector2) {
        Vector vector3 = MathUtils.crossProduct(vector, vector2);
        Vector vector4 = MathUtils.crossProduct(MathUtils.getVector(point, point2), vector2);
        double d = 0.0;
        if (vector3.getZ() != 0.0) {
            d = vector4.getZ() / vector3.getZ();
        } else if (vector3.getY() != 0.0) {
            d = vector4.getY() / vector3.getY();
        } else if (vector3.getX() != 0.0) {
            d = vector4.getX() / vector3.getX();
        }
        Point point3 = MathUtils.getPointOfStraightLine(point, vector, d);
        return point3;
    }

    public static double distance(Point point, Point point2) {
        double d = Math.sqrt(Math.pow(point2.getX() - point.getX(), 2.0) + Math.pow(point2.getY() - point.getY(), 2.0) + Math.pow(point2.getZ() - point.getZ(), 2.0));
        return d;
    }

    public static double getAngle(Vector vector, Vector vector2) {
        double d = MathUtils.scalarProduct(vector, vector2) / (MathUtils.absoluteValue(vector) * MathUtils.absoluteValue(vector2));
        return Math.acos(d);
    }

    public static Point rotatePointXY(Point point, Point point2, double d) {
        Point point3 = new Point();
        point3.setX(point2.getX() + Math.cos(d) * (point.getX() - point2.getX()) - (point.getY() - point2.getY()) * Math.sin(d));
        point3.setY(point2.getY() + Math.cos(d) * (point.getY() - point2.getY()) - (point.getX() - point2.getX()) * Math.sin(d));
        point3.setZ(point.getZ());
        return point3;
    }

    public static Vector normalize(Vector vector) {
        double d = MathUtils.absoluteValue(vector);
        return MathUtils.scaleVector(vector, 1.0 / d);
    }

    public static int getQuadrant(Point point, Point point2) {
        if (point.getX() < point2.getX()) {
            if (point.getY() >= point2.getY()) {
                return 1;
            }
            return 2;
        }
        if (point.getY() >= point2.getY()) {
            return 0;
        }
        return 3;
    }

    public static int getQuadrant(double d) {
        if (d > 360.0) {
            d -= Math.floor(d / 360.0) * 360.0;
        }
        if (d >= 0.0 && d < 90.0) {
            return 0;
        }
        if (d >= 90.0 && d < 180.0) {
            return 1;
        }
        if (d >= 180.0 && d < 270.0) {
            return 2;
        }
        return 3;
    }

    public static double getDirectionAngle(Vector vector) {
        double d = MathUtils.absoluteValue(vector);
        if (vector.getX() < 0.0 && vector.getY() < 0.0) {
            return Math.toDegrees(Math.acos(Math.abs(vector.getX() / d))) + 180.0;
        }
        if (vector.getX() == 0.0 || vector.getY() < 0.0) {
            return Math.toDegrees(Math.asin(vector.getY() / d));
        }
        return Math.toDegrees(Math.acos(vector.getX() / d));
    }

    public static Vector invertDirection(Vector vector) {
        return MathUtils.scaleVector(vector, -1.0);
    }

    public static double[][] multiplyMatrixByMatrix(double[][] dArray, double[][] dArray2) throws IllegalArgumentException {
        if (dArray[0].length != dArray2.length) {
            throw new IllegalArgumentException("Cannot multiply a with b, columns of a != rows of b. ");
        }
        double[][] dArray3 = new double[dArray.length][dArray2[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2[0].length; ++j) {
                for (int k = 0; k < dArray2.length; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray[i][k] * dArray2[j][k];
                }
            }
        }
        return dArray3;
    }

    public static double[] multiplyMatrixByVector(double[][] dArray, double[] dArray2) throws IllegalArgumentException {
        if (dArray[0].length != dArray2.length) {
            throw new IllegalArgumentException("Cannot multiply a with v, columns of a != rows of v. ");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static Vector subtractVectorByVector(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        vector3.setX(vector.getX() - vector2.getX());
        vector3.setY(vector.getY() - vector2.getY());
        vector3.setZ(vector.getZ() - vector2.getZ());
        return vector3;
    }

    public static Vector addVectorToVector(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        vector3.setX(vector.getX() + vector2.getX());
        vector3.setY(vector.getY() + vector2.getY());
        vector3.setZ(vector.getZ() + vector2.getZ());
        return vector3;
    }
}

