/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.processing;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.Bounds;
import org.kabeja.dxf.DXF3DFace;
import org.kabeja.dxf.DXFBlock;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLayer;
import org.kabeja.dxf.DXFText;
import org.kabeja.processing.AbstractPostProcessor;
import org.kabeja.processing.ProcessorException;

public class BoundsDebugger
extends AbstractPostProcessor {
    public static final String LAYER_NAME = "kabeja_bounds_debug";

    public void process(DXFDocument dXFDocument, Map map) throws ProcessorException {
        DXFEntity dXFEntity;
        Object object;
        Object object2;
        Iterator iterator = dXFDocument.getDXFBlockIterator();
        while (iterator.hasNext()) {
            object2 = (DXFBlock)iterator.next();
            object = ((DXFBlock)object2).getDXFEntitiesIterator();
            while (object.hasNext()) {
                dXFEntity = (DXFEntity)object.next();
                dXFEntity.setColor(9);
            }
        }
        object2 = null;
        object = null;
        dXFEntity = null;
        DXFEntity dXFEntity2 = null;
        Bounds bounds = dXFDocument.getBounds();
        double d = bounds.getMinimumX() + bounds.getWidth() / 2.0;
        double d2 = bounds.getMinimumY() + bounds.getHeight() / 2.0;
        Bounds bounds2 = new Bounds(d, d, d2, d2);
        Bounds bounds3 = new Bounds(d, d, d2, d2);
        Bounds bounds4 = new Bounds(d, d, d2, d2);
        Bounds bounds5 = new Bounds(d, d, d2, d2);
        iterator = dXFDocument.getDXFLayerIterator();
        while (iterator.hasNext()) {
            DXFLayer dXFLayer = (DXFLayer)iterator.next();
            dXFLayer.setColor(8);
            Iterator iterator2 = dXFLayer.getDXFEntityTypeIterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                Iterator iterator3 = dXFLayer.getDXFEntities(string).iterator();
                while (iterator3.hasNext()) {
                    DXFEntity dXFEntity3 = (DXFEntity)iterator3.next();
                    dXFEntity3.setColor(8);
                    Bounds bounds6 = dXFEntity3.getBounds();
                    if (!bounds6.isValid()) continue;
                    if (bounds6.getMinimumX() <= bounds2.getMinimumX()) {
                        bounds2 = bounds6;
                        object2 = dXFEntity3;
                    }
                    if (bounds6.getMinimumY() <= bounds5.getMinimumY()) {
                        bounds5 = bounds6;
                        dXFEntity2 = dXFEntity3;
                    }
                    if (bounds6.getMaximumX() >= bounds3.getMaximumX()) {
                        bounds3 = bounds6;
                        dXFEntity = dXFEntity3;
                    }
                    if (!(bounds6.getMaximumY() >= bounds4.getMaximumY())) continue;
                    bounds4 = bounds6;
                    object = dXFEntity3;
                }
            }
        }
        ((DXFEntity)object2).setColor(0);
        this.addBounds(bounds2, dXFDocument, 0, ((DXFEntity)object2).getType() + "=" + ((DXFEntity)object2).getID());
        dXFEntity.setColor(2);
        this.addBounds(bounds3, dXFDocument, 2, dXFEntity.getType() + "=" + dXFEntity.getID());
        dXFEntity2.setColor(4);
        this.addBounds(bounds5, dXFDocument, 4, dXFEntity2.getType() + "=" + dXFEntity2.getID());
        ((DXFEntity)object).setColor(5);
        this.addBounds(bounds4, dXFDocument, 5, ((DXFEntity)object).getType() + "=" + ((DXFEntity)object).getID());
        ((DXFEntity)object).setColor(5);
        this.addBounds(bounds, dXFDocument, 6, "ALL");
    }

    protected void addBounds(Bounds bounds, DXFDocument dXFDocument, int n, String string) {
        DXF3DFace dXF3DFace = new DXF3DFace();
        dXF3DFace.getPoint1().setX(bounds.getMinimumX());
        dXF3DFace.getPoint1().setY(bounds.getMinimumY());
        dXF3DFace.getPoint2().setX(bounds.getMinimumX());
        dXF3DFace.getPoint2().setY(bounds.getMaximumY());
        dXF3DFace.getPoint3().setX(bounds.getMaximumX());
        dXF3DFace.getPoint3().setY(bounds.getMaximumY());
        dXF3DFace.getPoint4().setX(bounds.getMaximumX());
        dXF3DFace.getPoint4().setY(bounds.getMinimumY());
        dXF3DFace.setColor(n);
        dXF3DFace.setLayerName(LAYER_NAME);
        dXFDocument.addDXFEntity(dXF3DFace);
        DXFText dXFText = new DXFText();
        dXFText.setDXFDocument(dXFDocument);
        dXFText.setText("DEBUG-" + string);
        dXFText.getInsertPoint().setX(bounds.getMinimumX());
        dXFText.getInsertPoint().setY(bounds.getMaximumY());
        dXFText.setColor(n);
        dXFText.setLayerName(LAYER_NAME);
        dXFDocument.addDXFEntity(dXFText);
    }

    public void setProperties(Map map) {
    }
}

