/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.svg.generators;

import java.util.Iterator;
import java.util.Map;
import org.kabeja.dxf.DXFConstants;
import org.kabeja.dxf.DXFDimensionStyle;
import org.kabeja.dxf.DXFEntity;
import org.kabeja.dxf.DXFLeader;
import org.kabeja.dxf.helpers.Point;
import org.kabeja.math.MathUtils;
import org.kabeja.math.TransformContext;
import org.kabeja.svg.SVGUtils;
import org.kabeja.svg.generators.AbstractSVGSAXGenerator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGLeaderGenerator
extends AbstractSVGSAXGenerator {
    public void toSAX(ContentHandler handler, Map svgContext, DXFEntity entity, TransformContext transformContext) throws SAXException {
        DXFLeader leader = (DXFLeader)entity;
        if (!leader.isSplinePath()) {
            Iterator i = leader.getCoordinateIterator();
            StringBuffer buf = new StringBuffer();
            buf.append('M');
            while (i.hasNext()) {
                buf.append(' ');
                Point p = (Point)i.next();
                buf.append(p.getX());
                buf.append(' ');
                buf.append(p.getY());
                if (!i.hasNext()) continue;
                buf.append(" L");
            }
            AttributesImpl attr = new AttributesImpl();
            super.setCommonAttributes(attr, svgContext, leader);
            SVGUtils.addAttribute(attr, "d", buf.toString());
            SVGUtils.emptyElement(handler, "path", attr);
            DXFDimensionStyle style = leader.getDXFDocument().getDXFDimensionStyle(leader.getStyleNameID());
            if (leader.isArrowEnabled() && style != null && style.hasProperty("341")) {
                double arrowLength;
                Point p2;
                Point p1;
                double length;
                String blockID = style.getProperty("341");
                if (leader.getCoordinateCount() > 1 && (length = MathUtils.distance(p1 = leader.getCoordinateAt(0), p2 = leader.getCoordinateAt(1))) > 2.0 * (arrowLength = style.getDoubleProperty("41", 0.0) * style.getDoubleProperty("40", 1.0))) {
                    double angle = Math.toDegrees(MathUtils.getAngle(MathUtils.getVector(p1, p2), DXFConstants.DEFAULT_X_AXIS_VECTOR));
                    attr = new AttributesImpl();
                    if (angle != 0.0) {
                        SVGUtils.addAttribute(attr, "transform", "rotate(" + angle + ")");
                    }
                    SVGUtils.startElement(handler, "g", attr);
                    attr = new AttributesImpl();
                    attr.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink");
                    attr.addAttribute("http://www.w3.org/1999/xlink", "href", "xlink:href", "CDATA", "#" + SVGUtils.validateID(blockID));
                    SVGUtils.emptyElement(handler, "use", attr);
                    SVGUtils.endElement(handler, "g");
                }
            }
        }
    }
}

