/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.tools.SAXProcessingManagerBuilder;
import org.kabeja.ui.impl.Messages;
import org.kabeja.ui.impl.ServiceContainer;

public class OpenProcessingAction
extends AbstractAction {
    protected String baseDir = "";
    protected ServiceContainer container;

    public OpenProcessingAction(ServiceContainer serviceContainer) {
        super(Messages.getString("OpenProcessingAction.menuitem"));
        this.putValue("ShortDescription", Messages.getString("OpenProcessingAction.menuitem.description"));
        this.container = serviceContainer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                OpenProcessingAction.this.openProcessing();
            }
        });
        thread.start();
    }

    protected void openProcessing() {
        JFileChooser jFileChooser = new JFileChooser(this.baseDir);
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                ProcessingManager processingManager = SAXProcessingManagerBuilder.buildFromStream(new FileInputStream(file));
                this.container.setProcessingManager(processingManager);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }
}

