/*
 * Decompiled with CFR 0.152.
 */
package org.kabeja.ui.impl;

import de.miethxml.toolkit.ui.PanelFactory;
import de.miethxml.toolkit.ui.UIUtils;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.kabeja.dxf.DXFDocument;
import org.kabeja.parser.Parser;
import org.kabeja.parser.ParserBuilder;
import org.kabeja.processing.ProcessPipeline;
import org.kabeja.processing.ProcessingManager;
import org.kabeja.ui.ApplicationMenuBar;
import org.kabeja.ui.ApplicationToolBar;
import org.kabeja.ui.Component;
import org.kabeja.ui.DXFDocumentViewComponent;
import org.kabeja.ui.PropertiesEditor;
import org.kabeja.ui.PropertiesListener;
import org.kabeja.ui.ServiceManager;
import org.kabeja.ui.Serviceable;
import org.kabeja.ui.UIException;
import org.kabeja.ui.ViewComponent;
import org.kabeja.ui.event.DXFDocumentChangeEventProvider;
import org.kabeja.ui.event.DXFDocumentChangeListener;
import org.kabeja.ui.impl.DXFFileTransferHandler;
import org.kabeja.ui.impl.Messages;

public class ProcessingRunViewComponent
implements ViewComponent,
Serviceable,
ActionListener,
PropertiesListener,
DXFDocumentChangeEventProvider {
    protected JTabbedPane tabbedPane;
    protected JComponent view;
    protected JPanel pipelinePanel;
    protected boolean locked = false;
    protected boolean initialized = false;
    protected List viewComponents = new ArrayList();
    protected String processingPipeline;
    protected JTextArea logView;
    protected ProcessingManager manager;
    protected String baseDir = "./samples/dxf";
    protected File sourceFile;
    protected DXFDocument doc;
    protected boolean autogenerateOutput = false;
    protected Map properties = new HashMap();
    protected ArrayList listeners = new ArrayList();

    public String getTitle() {
        return "Run Processing";
    }

    public JComponent getView() {
        this.initialize();
        return this.view;
    }

    protected void initialize() {
        if (!this.initialized) {
            JPanel jPanel = PanelFactory.createTitledPanel((JComponent)new JPanel(), Messages.getString("ProcessingRunViewComponent.processing.pipeline"), new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/project.gif")));
            this.pipelinePanel = new JPanel(new GridLayout(0, 1, 0, 3));
            this.pipelinePanel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
            JScrollPane jScrollPane = new JScrollPane(this.pipelinePanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel.add(jScrollPane);
            JSplitPane jSplitPane = PanelFactory.createOneTouchSplitPane();
            jSplitPane.setLeftComponent(jPanel);
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jSplitPane.setRightComponent(this.tabbedPane);
            jSplitPane.setDividerLocation(150);
            JSplitPane jSplitPane2 = PanelFactory.createOneTouchSplitPane(0);
            jSplitPane2.setTopComponent(jSplitPane);
            this.logView = new JTextArea();
            jScrollPane = new JScrollPane(this.logView);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JPanel jPanel2 = PanelFactory.createTitledPanel(jScrollPane, Messages.getString("ProcessingRunViewComponent.processing.output"));
            jSplitPane2.setBottomComponent(jPanel2);
            jSplitPane2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jSplitPane2.setDividerLocation(400);
            this.view = jSplitPane2;
            DXFFileTransferHandler dXFFileTransferHandler = new DXFFileTransferHandler(this);
            this.view.setTransferHandler(dXFFileTransferHandler);
            this.initialized = true;
        }
    }

    public void setProcessingManager(ProcessingManager processingManager) {
        this.manager = processingManager;
        this.initialize();
        this.pipelinePanel.removeAll();
        Iterator iterator = processingManager.getProcessPipelines().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ProcessPipeline processPipeline = processingManager.getProcessPipeline(string);
            JButton jButton = new JButton(string);
            jButton.setActionCommand(string);
            jButton.addActionListener(this);
            jButton.setToolTipText(processPipeline.getDescription());
            this.pipelinePanel.add(jButton);
        }
        this.pipelinePanel.repaint();
    }

    public void setServiceManager(ServiceManager serviceManager) {
        int n;
        Component[] componentArray = serviceManager.getServiceComponents(ApplicationToolBar.SERVICE);
        AbstractAction abstractAction = new AbstractAction(Messages.getString("ProcessingRunViewComponent.open.draft"), new ImageIcon(UIUtils.resourceToBytes(this.getClass(), "/icons/open.gif"))){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ProcessingRunViewComponent.this.chooseInput();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        };
        for (n = 0; n < componentArray.length; ++n) {
            ((ApplicationToolBar)((Object)componentArray[n])).addAction(abstractAction);
        }
        componentArray = serviceManager.getServiceComponents(PropertiesEditor.SERVICE);
        for (n = 0; n < componentArray.length; ++n) {
            ((PropertiesEditor)((Object)componentArray[n])).addPropertiesListener(this);
        }
        ApplicationMenuBar applicationMenuBar = (ApplicationMenuBar)((Object)serviceManager.getServiceComponents(ApplicationMenuBar.SERVICE)[0]);
        JMenu jMenu = new JMenu(Messages.getString("ProcessingRunViewComponent.process.view.menuitem"));
        if (!applicationMenuBar.hasMenu("menu.view")) {
            applicationMenuBar.setMenu("menu.view", new JMenu(Messages.getString("menu.view")));
        }
        componentArray = serviceManager.getServiceComponents(DXFDocumentViewComponent.SERVICE);
        for (int i = 0; i < componentArray.length; ++i) {
            ViewControl viewControl = new ViewControl((DXFDocumentViewComponent)componentArray[i]);
            this.viewComponents.add(viewControl);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(viewControl.getTitle());
            jCheckBoxMenuItem.setSelected(viewControl.isEnabled());
            jCheckBoxMenuItem.addItemListener(viewControl);
            jMenu.add(jCheckBoxMenuItem);
        }
        applicationMenuBar.setJMenuItem("menu.view", jMenu);
        applicationMenuBar.setAction("menu.file", abstractAction);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.locked) {
            this.processingPipeline = actionEvent.getActionCommand();
            this.locked = true;
            Runnable runnable = new Runnable(){

                public void run() {
                    ProcessingRunViewComponent.this.process();
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    protected void process() {
        try {
            if (this.sourceFile.isDirectory()) {
                File[] fileArray = this.sourceFile.listFiles();
                Parser parser = ParserBuilder.createDefaultParser();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string = fileArray[i].getAbsolutePath();
                    int n = string.lastIndexOf(".");
                    if (n + 1 >= string.length() || !parser.supportedExtension(string = string.substring(string.lastIndexOf(".") + 1))) continue;
                    this.parseFile(fileArray[i], parser);
                    this.processFile(this.doc, fileArray[i]);
                }
            } else if (this.sourceFile.isFile()) {
                this.processFile(this.doc, this.sourceFile);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
        }
        this.locked = false;
    }

    protected void processFile(DXFDocument dXFDocument, File file) {
        try {
            this.logView.append(Messages.getString("ProcessingRunViewComponent.log.processing") + file.getAbsolutePath() + "\n");
            File file2 = null;
            if (this.autogenerateOutput) {
                this.manager.getProcessPipeline(this.processingPipeline);
                String string = this.manager.getProcessPipeline(this.processingPipeline).getSAXSerializer().getSuffix();
                String string2 = file.getAbsolutePath();
                string2 = string2.substring(0, string2.lastIndexOf(46)) + "." + string;
                file2 = new File(string2);
            } else {
                JFileChooser jFileChooser = new JFileChooser(this.baseDir);
                int n = jFileChooser.showSaveDialog(null);
                if (n == 0) {
                    file2 = jFileChooser.getSelectedFile();
                }
            }
            if (file2 != null) {
                this.manager.process(dXFDocument, this.properties, this.processingPipeline, new FileOutputStream(file2));
                this.log(Messages.getString("ProcessingRunViewComponent.log.finished") + file2.getAbsolutePath() + "\n");
            } else {
                this.log("No output set, do nothing.\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logException(exception);
        }
    }

    protected void chooseInput() {
        JFileChooser jFileChooser = new JFileChooser(this.baseDir);
        jFileChooser.setFileSelectionMode(2);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(jCheckBox);
        jPanel.add(new JLabel(Messages.getString("ProcessingRunViewComponent.file.dialog.autogenerate")));
        jFileChooser.setAccessory(jPanel);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.autogenerateOutput = jCheckBox.isSelected();
            if (file.isFile()) {
                this.baseDir = file.getParent();
                this.processInput(file);
            } else if (file.isDirectory()) {
                this.baseDir = file.getAbsolutePath();
                this.log(Messages.getString("ProcessingRunViewComponent.log.select.directory") + file.getAbsolutePath() + "\n");
                this.log("No preview\n");
            }
        }
    }

    protected void parseFile(File file, Parser parser) throws Exception {
        this.sourceFile = file;
        this.logView.append(Messages.getString("ProcessingRunViewComponent.log.parsing") + file.getAbsolutePath() + "\n");
        parser.parse(new FileInputStream(file), "");
        this.doc = parser.getDocument();
    }

    protected void propagateDXFDocument(DXFDocument dXFDocument) throws Exception {
        Iterator iterator = this.viewComponents.iterator();
        while (iterator.hasNext()) {
            ViewControl viewControl = (ViewControl)iterator.next();
            if (!viewControl.isEnabled()) continue;
            viewControl.getDXFDocumentViewComponent().showDXFDocument(dXFDocument);
        }
    }

    protected void logException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        this.log(stringWriter.toString());
    }

    protected void log(String string) {
        this.logView.append(string);
        this.logView.setCaretPosition(this.logView.getDocument().getLength());
    }

    public void propertiesChanged(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.properties.put(string, map.get(string));
        }
    }

    public void addDXFDocumentChangeListener(DXFDocumentChangeListener dXFDocumentChangeListener) {
        this.listeners.add(dXFDocumentChangeListener);
    }

    public void removeDXFDocumentChangeListener(DXFDocumentChangeListener dXFDocumentChangeListener) {
        this.listeners.remove(dXFDocumentChangeListener);
    }

    protected void fireDXFDocumentChangeEvent() throws Exception {
        Iterator iterator = ((ArrayList)this.listeners.clone()).iterator();
        while (iterator.hasNext()) {
            DXFDocumentChangeListener dXFDocumentChangeListener = (DXFDocumentChangeListener)iterator.next();
            if (dXFDocumentChangeListener instanceof DXFDocumentViewComponent) continue;
            dXFDocumentChangeListener.changed(this.doc);
        }
        this.propagateDXFDocument(this.doc);
    }

    public void processInput(File file) {
        Parser parser = ParserBuilder.createDefaultParser();
        try {
            this.parseFile(file, parser);
            this.fireDXFDocumentChangeEvent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logException(exception);
        }
    }

    private class ViewControl
    implements ItemListener {
        private JComponent view;
        private String title;
        private DXFDocumentViewComponent component;
        private int index;

        ViewControl(DXFDocumentViewComponent dXFDocumentViewComponent) {
            this.component = dXFDocumentViewComponent;
            this.view = dXFDocumentViewComponent.getView();
            this.index = ProcessingRunViewComponent.this.tabbedPane.getTabCount();
            ProcessingRunViewComponent.this.tabbedPane.add(dXFDocumentViewComponent.getTitle(), this.view);
        }

        public boolean isEnabled() {
            return this.view.isEnabled();
        }

        public void setEnabled(boolean bl) {
            this.view.setEnabled(bl);
            this.enableChildren(bl, this.view);
            ProcessingRunViewComponent.this.tabbedPane.setEnabledAt(this.index, bl);
            if (bl && ProcessingRunViewComponent.this.doc != null) {
                try {
                    this.component.showDXFDocument(ProcessingRunViewComponent.this.doc);
                }
                catch (UIException uIException) {
                    uIException.printStackTrace();
                }
            }
        }

        public DXFDocumentViewComponent getDXFDocumentViewComponent() {
            return this.component;
        }

        public String getTitle() {
            return this.component.getTitle();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ViewControl.this.setEnabled(true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ViewControl.this.setEnabled(false);
                    }
                });
            }
        }

        protected void enableChildren(boolean bl, Container container) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                java.awt.Component component = container.getComponent(i);
                component.setEnabled(bl);
                if (!(component instanceof Container)) continue;
                this.enableChildren(bl, (Container)component);
            }
        }
    }
}

