/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;

public class Bounds {
    private final Vector3d center;
    private final Vector3d bounds;
    private final Vector3d min;
    private final Vector3d max;
    private CSG csg;
    private Cube cube;

    public Bounds(Vector3d min, Vector3d max) {
        this.center = new Vector3d((max.x + min.x) / 2.0, (max.y + min.y) / 2.0, (max.z + min.z) / 2.0);
        this.bounds = new Vector3d(Math.abs(max.x - min.x), Math.abs(max.y - min.y), Math.abs(max.z - min.z));
        this.min = min.clone();
        this.max = max.clone();
    }

    public Bounds clone() {
        return new Bounds(this.min.clone(), this.max.clone());
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public Vector3d getBounds() {
        return this.bounds;
    }

    public CSG toCSG() {
        if (this.csg == null) {
            this.cube = new Cube(this.center, this.bounds);
            this.csg = this.cube.toCSG();
        }
        return this.csg;
    }

    public Cube toCube() {
        if (this.cube == null) {
            this.cube = new Cube(this.center, this.bounds);
            this.csg = this.cube.toCSG();
        }
        return this.cube;
    }

    public boolean contains(Vertex v) {
        return this.contains(v.pos);
    }

    public boolean contains(Vector3d v) {
        boolean inX = this.min.x <= v.x && v.x <= this.max.x;
        boolean inY = this.min.y <= v.y && v.y <= this.max.y;
        boolean inZ = this.min.z <= v.z && v.z <= this.max.z;
        return inX && inY && inZ;
    }

    public boolean contains(Polygon p) {
        return p.vertices.stream().allMatch(v -> this.contains((Vertex)v));
    }

    @Deprecated
    public boolean intersects(Polygon p) {
        throw new UnsupportedOperationException("Implementation missing!");
    }

    public boolean intersects(Bounds b) {
        if (b.getMin().x > this.getMax().x || b.getMax().x < this.getMin().x) {
            return false;
        }
        if (b.getMin().y > this.getMax().y || b.getMax().y < this.getMin().y) {
            return false;
        }
        return !(b.getMin().z > this.getMax().z) && !(b.getMax().z < this.getMin().z);
    }

    public Vector3d getMin() {
        return this.min;
    }

    public Vector3d getMax() {
        return this.max;
    }

    public String toString() {
        return "[center: " + (Object)((Object)this.center) + ", bounds: " + (Object)((Object)this.bounds) + "]";
    }

    public boolean contains(Transform com) {
        return this.contains(new Vector3d(com.getX(), com.getY(), com.getZ()));
    }
}

