/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.parametrics.LengthParameter;
import java.util.ArrayList;
import java.util.List;

public class Cube
extends Primitive {
    private Vector3d center;
    private Vector3d dimensions;
    private boolean centered = true;
    private final PropertyStorage properties = new PropertyStorage();

    public Cube() {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.dimensions = new Vector3d(1.0, 1.0, 1.0);
    }

    public Cube(double size) {
        this.center = new Vector3d(0.0, 0.0, 0.0);
        this.dimensions = new Vector3d(size, size, size);
    }

    public Cube(Vector3d center, Vector3d dimensions) {
        this.center = center;
        this.dimensions = dimensions;
    }

    public Cube(double w, double h, double d) {
        this(Vector3d.ZERO, new Vector3d(w, h, d));
    }

    public Cube(LengthParameter w, LengthParameter h, LengthParameter d) {
        this(Vector3d.ZERO, new Vector3d(w.getMM(), h.getMM(), d.getMM()));
        this.parametrics.add(w);
        this.parametrics.add(h);
        this.parametrics.add(d);
    }

    public Cube(LengthParameter size) {
        this(size, size, size);
    }

    @Override
    public List<Polygon> toPolygons() {
        if (this.dimensions.x <= 0.0) {
            throw new NumberFormatException("X can not be negative");
        }
        if (this.dimensions.y <= 0.0) {
            throw new NumberFormatException("Y can not be negative");
        }
        if (this.dimensions.z <= 0.0) {
            throw new NumberFormatException("Z can not be negative");
        }
        int[][][] a = new int[][][]{new int[][]{{0, 4, 6, 2}, {-1, 0, 0}}, new int[][]{{1, 3, 7, 5}, {1, 0, 0}}, new int[][]{{0, 1, 5, 4}, {0, -1, 0}}, new int[][]{{2, 6, 7, 3}, {0, 1, 0}}, new int[][]{{0, 2, 3, 1}, {0, 0, -1}}, new int[][]{{4, 5, 7, 6}, {0, 0, 1}}};
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int[][] info : a) {
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            for (int i : info[0]) {
                Vector3d pos = new Vector3d(this.center.x + this.dimensions.x * ((double)(1 * Math.min(1, i & 1)) - 0.5), this.center.y + this.dimensions.y * ((double)(1 * Math.min(1, i & 2)) - 0.5), this.center.z + this.dimensions.z * ((double)(1 * Math.min(1, i & 4)) - 0.5));
                vertices.add(new Vertex(pos, new Vector3d(info[1][0], info[1][1], info[1][2])));
            }
            polygons.add(new Polygon(vertices, this.properties));
        }
        if (!this.centered) {
            Transform centerTransform = Transform.unity().translate(this.dimensions.x / 2.0, this.dimensions.y / 2.0, this.dimensions.z / 2.0);
            for (Polygon p : polygons) {
                p.transform(centerTransform);
            }
        }
        return polygons;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public Cube setCenter(Vector3d center) {
        this.center = center;
        return this;
    }

    public Vector3d getDimensions() {
        return this.dimensions;
    }

    public Cube setDimensions(Vector3d dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }

    public Cube noCenter() {
        this.centered = false;
        return this;
    }
}

