/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Extrude;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class TextExtrude {
    private static final String default_font = "FreeSerif";
    private static final int POINTS_CURVE = 10;
    private final String text;
    private List<Vector3d> points;
    private Vector3d p0;
    private final List<LineSegment> polis = new ArrayList<LineSegment>();
    ArrayList<CSG> sections = new ArrayList();
    ArrayList<CSG> holes = new ArrayList();
    private double dir;

    private TextExtrude(String text, Font font, double dir) {
        if (dir <= 0.0) {
            throw new NumberFormatException("length can not be negative");
        }
        this.dir = dir;
        this.points = new ArrayList<Vector3d>();
        this.text = text;
        Text textNode = new Text(text);
        textNode.setFont(font);
        Path subtract = (Path)Shape.subtract((Shape)textNode, (Shape)new Rectangle(0.0, 0.0));
        subtract.getElements().forEach(this::getPoints);
        for (int i = 0; i < this.sections.size(); ++i) {
            for (CSG h : this.holes) {
                try {
                    if (!this.sections.get(i).touching(h)) continue;
                    CSG nl = this.sections.get(i).difference(h);
                    this.sections.set(i, nl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ArrayList<CSG> text(double dir, String text, Font font) {
        TextExtrude te = new TextExtrude(text, font, dir);
        return te.sections;
    }

    public List<LineSegment> getLineSegment() {
        return this.polis;
    }

    public List<Vector3d> getOffset() {
        return this.polis.stream().sorted((p1, p2) -> (int)(p1.getOrigen().x - p2.getOrigen().x)).map(LineSegment::getOrigen).collect(Collectors.toList());
    }

    private void getPoints(PathElement elem) {
        if (elem instanceof MoveTo) {
            this.loadPoints();
            this.p0 = new Vector3d((float)((MoveTo)elem).getX(), (float)((MoveTo)elem).getY(), 0.0);
            this.points.add(this.p0);
        } else if (elem instanceof LineTo) {
            this.points.add(new Vector3d((float)((LineTo)elem).getX(), (float)((LineTo)elem).getY(), 0.0));
        } else if (elem instanceof CubicCurveTo) {
            Vector3d ini = this.points.size() > 0 ? this.points.get(this.points.size() - 1) : this.p0;
            IntStream.rangeClosed(1, 10).forEach(i -> this.points.add(this.evalCubicBezier((CubicCurveTo)elem, ini, (double)i / 10.0)));
        } else if (elem instanceof QuadCurveTo) {
            Vector3d ini = this.points.size() > 0 ? this.points.get(this.points.size() - 1) : this.p0;
            IntStream.rangeClosed(1, 10).forEach(i -> this.points.add(this.evalQuadBezier((QuadCurveTo)elem, ini, (double)i / 10.0)));
        } else if (elem instanceof ClosePath) {
            this.points.add(this.p0);
            if (Math.abs(this.getArea()) > 0.001) {
                LineSegment line = new LineSegment(this.text);
                line.setHole(this.isHole());
                line.setPoints(this.points);
                line.setPath(this.generatePath());
                line.setOrigen(this.p0);
                this.polis.add(line);
            }
            this.loadPoints();
        }
    }

    private void loadPoints() {
        if (this.points.size() > 4) {
            this.points.remove(this.points.size() - 1);
            boolean hole = Extrude.isCCW(Polygon.fromPoints(this.points));
            CSG newLetter = Extrude.points(new Vector3d(0.0, 0.0, this.dir), this.points);
            if (!hole) {
                this.sections.add(newLetter);
            } else {
                this.holes.add(newLetter);
            }
        }
        this.points = new ArrayList<Vector3d>();
    }

    private Vector3d evalCubicBezier(CubicCurveTo c, Vector3d ini, double t) {
        Vector3d p = new Vector3d((float)(Math.pow(1.0 - t, 3.0) * ini.x + 3.0 * t * Math.pow(1.0 - t, 2.0) * c.getControlX1() + 3.0 * (1.0 - t) * t * t * c.getControlX2() + Math.pow(t, 3.0) * c.getX()), (float)(Math.pow(1.0 - t, 3.0) * ini.y + 3.0 * t * Math.pow(1.0 - t, 2.0) * c.getControlY1() + 3.0 * (1.0 - t) * t * t * c.getControlY2() + Math.pow(t, 3.0) * c.getY()), 0.0);
        return p;
    }

    private Vector3d evalQuadBezier(QuadCurveTo c, Vector3d ini, double t) {
        Vector3d p = new Vector3d((float)(Math.pow(1.0 - t, 2.0) * ini.x + 2.0 * (1.0 - t) * t * c.getControlX() + Math.pow(t, 2.0) * c.getX()), (float)(Math.pow(1.0 - t, 2.0) * ini.y + 2.0 * (1.0 - t) * t * c.getControlY() + Math.pow(t, 2.0) * c.getY()), 0.0);
        return p;
    }

    private double getArea() {
        SimpleDoubleProperty res = new SimpleDoubleProperty();
        IntStream.range(0, this.points.size() - 1).forEach(arg_0 -> this.lambda$getArea$3((DoubleProperty)res, arg_0));
        return res.doubleValue() / 2.0;
    }

    private boolean isHole() {
        return this.getArea() > 0.0;
    }

    private Path generatePath() {
        Path path = new Path(new PathElement[]{new MoveTo(this.points.get((int)0).x, this.points.get((int)0).y)});
        this.points.stream().skip(1L).forEach(p -> path.getElements().add((Object)new LineTo(p.x, p.y)));
        path.getElements().add((Object)new ClosePath());
        path.setStroke((Paint)Color.GREEN);
        path.setFill((Paint)Color.RED);
        return path;
    }

    private /* synthetic */ void lambda$getArea$3(DoubleProperty res, int i) {
        res.set(res.get() + this.points.get((int)i).cross((Vector3d)this.points.get((int)(i + 1))).z);
    }

    class LineSegment {
        private boolean hole;
        private List<Vector3d> points;
        private Path path;
        private Vector3d origen;
        private List<LineSegment> holes = new ArrayList<LineSegment>();
        private String letter;

        public LineSegment(String text) {
            this.letter = text;
        }

        public String getLetter() {
            return this.letter;
        }

        public void setLetter(String letter) {
            this.letter = letter;
        }

        public boolean isHole() {
            return this.hole;
        }

        public void setHole(boolean isHole) {
            this.hole = isHole;
        }

        public List<Vector3d> getPoints() {
            return this.points;
        }

        public void setPoints(List<Vector3d> points) {
            this.points = points;
        }

        public Path getPath() {
            return this.path;
        }

        public void setPath(Path path) {
            this.path = path;
        }

        public Vector3d getOrigen() {
            return this.origen;
        }

        public void setOrigen(Vector3d origen) {
            this.origen = origen;
        }

        public List<LineSegment> getHoles() {
            return this.holes;
        }

        public void setHoles(List<LineSegment> holes) {
            this.holes = holes;
        }

        public void addHole(LineSegment hole) {
            this.holes.add(hole);
        }

        public String toString() {
            return "Poly{points=" + this.points + ", path=" + this.path + ", origen=" + (Object)((Object)this.origen) + ", holes=" + this.holes + '}';
        }
    }
}

