/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.quickhull3d;

import eu.mihosoft.vrl.v3d.ext.quickhull3d.Face;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.Vertex;

class HalfEdge {
    Vertex vertex;
    Face face;
    HalfEdge next;
    HalfEdge prev;
    HalfEdge opposite;

    public HalfEdge(Vertex v, Face f) {
        this.vertex = v;
        this.face = f;
    }

    public HalfEdge() {
    }

    public void setNext(HalfEdge edge) {
        this.next = edge;
    }

    public HalfEdge getNext() {
        return this.next;
    }

    public void setPrev(HalfEdge edge) {
        this.prev = edge;
    }

    public HalfEdge getPrev() {
        return this.prev;
    }

    public Face getFace() {
        return this.face;
    }

    public HalfEdge getOpposite() {
        return this.opposite;
    }

    public void setOpposite(HalfEdge edge) {
        this.opposite = edge;
        edge.opposite = this;
    }

    public Vertex head() {
        return this.vertex;
    }

    public Vertex tail() {
        return this.prev != null ? this.prev.vertex : null;
    }

    public Face oppositeFace() {
        return this.opposite != null ? this.opposite.face : null;
    }

    public String getVertexString() {
        if (this.tail() != null) {
            return "" + this.tail().index + "-" + this.head().index;
        }
        return "?-" + this.head().index;
    }

    public double length() {
        if (this.tail() != null) {
            return this.head().pnt.distance(this.tail().pnt);
        }
        return -1.0;
    }

    public double lengthSquared() {
        if (this.tail() != null) {
            return this.head().pnt.distanceSquared(this.tail().pnt);
        }
        return -1.0;
    }
}

