/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj;

import eu.mihosoft.vrl.v3d.ext.openjfx.importers.SmoothingGroups;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.FloatArrayList;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.IntegerArrayList;
import eu.mihosoft.vrl.v3d.ext.openjfx.importers.obj.MtlReader;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.PolygonMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.PolygonMeshView;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;

public class PolyObjImporter {
    private static boolean debug = false;
    private static float scale = 1.0f;
    private static boolean flatXZ = false;
    private Map<String, PolygonMesh> meshes = new HashMap<String, PolygonMesh>();
    private Map<String, Material> materials = new HashMap<String, Material>();
    private List<Map<String, Material>> materialLibrary = new ArrayList<Map<String, Material>>();
    private String objFilename;
    private FloatArrayList vertexes = new FloatArrayList();
    private FloatArrayList uvs = new FloatArrayList();
    private List<int[]> faces = new ArrayList<int[]>();
    private IntegerArrayList smoothingGroups = new IntegerArrayList();
    private FloatArrayList normals = new FloatArrayList();
    private List<int[]> faceNormals = new ArrayList<int[]>();
    private Material material = new PhongMaterial(Color.WHITE);
    private int facesStart = 0;
    private int facesNormalStart = 0;
    private int smoothingGroupsStart = 0;

    private int vertexIndex(int vertexIndex) {
        if (vertexIndex < 0) {
            return vertexIndex + this.vertexes.size() / 3;
        }
        return vertexIndex - 1;
    }

    private int uvIndex(int uvIndex) {
        if (uvIndex < 0) {
            return uvIndex + this.uvs.size() / 2;
        }
        return uvIndex - 1;
    }

    private int normalIndex(int normalIndex) {
        if (normalIndex < 0) {
            return normalIndex + this.normals.size() / 3;
        }
        return normalIndex - 1;
    }

    static void log(String string) {
        if (debug) {
            // empty if block
        }
    }

    public Set<String> getMeshes() {
        return this.meshes.keySet();
    }

    public PolyObjImporter(String filename) throws FileNotFoundException, IOException {
        this.objFilename = filename;
        PolyObjImporter.log("Reading filename = " + filename);
        this.read(new URL(filename).openStream());
    }

    public PolyObjImporter(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public PolygonMesh getMesh() {
        return this.meshes.values().iterator().next();
    }

    public Material getMaterial() {
        return this.materials.values().iterator().next();
    }

    public PolygonMesh getMesh(String key) {
        return this.meshes.get(key);
    }

    public Material getMaterial(String key) {
        return this.materials.get(key);
    }

    public PolygonMeshView buildPolygonMeshView(String key) {
        PolygonMeshView polygonMeshView = new PolygonMeshView();
        polygonMeshView.setId(key);
        polygonMeshView.setMaterial(this.materials.get(key));
        polygonMeshView.setMesh(this.meshes.get(key));
        return polygonMeshView;
    }

    public static void setDebug(boolean debug) {
        PolyObjImporter.debug = debug;
    }

    public static void setScale(float scale) {
        PolyObjImporter.scale = scale;
    }

    private void read(InputStream inputStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        int currentSmoothGroup = 0;
        String key = "default";
        block2: while ((line = br.readLine()) != null) {
            try {
                float z;
                String[] split;
                if (line.startsWith("g ") || line.equals("g")) {
                    this.addMesh(key);
                    key = line.length() > 2 ? line.substring(2) : "default";
                    PolyObjImporter.log("key = " + key);
                    continue;
                }
                if (line.startsWith("v ")) {
                    split = line.substring(2).trim().split(" +");
                    float x = Float.parseFloat(split[0]) * scale;
                    float y = Float.parseFloat(split[1]) * scale;
                    z = Float.parseFloat(split[2]) * scale;
                    this.vertexes.add(Float.valueOf(x));
                    this.vertexes.add(Float.valueOf(y));
                    this.vertexes.add(Float.valueOf(z));
                    if (!flatXZ) continue;
                    this.uvs.add(Float.valueOf(x));
                    this.uvs.add(Float.valueOf(z));
                    continue;
                }
                if (line.startsWith("vt ")) {
                    split = line.substring(3).trim().split(" +");
                    float u = split[0].trim().equalsIgnoreCase("nan") ? Float.NaN : Float.parseFloat(split[0]);
                    float v = split[1].trim().equalsIgnoreCase("nan") ? Float.NaN : Float.parseFloat(split[1]);
                    this.uvs.add(Float.valueOf(u));
                    this.uvs.add(Float.valueOf(1.0f - v));
                    continue;
                }
                if (line.startsWith("f ")) {
                    split = line.substring(2).trim().split(" +");
                    int[] faceIndexes = new int[split.length * 2];
                    int[] faceNormalIndexes = new int[split.length];
                    for (int i = 0; i < split.length; ++i) {
                        String[] split2 = split[i].split("/");
                        faceIndexes[i * 2] = this.vertexIndex(Integer.parseInt(split2[0]));
                        faceIndexes[i * 2 + 1] = split2.length > 1 && split2[1].length() > 0 ? this.uvIndex(Integer.parseInt(split2[1])) : -1;
                        faceNormalIndexes[i] = split2.length > 2 && split2[2].length() > 0 ? this.normalIndex(Integer.parseInt(split2[2])) : -1;
                    }
                    this.faces.add(faceIndexes);
                    this.faceNormals.add(faceNormalIndexes);
                    this.smoothingGroups.add(currentSmoothGroup);
                    continue;
                }
                if (line.startsWith("s ")) {
                    if (line.substring(2).equals("off")) {
                        currentSmoothGroup = 0;
                        continue;
                    }
                    currentSmoothGroup = Integer.parseInt(line.substring(2));
                    continue;
                }
                if (line.startsWith("mtllib ")) {
                    for (String filename : split = line.substring("mtllib ".length()).trim().split(" +")) {
                        MtlReader mtlReader = new MtlReader(filename, this.objFilename);
                        this.materialLibrary.add(mtlReader.getMaterials());
                    }
                    continue;
                }
                if (line.startsWith("usemtl ")) {
                    this.addMesh(key);
                    String materialName = line.substring("usemtl ".length());
                    for (Map<String, Material> mm : this.materialLibrary) {
                        Material m = mm.get(materialName);
                        if (m == null) continue;
                        this.material = m;
                        continue block2;
                    }
                    continue;
                }
                if (line.isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("vn ")) {
                    split = line.substring(2).trim().split(" +");
                    float x = Float.parseFloat(split[0]);
                    float y = Float.parseFloat(split[1]);
                    z = Float.parseFloat(split[2]);
                    this.normals.add(Float.valueOf(x));
                    this.normals.add(Float.valueOf(y));
                    this.normals.add(Float.valueOf(z));
                    continue;
                }
                PolyObjImporter.log("line skipped: " + line);
            }
            catch (Exception ex) {
                Logger.getLogger(MtlReader.class.getName()).log(Level.SEVERE, "Failed to parse line:" + line, ex);
            }
        }
        this.addMesh(key);
        PolyObjImporter.log("Totally loaded " + (double)this.vertexes.size() / 3.0 + " vertexes, " + (double)this.uvs.size() / 2.0 + " uvs, " + (double)this.faces.size() / 6.0 + " faces, " + this.smoothingGroups.size() + " smoothing groups.");
    }

    /*
     * WARNING - void declaration
     */
    private void addMesh(String key) {
        if (this.facesStart >= this.faces.size()) {
            this.smoothingGroupsStart = this.smoothingGroups.size();
            return;
        }
        HashMap<Integer, Integer> vertexMap = new HashMap<Integer, Integer>(this.vertexes.size() / 2);
        HashMap<Integer, Integer> uvMap = new HashMap<Integer, Integer>(this.uvs.size() / 2);
        HashMap<Integer, Integer> normalMap = new HashMap<Integer, Integer>(this.normals.size() / 2);
        FloatArrayList newVertexes = new FloatArrayList(this.vertexes.size() / 2);
        FloatArrayList newUVs = new FloatArrayList(this.uvs.size() / 2);
        FloatArrayList newNormals = new FloatArrayList(this.normals.size() / 2);
        boolean useNormals = true;
        int[][] faceArrays = new int[this.faces.size() - this.facesStart][];
        int[][] faceNormalArrays = new int[this.faceNormals.size() - this.facesNormalStart][];
        for (int i = this.facesStart; i < this.faces.size(); ++i) {
            int[] nArray = this.faces.get(i);
            int[] faceNormalIndexes = this.faceNormals.get(i);
            for (int j = 0; j < nArray.length; j += 2) {
                int vi = nArray[j];
                Integer nvi = (Integer)vertexMap.get(vi);
                if (nvi == null) {
                    nvi = newVertexes.size() / 3;
                    vertexMap.put(vi, nvi);
                    newVertexes.add(this.vertexes.get(vi * 3));
                    newVertexes.add(this.vertexes.get(vi * 3 + 1));
                    newVertexes.add(this.vertexes.get(vi * 3 + 2));
                }
                nArray[j] = nvi;
                int uvi = nArray[j + 1];
                Integer nuvi = (Integer)uvMap.get(uvi);
                if (nuvi == null) {
                    nuvi = newUVs.size() / 2;
                    uvMap.put(uvi, nuvi);
                    if (uvi >= 0) {
                        newUVs.add(this.uvs.get(uvi * 2));
                        newUVs.add(this.uvs.get(uvi * 2 + 1));
                    } else {
                        newUVs.add(Float.valueOf(0.0f));
                        newUVs.add(Float.valueOf(0.0f));
                    }
                }
                nArray[j + 1] = nuvi;
                int ni = faceNormalIndexes[j / 2];
                Integer nni = (Integer)normalMap.get(ni);
                if (nni == null) {
                    nni = newNormals.size() / 3;
                    normalMap.put(ni, nni);
                    if (ni >= 0 && this.normals.size() >= (ni + 1) * 3) {
                        newNormals.add(this.normals.get(ni * 3));
                        newNormals.add(this.normals.get(ni * 3 + 1));
                        newNormals.add(this.normals.get(ni * 3 + 2));
                    } else {
                        useNormals = false;
                        newNormals.add(Float.valueOf(0.0f));
                        newNormals.add(Float.valueOf(0.0f));
                        newNormals.add(Float.valueOf(0.0f));
                    }
                }
                faceNormalIndexes[j / 2] = nni;
            }
            faceArrays[i - this.facesStart] = nArray;
            faceNormalArrays[i - this.facesNormalStart] = faceNormalIndexes;
        }
        PolygonMesh mesh = new PolygonMesh(newVertexes.toFloatArray(), newUVs.toFloatArray(), faceArrays);
        if (useNormals) {
            int[] nArray = SmoothingGroups.calcSmoothGroups(faceArrays, faceNormalArrays, newNormals.toFloatArray());
            mesh.getFaceSmoothingGroups().setAll(nArray);
        } else {
            mesh.getFaceSmoothingGroups().setAll(((IntegerArrayList)this.smoothingGroups.subList(this.smoothingGroupsStart, this.smoothingGroups.size())).toIntArray());
        }
        if (debug) {
            for (int[] nArray : mesh.faces) {
            }
        }
        int n = 2;
        String keyBase = key;
        while (this.meshes.get(key) != null) {
            void var12_19;
            key = keyBase + " (" + (int)(++var12_19) + ")";
        }
        this.meshes.put(key, mesh);
        this.materials.put(key, this.material);
        PolyObjImporter.log("Added mesh '" + key + "' of " + mesh.getPoints().size() / 3 + " vertexes, " + mesh.getTexCoords().size() / 2 + " uvs, " + mesh.faces.length + " faces, " + 0 + " smoothing groups.");
        PolyObjImporter.log("material diffuse color = " + ((PhongMaterial)this.material).getDiffuseColor());
        PolyObjImporter.log("material diffuse map = " + ((PhongMaterial)this.material).getDiffuseMap());
        this.facesStart = this.faces.size();
        this.facesNormalStart = this.faceNormals.size();
        this.smoothingGroupsStart = this.smoothingGroups.size();
    }

    public static void setFlatXZ(boolean flatXZ) {
        PolyObjImporter.flatXZ = flatXZ;
    }
}

