/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic;

import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.SubdivisionMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.OriginalPointArray;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SubdividedPointArray;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SymbolicPolygonMesh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Point2D;

public class SymbolicSubdivisionBuilder {
    private SymbolicPolygonMesh oldMesh;
    private Map<Edge, EdgeInfo> edgeInfos;
    private FaceInfo[] faceInfos;
    private PointInfo[] pointInfos;
    private SubdividedPointArray points;
    private float[] texCoords;
    private int[] reindex;
    private int newTexCoordIndex;
    private SubdivisionMesh.BoundaryMode boundaryMode;
    private SubdivisionMesh.MapBorderMode mapBorderMode;

    public SymbolicSubdivisionBuilder(SymbolicPolygonMesh oldMesh, SubdivisionMesh.BoundaryMode boundaryMode, SubdivisionMesh.MapBorderMode mapBorderMode) {
        this.oldMesh = oldMesh;
        this.boundaryMode = boundaryMode;
        this.mapBorderMode = mapBorderMode;
    }

    public SymbolicPolygonMesh subdivide() {
        int p;
        int[] oldFaces;
        FaceInfo faceInfo;
        int f;
        this.collectInfo();
        this.texCoords = new float[(this.oldMesh.getNumEdgesInFaces() * 3 + this.oldMesh.faces.length) * 2];
        int[][] faces = new int[this.oldMesh.getNumEdgesInFaces()][8];
        int[] faceSmoothingGroups = new int[this.oldMesh.getNumEdgesInFaces()];
        this.newTexCoordIndex = 0;
        this.reindex = new int[this.oldMesh.points.numPoints];
        int newFacesInd = 0;
        for (f = 0; f < this.oldMesh.faces.length; ++f) {
            faceInfo = this.faceInfos[f];
            oldFaces = this.oldMesh.faces[f];
            for (p = 0; p < oldFaces.length; p += 2) {
                faces[newFacesInd][4] = this.getPointNewIndex(faceInfo);
                faces[newFacesInd][5] = this.getTexCoordNewIndex(faceInfo);
                faceSmoothingGroups[newFacesInd] = this.oldMesh.faceSmoothingGroups[f];
                ++newFacesInd;
            }
        }
        newFacesInd = 0;
        for (f = 0; f < this.oldMesh.faces.length; ++f) {
            faceInfo = this.faceInfos[f];
            oldFaces = this.oldMesh.faces[f];
            for (p = 0; p < oldFaces.length; p += 2) {
                faces[newFacesInd][2] = this.getPointNewIndex(faceInfo, (p / 2 + 1) % faceInfo.edges.length);
                faces[newFacesInd][3] = this.getTexCoordNewIndex(faceInfo, (p / 2 + 1) % faceInfo.edges.length);
                faces[newFacesInd][6] = this.getPointNewIndex(faceInfo, p / 2);
                faces[newFacesInd][7] = this.getTexCoordNewIndex(faceInfo, p / 2);
                ++newFacesInd;
            }
        }
        newFacesInd = 0;
        for (f = 0; f < this.oldMesh.faces.length; ++f) {
            faceInfo = this.faceInfos[f];
            oldFaces = this.oldMesh.faces[f];
            for (p = 0; p < oldFaces.length; p += 2) {
                faces[newFacesInd][0] = this.getPointNewIndex(oldFaces[p]);
                faces[newFacesInd][1] = this.getTexCoordNewIndex(faceInfo, oldFaces[p], oldFaces[p + 1]);
                ++newFacesInd;
            }
        }
        SymbolicPolygonMesh newMesh = new SymbolicPolygonMesh(this.points, this.texCoords, faces, faceSmoothingGroups);
        return newMesh;
    }

    public static SymbolicPolygonMesh subdivide(SymbolicPolygonMesh oldMesh, SubdivisionMesh.BoundaryMode boundaryMode, SubdivisionMesh.MapBorderMode mapBorderMode) {
        SymbolicSubdivisionBuilder subdivision = new SymbolicSubdivisionBuilder(oldMesh, boundaryMode, mapBorderMode);
        return subdivision.subdivide();
    }

    private void addEdge(Edge edge, FaceInfo faceInfo) {
        EdgeInfo edgeInfo = this.edgeInfos.get(edge);
        if (edgeInfo == null) {
            edgeInfo = new EdgeInfo();
            edgeInfo.edge = edge;
            this.edgeInfos.put(edge, edgeInfo);
        }
        edgeInfo.faces.add(faceInfo);
    }

    private void addPoint(int point, FaceInfo faceInfo, Edge edge) {
        PointInfo pointInfo = this.pointInfos[point];
        if (pointInfo == null) {
            this.pointInfos[point] = pointInfo = new PointInfo();
        }
        pointInfo.edges.add(edge);
        pointInfo.faces.add(faceInfo);
    }

    private void addPoint(int point, Edge edge) {
        PointInfo pointInfo = this.pointInfos[point];
        if (pointInfo == null) {
            this.pointInfos[point] = pointInfo = new PointInfo();
        }
        pointInfo.edges.add(edge);
    }

    private void collectInfo() {
        int n;
        int[] face;
        int f;
        this.edgeInfos = new HashMap<Edge, EdgeInfo>(this.oldMesh.faces.length * 2);
        this.faceInfos = new FaceInfo[this.oldMesh.faces.length];
        this.pointInfos = new PointInfo[this.oldMesh.points.numPoints];
        for (f = 0; f < this.oldMesh.faces.length; ++f) {
            FaceInfo faceInfo;
            face = this.oldMesh.faces[f];
            n = face.length / 2;
            this.faceInfos[f] = faceInfo = new FaceInfo(n);
            if (n < 3) continue;
            int from = face[(n - 1) * 2];
            int texFrom = face[(n - 1) * 2 + 1];
            double u = 0.0;
            double v = 0.0;
            double fu = this.oldMesh.texCoords[texFrom * 2];
            double fv = this.oldMesh.texCoords[texFrom * 2 + 1];
            for (int i = 0; i < n; ++i) {
                Edge edge;
                int to = face[i * 2];
                int texTo = face[i * 2 + 1];
                double tu = this.oldMesh.texCoords[texTo * 2];
                double tv = this.oldMesh.texCoords[texTo * 2 + 1];
                Point2D midTexCoord = new Point2D((fu + tu) / 2.0, (fv + tv) / 2.0);
                faceInfo.edges[i] = edge = new Edge(from, to);
                faceInfo.edgeTexCoords[i] = midTexCoord;
                this.addEdge(edge, faceInfo);
                this.addPoint(to, faceInfo, edge);
                this.addPoint(from, edge);
                fu = tu;
                fv = tv;
                u += tu / (double)n;
                v += tv / (double)n;
                from = to;
                texFrom = texTo;
            }
            faceInfo.texCoord = new Point2D(u, v);
        }
        this.points = new SubdividedPointArray(this.oldMesh.points, this.oldMesh.points.numPoints + this.faceInfos.length + this.edgeInfos.size(), this.boundaryMode);
        for (f = 0; f < this.oldMesh.faces.length; ++f) {
            face = this.oldMesh.faces[f];
            n = face.length / 2;
            int[] faceVertices = new int[n];
            for (int i = 0; i < n; ++i) {
                faceVertices[i] = face[i * 2];
            }
            this.faceInfos[f].facePoint = this.points.addFacePoint(faceVertices);
        }
        for (EdgeInfo edgeInfo : this.edgeInfos.values()) {
            int[] edgeFacePoints = new int[edgeInfo.faces.size()];
            for (int f2 = 0; f2 < edgeInfo.faces.size(); ++f2) {
                edgeFacePoints[f2] = edgeInfo.faces.get((int)f2).facePoint;
            }
            edgeInfo.edgePoint = this.points.addEdgePoint(edgeFacePoints, edgeInfo.edge.from, edgeInfo.edge.to, edgeInfo.isBoundary());
        }
    }

    private int calcControlPoint(int srcPointIndex) {
        PointInfo pointInfo = this.pointInfos[srcPointIndex];
        int origPoint = srcPointIndex;
        int[] facePoints = new int[pointInfo.faces.size()];
        for (int f = 0; f < facePoints.length; ++f) {
            facePoints[f] = pointInfo.faces.get((int)f).facePoint;
        }
        int[] edgePoints = new int[pointInfo.edges.size()];
        boolean[] isEdgeBoundary = new boolean[pointInfo.edges.size()];
        int[] fromEdgePoints = new int[pointInfo.edges.size()];
        int[] toEdgePoints = new int[pointInfo.edges.size()];
        int i = 0;
        for (Edge edge : pointInfo.edges) {
            EdgeInfo edgeInfo = this.edgeInfos.get(edge);
            edgePoints[i] = edgeInfo.edgePoint;
            isEdgeBoundary[i] = edgeInfo.isBoundary();
            fromEdgePoints[i] = edgeInfo.edge.from;
            toEdgePoints[i] = edgeInfo.edge.to;
            ++i;
        }
        int destPointIndex = this.points.addControlPoint(facePoints, edgePoints, fromEdgePoints, toEdgePoints, isEdgeBoundary, origPoint, pointInfo.isBoundary(), pointInfo.hasInternalEdge());
        return destPointIndex;
    }

    private void calcControlTexCoord(FaceInfo faceInfo, int srcPointIndex, int srcTexCoordIndex, int destTexCoordIndex) {
        PointInfo pointInfo = this.pointInfos[srcPointIndex];
        boolean pointBelongsToCrease = this.oldMesh.points instanceof OriginalPointArray;
        if (this.mapBorderMode == SubdivisionMesh.MapBorderMode.SMOOTH_ALL && (pointInfo.isBoundary() || pointBelongsToCrease) || this.mapBorderMode == SubdivisionMesh.MapBorderMode.SMOOTH_INTERNAL && !pointInfo.hasInternalEdge()) {
            double u = this.oldMesh.texCoords[srcTexCoordIndex * 2] / 2.0f;
            double v = this.oldMesh.texCoords[srcTexCoordIndex * 2 + 1] / 2.0f;
            for (int i = 0; i < faceInfo.edges.length; ++i) {
                if (faceInfo.edges[i].to != srcPointIndex && faceInfo.edges[i].from != srcPointIndex) continue;
                u += faceInfo.edgeTexCoords[i].getX() / 4.0;
                v += faceInfo.edgeTexCoords[i].getY() / 4.0;
            }
            this.texCoords[destTexCoordIndex * 2] = (float)u;
            this.texCoords[destTexCoordIndex * 2 + 1] = (float)v;
        } else {
            this.texCoords[destTexCoordIndex * 2] = this.oldMesh.texCoords[srcTexCoordIndex * 2];
            this.texCoords[destTexCoordIndex * 2 + 1] = this.oldMesh.texCoords[srcTexCoordIndex * 2 + 1];
        }
    }

    private int getPointNewIndex(int srcPointIndex) {
        int destPointIndex = this.reindex[srcPointIndex] - 1;
        if (destPointIndex == -1) {
            destPointIndex = this.calcControlPoint(srcPointIndex);
            this.reindex[srcPointIndex] = destPointIndex + 1;
        }
        return destPointIndex;
    }

    private int getPointNewIndex(FaceInfo faceInfo, int edgeInd) {
        Edge edge = faceInfo.edges[edgeInd];
        EdgeInfo edgeInfo = this.edgeInfos.get(edge);
        return edgeInfo.edgePoint;
    }

    private int getPointNewIndex(FaceInfo faceInfo) {
        return faceInfo.facePoint;
    }

    private int getTexCoordNewIndex(FaceInfo faceInfo, int srcPointIndex, int srcTexCoordIndex) {
        int destTexCoordIndex = this.newTexCoordIndex++;
        this.calcControlTexCoord(faceInfo, srcPointIndex, srcTexCoordIndex, destTexCoordIndex);
        return destTexCoordIndex;
    }

    private int getTexCoordNewIndex(FaceInfo faceInfo, int edgeInd) {
        int destTexCoordIndex = this.newTexCoordIndex++;
        this.texCoords[destTexCoordIndex * 2] = (float)faceInfo.edgeTexCoords[edgeInd].getX();
        this.texCoords[destTexCoordIndex * 2 + 1] = (float)faceInfo.edgeTexCoords[edgeInd].getY();
        return destTexCoordIndex;
    }

    private int getTexCoordNewIndex(FaceInfo faceInfo) {
        int destTexCoordIndex = faceInfo.newTexCoordIndex - 1;
        if (destTexCoordIndex == -1) {
            destTexCoordIndex = this.newTexCoordIndex++;
            faceInfo.newTexCoordIndex = destTexCoordIndex + 1;
            this.texCoords[destTexCoordIndex * 2] = (float)faceInfo.texCoord.getX();
            this.texCoords[destTexCoordIndex * 2 + 1] = (float)faceInfo.texCoord.getY();
        }
        return destTexCoordIndex;
    }

    private static class FaceInfo {
        int facePoint;
        Point2D texCoord;
        int newTexCoordIndex;
        Edge[] edges;
        Point2D[] edgeTexCoords;

        public FaceInfo(int n) {
            this.edges = new Edge[n];
            this.edgeTexCoords = new Point2D[n];
        }
    }

    private class PointInfo {
        List<FaceInfo> faces = new ArrayList<FaceInfo>(4);
        Set<Edge> edges = new HashSet<Edge>(4);

        private PointInfo() {
        }

        public boolean isBoundary() {
            for (Edge edge : this.edges) {
                EdgeInfo edgeInfo = (EdgeInfo)SymbolicSubdivisionBuilder.this.edgeInfos.get(edge);
                if (!edgeInfo.isBoundary()) continue;
                return true;
            }
            return false;
        }

        public boolean hasInternalEdge() {
            for (Edge edge : this.edges) {
                EdgeInfo edgeInfo = (EdgeInfo)SymbolicSubdivisionBuilder.this.edgeInfos.get(edge);
                if (edgeInfo.isBoundary()) continue;
                return true;
            }
            return false;
        }
    }

    private static class EdgeInfo {
        Edge edge;
        int edgePoint;
        List<FaceInfo> faces = new ArrayList<FaceInfo>(2);

        private EdgeInfo() {
        }

        public boolean isBoundary() {
            return this.faces.size() == 1;
        }
    }

    private static class Edge {
        int from;
        int to;

        public Edge(int from, int to) {
            this.from = Math.min(from, to);
            this.to = Math.max(from, to);
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.from;
            hash = 41 * hash + this.to;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.from != other.from) {
                return false;
            }
            return this.to == other.to;
        }
    }
}

