/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.CSGClient;
import eu.mihosoft.vrl.v3d.CSGRequest;
import eu.mihosoft.vrl.v3d.CSGResponse;
import eu.mihosoft.vrl.v3d.ServerActionState;
import eu.mihosoft.vrl.v3d.ext.quickhull3d.HullUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocket;

class CSGServerHandler
implements Runnable {
    private SSLSocket clientSocket;
    private String[] APIKEY = null;

    public CSGServerHandler(SSLSocket socket, String[] lines) {
        this.clientSocket = socket;
        this.APIKEY = lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (ObjectInputStream ois = new ObjectInputStream(this.clientSocket.getInputStream());
             ObjectOutputStream oos = new ObjectOutputStream(this.clientSocket.getOutputStream());){
            System.out.println("Client connected: " + this.clientSocket.getRemoteSocketAddress());
            CSGRequest request = (CSGRequest)ois.readObject();
            System.out.println("Received request: " + (Object)((Object)request.getOperation()));
            boolean APIPass = true;
            String apiKey2 = request.getAPIKey();
            if (this.getAPIKEYs() != null) {
                APIPass = false;
                if (apiKey2 != null) {
                    for (int i = 0; i < this.getAPIKEYs().length; ++i) {
                        if (!apiKey2.contentEquals(this.getAPIKEYs()[i])) continue;
                        APIPass = true;
                        System.out.println("API Key Match");
                        break;
                    }
                }
            }
            CSGResponse response = null;
            if (APIPass) {
                try {
                    response = this.processCSGRequest(request);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    response = new CSGResponse();
                    response.setState(ServerActionState.ERROR);
                    response.setMessage(t);
                }
            } else {
                response = new CSGResponse();
                response.setState(ServerActionState.BADAPIKEY);
                response.setMessage("Your API key " + apiKey2 + " Does not match server's key");
            }
            oos.writeObject(response);
            oos.flush();
            System.out.println("Sent response: " + response);
        }
        catch (IOException | ClassNotFoundException e) {
            System.err.println("client disconnected: ");
        }
        finally {
            this.close();
        }
    }

    private void close() {
        System.out.println("Closing Handler socket");
        try {
            if (!this.clientSocket.isClosed()) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            System.err.println("Error closing client socket: " + e.getMessage());
        }
    }

    private CSGResponse processCSGRequest(CSGRequest request) {
        ArrayList<CSG> back = new ArrayList<CSG>();
        CSGClient.setServerCall(true);
        try {
            List<CSG> csgList = request.getCsgList();
            switch (request.getOperation()) {
                case DIFFERENCE: {
                    CSG first = csgList.remove(0);
                    if (csgList.size() == 1) {
                        back.add(first.difference(csgList.get(0)));
                        break;
                    }
                    back.add(first.difference(csgList));
                    break;
                }
                case INTERSECT: {
                    CSG f = csgList.remove(0);
                    back.add(f.intersect(csgList));
                    break;
                }
                case TRIANGULATE: {
                    CSG.setPreventNonManifoldTriangles(true);
                    for (CSG c : csgList) {
                        back.add(c.triangulate(true));
                    }
                    break;
                }
                case UNION: {
                    if (csgList.size() == 2) {
                        back.add(csgList.get(0).union(csgList.get(1)));
                        break;
                    }
                    back.add(CSG.unionAll(csgList));
                    break;
                }
                case minkowskiHullShape: {
                    CSG m1 = csgList.remove(0);
                    CSG t = csgList.remove(0);
                    back.addAll(m1.minkowskiHullShape(t));
                    break;
                }
                case hull: {
                    back.add(HullUtil.hull(request.getPoints(), request.getStorage()));
                    break;
                }
                default: {
                    throw new RuntimeException("No Such Operation " + (Object)((Object)request.getOperation()));
                }
            }
        }
        finally {
            CSGClient.setServerCall(false);
        }
        return new CSGResponse(back, request.getOperation());
    }

    public String[] getAPIKEYs() {
        return this.APIKEY;
    }

    public void setAPIKEYs(String[] aPIKEY) {
        this.APIKEY = aPIKEY;
    }
}

