/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.CSGRemoteOperation;
import eu.mihosoft.vrl.v3d.CSGRequest;
import eu.mihosoft.vrl.v3d.CSGResponse;
import eu.mihosoft.vrl.v3d.Cube;
import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.ServerActionState;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class CSGClient {
    private static CSGClient client = null;
    private String hostname;
    private int port;
    private String key = null;
    private static boolean serverCall = false;
    private SSLSocketFactory factory;

    public CSGClient(String hostname, int port, File f) throws Exception {
        this.hostname = hostname;
        this.port = port;
        if (f == null) {
            throw new NullPointerException("API key file can not be null");
        }
        if (f.exists()) {
            this.key = Files.readAllLines(f.toPath()).toArray(new String[0])[0];
        } else {
            System.err.println("Error! API key file does not exist! " + f.getAbsolutePath());
        }
        if (this.key == null || this.key.length() == 0) {
            System.err.println("Key error, no key provided by " + f.getAbsolutePath());
        } else {
            System.out.println("API Key Loaded from " + f.getAbsolutePath());
        }
        Socket socket = new Socket(hostname, port);
        socket.close();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        sslContext.init(null, trustAllCerts, new SecureRandom());
        this.factory = sslContext.getSocketFactory();
    }

    public ArrayList<CSG> union(List<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.UNION);
    }

    public ArrayList<CSG> hull(List<Vector3d> points, PropertyStorage storage) throws Exception {
        return this.performOperation(new ArrayList<CSG>(), CSGRemoteOperation.hull, points, storage);
    }

    public ArrayList<CSG> difference(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.DIFFERENCE);
    }

    public ArrayList<CSG> intersect(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.INTERSECT);
    }

    public ArrayList<CSG> minkowskiHullShape(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.minkowskiHullShape);
    }

    public ArrayList<CSG> triangulate(ArrayList<CSG> csgList) throws Exception {
        return this.performOperation(csgList, CSGRemoteOperation.TRIANGULATE);
    }

    private ArrayList<CSG> performOperation(List<CSG> csgList, CSGRemoteOperation operation) throws Exception {
        return this.performOperation(csgList, operation, null, null);
    }

    private ArrayList<CSG> performOperation(List<CSG> csgList, CSGRemoteOperation operation, List<Vector3d> points, PropertyStorage storage) throws Exception {
        if (Platform.isFxApplicationThread()) {
            RuntimeException runtimeException = new RuntimeException("Network trafic can not run on UI thread");
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        ArrayList<CSG> back = null;
        SSLSocket socket = (SSLSocket)this.factory.createSocket(this.hostname, this.port);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            ArrayList<CSG> toSend = new ArrayList<CSG>();
            for (CSG c : csgList) {
                CSG tmp = CSG.fromPolygons(new ArrayList<Polygon>(c.getPolygons()));
                tmp.setOptType(c.getOptType());
                toSend.add(tmp);
            }
            CSGRequest request = new CSGRequest(toSend, operation, points, storage);
            if (this.key != null) {
                request.setAPIKEY(this.key);
            }
            oos.writeObject(request);
            oos.flush();
            CSGResponse response = (CSGResponse)ois.readObject();
            socket.close();
            if (response.getState() != ServerActionState.SUCCESS) {
                throw new RuntimeException(response.getMessage());
            }
            back = new ArrayList<CSG>();
            for (CSG c : response.getCsgList()) {
                if (c.getPolygons().size() == 0) {
                    System.out.println("Running Operation on server: " + this.hostname + " " + (Object)((Object)operation));
                    new RuntimeException("Network CSG op resulted in no polygons here ").printStackTrace();
                }
                CSG historySync = CSG.fromPolygons(c.getPolygons());
                back.add(historySync);
                for (CSG s : csgList) {
                    historySync.historySync(s);
                }
            }
        }
        catch (Throwable t) {
            socket.close();
            throw t;
        }
        return back;
    }

    public String getServerInfo() {
        return this.hostname + ":" + this.port + " (connected: )";
    }

    public static boolean start(String hostname, int port, File f) throws Exception {
        if (CSGClient.getClient() != null) {
            return false;
        }
        CSGClient.setClient(new CSGClient(hostname, port, f));
        return true;
    }

    public static void close() {
        client = null;
    }

    public static boolean isRunning() {
        if (Platform.isFxApplicationThread()) {
            return false;
        }
        if (CSGClient.isServerCall()) {
            return false;
        }
        return CSGClient.getClient() != null;
    }

    public static void main(String[] args) {
        String hostname = "localhost";
        int port = 3742;
        try {
            File f = new File("/opt/File.txt");
            CSGClient.start(hostname, port, f);
            CSG.setMinPolygonsForOffloading(4);
            System.out.println("Client info: " + CSGClient.getClient().getServerInfo());
            CSG a = new Cube(20.0).toCSG();
            CSG b = new Cube(20.0, 30.0, 5.0).toCSG();
            CSG c = new Cube(10.0, 10.0, 10.0).toCSG();
            CSG u = CSG.unionAll(a, b, c);
            CSG d = a.difference(b);
            CSG t = d.triangulate(true);
            ArrayList<CSG> m = a.minkowskiHullShape(b);
            CSGClient.close();
        }
        catch (Exception e) {
            System.err.println("Communication error: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("\nClient example completed.");
    }

    public static CSGClient getClient() {
        return client;
    }

    private static void setClient(CSGClient client) {
        CSGClient.client = client;
    }

    public static boolean isServerCall() {
        return serverCall;
    }

    public static void setServerCall(boolean serverCall) {
        CSGClient.serverCall = serverCall;
    }
}

