/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d;

import javafx.collections.FXCollections;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;

public class PolygonMesh {
    private final ObservableFloatArray points = FXCollections.observableFloatArray();
    private final ObservableFloatArray texCoords = FXCollections.observableFloatArray();
    public int[][] faces = new int[0][0];
    private final ObservableIntegerArray faceSmoothingGroups = FXCollections.observableIntegerArray();
    protected int numEdgesInFaces = -1;
    private static final int NUM_COMPONENTS_PER_POINT = 3;
    private static final int NUM_COMPONENTS_PER_TEXCOORD = 2;
    private static final int NUM_COMPONENTS_PER_FACE = 6;

    public PolygonMesh() {
    }

    public PolygonMesh(float[] points, float[] texCoords, int[][] faces) {
        this.points.addAll(points);
        this.texCoords.addAll(texCoords);
        this.faces = faces;
    }

    public ObservableFloatArray getPoints() {
        return this.points;
    }

    public ObservableFloatArray getTexCoords() {
        return this.texCoords;
    }

    public ObservableIntegerArray getFaceSmoothingGroups() {
        return this.faceSmoothingGroups;
    }

    public int getNumEdgesInFaces() {
        if (this.numEdgesInFaces == -1) {
            this.numEdgesInFaces = 0;
            for (int[] face : this.faces) {
                this.numEdgesInFaces += face.length;
            }
            this.numEdgesInFaces /= 2;
        }
        return this.numEdgesInFaces;
    }

    public int getPointElementSize() {
        return 3;
    }

    public int getTexCoordElementSize() {
        return 2;
    }

    public int getFaceElementSize() {
        return 6;
    }
}

