/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Bounds;
import eu.mihosoft.vrl.v3d.CSG;
import eu.mihosoft.vrl.v3d.Edge;
import eu.mihosoft.vrl.v3d.Plane;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Transform;
import eu.mihosoft.vrl.v3d.Vector3d;
import eu.mihosoft.vrl.v3d.Vertex;
import eu.mihosoft.vrl.v3d.ext.org.poly2tri.PolygonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.paint.Color;
import javax.vecmath.Tuple3d;

public final class Polygon
implements Serializable {
    private static final long serialVersionUID = 2090322224114633535L;
    private ArrayList<Vertex> vertices;
    private PropertyStorage shared;
    public Plane plane = null;
    private boolean isHole = false;
    private double r = CSG.getDefaultColor().getRed();
    private double g = CSG.getDefaultColor().getGreen();
    private double b = CSG.getDefaultColor().getBlue();
    private double o = CSG.getDefaultColor().getOpacity();
    private boolean valid = true;
    private boolean degenerate = false;

    void setStorage(PropertyStorage storage) {
        this.shared = storage;
    }

    public static List<Polygon> fromConcavePoints(Vector3d ... points) {
        Polygon p = Polygon.fromPoints(points);
        return PolygonUtil.concaveToConvex(p);
    }

    public static List<Polygon> fromConcavePoints(List<Vector3d> points) {
        Polygon p = Polygon.fromPoints(points);
        return PolygonUtil.concaveToConvex(p);
    }

    public Polygon(List<Vertex> vertices, PropertyStorage shared, boolean allowDegenerate, Plane p) {
        this.vertices = Polygon.pruneDuplicatePoints(vertices);
        this.shared = shared;
        if (p != null) {
            this.setPlane(p.clone());
        }
        this.validateAndInit(allowDegenerate);
    }

    public Polygon(List<Vertex> vertices, PropertyStorage shared) {
        this(vertices, shared, true, null);
    }

    public Polygon(List<Vertex> vertices) {
        this(vertices, new PropertyStorage(), true, null);
    }

    public static ArrayList<Vertex> pruneDuplicatePoints(List<Vertex> incoming) {
        ArrayList<Vertex> newPoints = new ArrayList<Vertex>();
        for (int i = 0; i < incoming.size(); ++i) {
            Vertex v = incoming.get(i);
            boolean duplicate = false;
            for (Vertex vx : newPoints) {
                if (!vx.pos.test(v.pos, Plane.getEPSILON())) continue;
            }
            if (duplicate) continue;
            newPoints.add(v);
        }
        try {
            return newPoints;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private void validateAndInit(boolean allowDegenerate) {
        this.vertices = Polygon.pruneDuplicatePoints(this.vertices);
        if (this.getPlane() == null) {
            this.setPlane(Plane.createFromPoints(this.vertices));
        }
        for (Vertex v : this.getVertices()) {
            v.normal = this.getPlane().getNormal();
        }
        this.setDegenerate(true);
        if (Vector3d.ZERO.equals((Tuple3d)this.getPlane().getNormal())) {
            this.valid = false;
            throw new RuntimeException("Normal is zero! Probably, duplicate points have been specified!\n\n" + this.toStlString());
        }
        if (this.getVertices().size() < 3) {
            throw new RuntimeException("Invalid polygon: at least 3 vertices expected, got: " + this.getVertices().size());
        }
        Edge e = new Edge(this.getVertices().get(0), this.getVertices().get(1));
        for (int i = 2; i < this.getVertices().size(); ++i) {
            if (e.colinear(this.getVertices().get((int)i).pos)) continue;
            this.setDegenerate(false);
            return;
        }
        if (!allowDegenerate) {
            new RuntimeException("This polygon is colinear").printStackTrace();
        }
    }

    public Polygon(Vertex ... vertices) {
        this(Arrays.asList(vertices));
    }

    public Polygon clone() {
        ArrayList<Vertex> newVertices = new ArrayList<Vertex>();
        this.getVertices().forEach(vertex -> newVertices.add(vertex.clone()));
        return new Polygon(newVertices, this.getStorage(), true, null).setColor(this.getColor());
    }

    public Polygon flip() {
        this.getVertices().forEach(vertex -> vertex.flip());
        Collections.reverse(this.getVertices());
        this.getPlane().flip();
        return this;
    }

    public Polygon flipped() {
        return this.clone().flip();
    }

    public String toStlString() {
        return this.toStlString(new StringBuilder()).toString();
    }

    public StringBuilder toStlString(StringBuilder sb) {
        if (this.getVertices().size() != 3) {
            throw new RuntimeException("Polygon must be a triangle before STL can be made " + this.getVertices().size());
        }
        String firstVertexStl = this.getVertices().get(0).toStlString();
        sb.append("  facet normal ").append(this.getPlane().getNormal().toStlString()).append("\n").append("    outer loop\n").append("      ").append(firstVertexStl).append("\n").append("      ");
        this.getVertices().get(1).toStlString(sb).append("\n").append("      ");
        this.getVertices().get(2).toStlString(sb).append("\n").append("    endloop\n").append("  endfacet\n");
        return sb;
    }

    public Polygon transform(Transform transform) {
        this.getVertices().stream().forEach(v -> v.transform(transform));
        Vector3d a = this.getVertices().get((int)0).pos;
        this.getPlane().transformPlane(transform, a);
        if (transform.isMirror()) {
            this.flip();
        }
        return this;
    }

    public Polygon transformed(Transform transform) {
        return this.clone().transform(transform);
    }

    public static Polygon fromPoints(List<Vector3d> points, PropertyStorage shared) {
        return Polygon.fromPoints(points, shared, null, true);
    }

    public static Polygon fromPoints(List<Vector3d> points) {
        return Polygon.fromPoints(points, new PropertyStorage(), null, true);
    }

    public static Polygon fromPoints(Vector3d ... points) {
        return Polygon.fromPoints(Arrays.asList(points), new PropertyStorage(), null, true);
    }

    public static Polygon fromPointsAllowDegenerate(List<Vector3d> vertices2) {
        return Polygon.fromPoints(vertices2, new PropertyStorage(), null, true);
    }

    private static Polygon fromPoints(List<Vector3d> points, PropertyStorage shared, Plane plane, boolean allowDegenerate) {
        Vector3d normal = plane != null ? plane.getNormal().clone() : new Vector3d(0.0, 0.0, 0.0);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        for (Vector3d p : points) {
            Vector3d vec = p.clone();
            Vertex vertex = new Vertex(vec, normal);
            vertices.add(vertex);
        }
        return new Polygon(vertices, shared, allowDegenerate, null);
    }

    public Bounds getBounds() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.getVertices().size(); ++i) {
            Vertex vert = this.getVertices().get(i);
            if (vert.pos.x < minX) {
                minX = vert.pos.x;
            }
            if (vert.pos.y < minY) {
                minY = vert.pos.y;
            }
            if (vert.pos.z < minZ) {
                minZ = vert.pos.z;
            }
            if (vert.pos.x > maxX) {
                maxX = vert.pos.x;
            }
            if (vert.pos.y > maxY) {
                maxY = vert.pos.y;
            }
            if (!(vert.pos.z > maxZ)) continue;
            maxZ = vert.pos.z;
        }
        return new Bounds(new Vector3d(minX, minY, minZ), new Vector3d(maxX, maxY, maxZ));
    }

    public boolean contains(Vector3d p) {
        double px = p.x;
        double py = p.y;
        boolean oddNodes = false;
        double x2 = this.getVertices().get((int)(this.getVertices().size() - 1)).pos.x;
        double y2 = this.getVertices().get((int)(this.getVertices().size() - 1)).pos.y;
        for (int i = 0; i < this.getVertices().size(); ++i) {
            double x1 = this.getVertices().get((int)i).pos.x;
            double y1 = this.getVertices().get((int)i).pos.y;
            if ((y1 < py && y2 >= py || y1 >= py && y2 < py) && (py - y1) / (y2 - y1) * (x2 - x1) < px - x1) {
                oddNodes = !oddNodes;
            }
            x2 = x1;
            y2 = y1;
        }
        return oddNodes;
    }

    public boolean contains(Polygon p) {
        for (Vertex v : p.getVertices()) {
            if (this.contains(v.pos)) continue;
            return false;
        }
        return true;
    }

    public PropertyStorage getStorage() {
        if (this.shared == null) {
            this.shared = new PropertyStorage();
        }
        return this.shared;
    }

    public List<Vector3d> getPoints() {
        ArrayList<Vector3d> p = new ArrayList<Vector3d>();
        for (Vertex v : this.getVertices()) {
            p.add(v.pos);
        }
        return p;
    }

    public Polygon movey(Number howFarToMove) {
        return this.transformed(Transform.unity().translateY(howFarToMove.doubleValue()));
    }

    public Polygon movez(Number howFarToMove) {
        return this.transformed(Transform.unity().translateZ(howFarToMove.doubleValue()));
    }

    public Polygon movex(Number howFarToMove) {
        return this.transformed(Transform.unity().translateX(howFarToMove.doubleValue()));
    }

    public Polygon rotz(Number degreesToRotate) {
        return this.transformed(new Transform().rotZ(degreesToRotate.doubleValue()));
    }

    public Polygon roty(Number degreesToRotate) {
        return this.transformed(new Transform().rotY(degreesToRotate.doubleValue()));
    }

    public Polygon rotx(Number degreesToRotate) {
        return this.transformed(new Transform().rotX(degreesToRotate.doubleValue()));
    }

    public Polygon scalez(Number scaleValue) {
        return this.transformed(new Transform().scaleZ(scaleValue.doubleValue()));
    }

    public Polygon scaley(Number scaleValue) {
        return this.transformed(new Transform().scaleY(scaleValue.doubleValue()));
    }

    public Polygon scalex(Number scaleValue) {
        return this.transformed(new Transform().scaleX(scaleValue.doubleValue()));
    }

    public Polygon scale(Number scaleValue) {
        return this.transformed(new Transform().scale(scaleValue.doubleValue()));
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setDegenerate(boolean degenerate) {
        this.degenerate = degenerate;
    }

    public boolean isDegenerate() {
        return this.degenerate;
    }

    public ArrayList<Vertex> getDegeneratePoints() {
        ArrayList<Vertex> back = new ArrayList<Vertex>();
        if (!this.isDegenerate()) {
            return back;
        }
        Edge longEdge = this.getLongEdge();
        for (int i = 0; i < this.getVertices().size(); ++i) {
            Vertex vertex = this.getVertices().get(i);
            if (vertex == longEdge.getP1() || vertex == longEdge.getP2()) continue;
            back.add(vertex);
        }
        if (back.size() == 0) {
            throw new RuntimeException("Failed to find the degenerate point in the polygon");
        }
        return back;
    }

    public Edge getLongEdge() {
        if (!this.isDegenerate()) {
            return null;
        }
        ArrayList<Edge> e = this.edges();
        Edge longEdge = e.get(0);
        for (int i = 1; i < e.size(); ++i) {
            Edge edge = e.get(i);
            if (!(edge.length() > longEdge.length())) continue;
            longEdge = edge;
        }
        return longEdge;
    }

    public ArrayList<Edge> edges() {
        ArrayList<Edge> e = new ArrayList<Edge>();
        for (int i = 0; i < this.getVertices().size(); ++i) {
            int i1 = i;
            int i2 = i + 1;
            if (i2 == this.getVertices().size()) {
                i2 = 0;
            }
            e.add(new Edge(this.getVertices().get(i1), this.getVertices().get(i2)));
        }
        return e;
    }

    public Polygon setColor(Color color) {
        if (color != null) {
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
            this.o = color.getOpacity();
        } else {
            this.setColor(CSG.getDefaultColor());
        }
        return this;
    }

    public Color getColor() {
        return new Color(this.r, this.g, this.b, this.o);
    }

    public String toString() {
        String ret = "# points=" + this.getVertices().size() + " normal=" + this.getPlane().getNormal().toStlString() + " [ ";
        for (Vertex v : this.getVertices()) {
            ret = ret + " " + v.pos.toStlString() + " , ";
        }
        return ret + " ] ";
    }

    public boolean isHole() {
        return this.isHole;
    }

    public void setHole(boolean isHole) {
        this.isHole = isHole;
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public Polygon add(int index, Vertex v) {
        this.vertices.add(index, v);
        return this;
    }

    public boolean areAllPointsCollinear() {
        double ep;
        if (this.vertices.size() <= 2) {
            return true;
        }
        Vertex p1 = this.vertices.get(0);
        Vertex p2 = this.vertices.get(1);
        Vector3d direction = p1.pos.minus(p2.pos);
        double length = direction.length();
        if (length < (ep = Plane.getEPSILON())) {
            return false;
        }
        direction.normalize();
        for (int i = 2; i < this.vertices.size(); ++i) {
            Vertex p = this.vertices.get(i);
            Vector3d cross = direction.cross(p.pos);
            double magnitude = Math.abs(cross.length());
            if (!(magnitude > ep)) continue;
            return false;
        }
        return true;
    }

    public Plane getPlane() {
        return this.plane;
    }

    public void setPlane(Plane plane) {
        this.plane = plane;
    }
}

