/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.CSGServerHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CSGServer {
    private final int port;
    private final ExecutorService threadPool;
    private volatile boolean running = false;
    private static String KEYSTORE_PATH = "servername";
    private static File directory = new File(System.getProperty("java.io.tmpdir"));
    private static final String KEYSTORE_NAME = "CSGSelfSign";
    private String[] lines = null;
    private SSLServerSocket serverSocket2;

    public CSGServer(int port, File APIKEYS) throws IOException {
        this.port = port;
        this.threadPool = Executors.newCachedThreadPool();
        if (APIKEYS == null) {
            throw new NullPointerException("API Key file can not be null");
        }
        if (APIKEYS.exists()) {
            this.lines = Files.readAllLines(APIKEYS.toPath()).toArray(new String[0]);
        }
        if (this.lines != null) {
            System.out.println("Starting server with " + this.lines.length + " keys from " + APIKEYS.getAbsolutePath());
        } else {
            System.err.println("NO API KEYFILE Provided: " + APIKEYS.getAbsolutePath());
        }
    }

    public static void ensureKeystoreExists(String keystorePath, String keystorePassword, String alias, String commonName) {
        File keystoreFile = new File(keystorePath);
        if (!keystoreFile.exists()) {
            System.out.println("Keystore not found. Generating new keystore: " + keystorePath);
            try {
                CSGServer.generateKeystoreWithBouncyCastle(keystorePath, keystorePassword, alias, commonName);
                System.out.println("Keystore generated successfully using keytool.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to generate keystore: " + e.getMessage(), e);
            }
        } else {
            System.out.println("Using existing keystore: " + keystorePath);
        }
    }

    private static void generateKeystoreWithBouncyCastle(String keystorePath, String keystorePassword, String alias, String commonName) throws Exception {
        System.out.println("Generating keystore using Bouncy Castle...");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate certificate = CSGServer.createSelfSignedCertificateBC(keyPair, commonName);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Certificate[] certificateChain = new Certificate[]{certificate};
        keyStore.setKeyEntry(alias, keyPair.getPrivate(), keystorePassword.toCharArray(), certificateChain);
        try (FileOutputStream fos = new FileOutputStream(keystorePath);){
            keyStore.store(fos, keystorePassword.toCharArray());
        }
        System.out.println("Keystore generated successfully at: " + keystorePath);
    }

    private static X509Certificate createSelfSignedCertificateBC(KeyPair keyPair, String commonName) throws Exception {
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(365L, ChronoUnit.DAYS));
        String distinguishedName = String.format("CN=%s,OU=Auto-Generated,O=Development,L=Unknown,ST=Unknown,C=US", commonName);
        X500Name x500Name = new X500Name(distinguishedName);
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        Time notBeforeTime = new Time(notBefore);
        Time notAfterTime = new Time(notAfter);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(x500Name, serialNumber, notBeforeTime, notAfterTime, x500Name, subjectPublicKeyInfo);
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withRSA").build(privateKey);
        X509CertificateHolder certHolder = certBuilder.build(contentSigner);
        JcaX509CertificateConverter certConverter = new JcaX509CertificateConverter();
        return certConverter.getCertificate(certHolder);
    }

    public void start() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.stop();
            }
            catch (IOException e) {
                System.err.println("Error during server shutdown: " + e.getMessage());
            }
        }));
        KeyStore keyStore = KeyStore.getInstance("JKS");
        String path = CSGServer.getDirectory().getAbsolutePath() + "/" + KEYSTORE_PATH;
        CSGServer.ensureKeystoreExists(path, KEYSTORE_NAME, "server", "localhost");
        keyStore.load(new FileInputStream(path), KEYSTORE_NAME.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, KEYSTORE_NAME.toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), null, null);
        SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
        this.serverSocket2 = (SSLServerSocket)factory.createServerSocket(this.port);
        this.setRunning(true);
        System.out.println("CSG TCP Server started on port " + this.port);
        System.out.println("Waiting for clients...");
        while (this.isRunning()) {
            try {
                SSLSocket clientSocket = (SSLSocket)this.serverSocket2.accept();
                this.threadPool.execute(new CSGServerHandler(clientSocket, this.lines));
            }
            catch (IOException e) {
                if (!this.isRunning()) continue;
                System.err.println("Error accepting client connection: " + e.getMessage());
            }
        }
    }

    public void stop() throws IOException {
        this.setRunning(false);
        if (this.serverSocket2 != null && !this.serverSocket2.isClosed()) {
            this.serverSocket2.close();
        }
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
        System.out.println("CSG TCP Server stopped");
    }

    public static void main(String[] args) throws Exception {
        int port = 3742;
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid port number. Using default port 8080");
            }
        }
        File f = new File("/opt/File.txt");
        CSGServer server = new CSGServer(port, f);
        server.start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public static File getDirectory() {
        return directory;
    }

    public static void setDirectory(File directory) {
        CSGServer.directory = directory;
    }
}

