/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic;

import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.SubdivisionMesh;
import eu.mihosoft.vrl.v3d.ext.openjfx.shape3d.symbolic.SymbolicPointArray;
import java.util.Arrays;

public class SubdividedPointArray
extends SymbolicPointArray {
    private final float[] controlPoints;
    private final int[][] controlInds;
    private final float[][] controlFactors;
    private final int[][] inds;
    private final float[][] factors;
    private final SubdivisionMesh.BoundaryMode boundaryMode;
    private int currPoint = 0;

    public SubdividedPointArray(SymbolicPointArray controlPointArray, int numPoints, SubdivisionMesh.BoundaryMode boundaryMode) {
        super(new float[3 * numPoints]);
        this.controlPoints = controlPointArray.data;
        this.controlInds = new int[numPoints][];
        this.controlFactors = new float[numPoints][];
        this.inds = new int[numPoints][];
        this.factors = new float[numPoints][];
        this.boundaryMode = boundaryMode;
    }

    public int addFacePoint(int[] vertices) {
        this.controlInds[this.currPoint] = vertices;
        this.controlFactors[this.currPoint] = new float[vertices.length];
        Arrays.fill(this.controlFactors[this.currPoint], 1.0f / (float)vertices.length);
        this.inds[this.currPoint] = new int[0];
        this.factors[this.currPoint] = new float[0];
        return this.currPoint++;
    }

    public int addEdgePoint(int[] facePoints, int fromPoint, int toPoint, boolean isBoundary) {
        if (isBoundary) {
            this.controlInds[this.currPoint] = new int[]{fromPoint, toPoint};
            this.controlFactors[this.currPoint] = new float[]{0.5f, 0.5f};
            this.inds[this.currPoint] = new int[0];
            this.factors[this.currPoint] = new float[0];
        } else {
            int n = facePoints.length + 2;
            this.controlInds[this.currPoint] = new int[]{fromPoint, toPoint};
            this.controlFactors[this.currPoint] = new float[]{1.0f / (float)n, 1.0f / (float)n};
            this.inds[this.currPoint] = facePoints;
            this.factors[this.currPoint] = new float[facePoints.length];
            Arrays.fill(this.factors[this.currPoint], 1.0f / (float)n);
        }
        return this.currPoint++;
    }

    public int addControlPoint(int[] facePoints, int[] edgePoints, int[] fromEdgePoints, int[] toEdgePoints, boolean[] isEdgeBoundary, int origPoint, boolean isBoundary, boolean hasInternalEdge) {
        if (isBoundary) {
            if (this.boundaryMode == SubdivisionMesh.BoundaryMode.CREASE_EDGES || hasInternalEdge) {
                this.controlInds[this.currPoint] = new int[]{origPoint};
                this.controlFactors[this.currPoint] = new float[]{0.5f};
                int numBoundaryEdges = 0;
                for (int i = 0; i < edgePoints.length; ++i) {
                    if (!isEdgeBoundary[i]) continue;
                    ++numBoundaryEdges;
                }
                this.inds[this.currPoint] = new int[numBoundaryEdges];
                this.factors[this.currPoint] = new float[numBoundaryEdges];
                int boundaryEdgeInd = 0;
                for (int i = 0; i < edgePoints.length; ++i) {
                    if (!isEdgeBoundary[i]) continue;
                    this.inds[this.currPoint][boundaryEdgeInd] = edgePoints[i];
                    this.factors[this.currPoint][boundaryEdgeInd] = 0.25f;
                    ++boundaryEdgeInd;
                }
            } else {
                this.controlInds[this.currPoint] = new int[]{origPoint};
                this.controlFactors[this.currPoint] = new float[]{1.0f};
                this.inds[this.currPoint] = new int[0];
                this.factors[this.currPoint] = new float[0];
            }
        } else {
            int n = facePoints.length;
            this.controlInds[this.currPoint] = new int[1 + edgePoints.length * 2];
            this.controlFactors[this.currPoint] = new float[1 + edgePoints.length * 2];
            this.controlInds[this.currPoint][0] = origPoint;
            this.controlFactors[this.currPoint][0] = ((float)n - 3.0f) / (float)n;
            for (int i = 0; i < edgePoints.length; ++i) {
                this.controlInds[this.currPoint][1 + 2 * i] = fromEdgePoints[i];
                this.controlFactors[this.currPoint][1 + 2 * i] = 1.0f / (float)(n * n);
                this.controlInds[this.currPoint][1 + 2 * i + 1] = toEdgePoints[i];
                this.controlFactors[this.currPoint][1 + 2 * i + 1] = 1.0f / (float)(n * n);
            }
            this.inds[this.currPoint] = facePoints;
            this.factors[this.currPoint] = new float[facePoints.length];
            Arrays.fill(this.factors[this.currPoint], 1.0f / (float)(n * n));
        }
        return this.currPoint++;
    }

    @Override
    public void update() {
        for (int i = 0; i < this.numPoints; ++i) {
            float f;
            int ci;
            int j;
            float z = 0.0f;
            float y = 0.0f;
            float x = 0.0f;
            for (j = 0; j < this.controlInds[i].length; ++j) {
                ci = 3 * this.controlInds[i][j];
                f = this.controlFactors[i][j];
                x += this.controlPoints[ci] * f;
                y += this.controlPoints[ci + 1] * f;
                z += this.controlPoints[ci + 2] * f;
            }
            for (j = 0; j < this.inds[i].length; ++j) {
                ci = 3 * this.inds[i][j];
                f = this.factors[i][j];
                x += this.data[ci] * f;
                y += this.data[ci + 1] * f;
                z += this.data[ci + 2] * f;
            }
            this.data[3 * i] = x;
            this.data[3 * i + 1] = y;
            this.data[3 * i + 2] = z;
        }
    }
}

