/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d.ext.openjfx.importers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class Optimizer {
    private Timeline timeline;
    private Node root;
    private Set<Transform> bound = new HashSet<Transform>();
    private List<Parent> emptyParents = new ArrayList<Parent>();
    private List<MeshView> meshViews = new ArrayList<MeshView>();
    private boolean convertToDiscrete = true;
    private int trRemoved;
    private int trTotal;
    private int groupsTotal;
    private int trCandidate;
    private int trEmpty;

    public Optimizer(Timeline timeline, Node root) {
        this(timeline, root, false);
    }

    public Optimizer(Timeline timeline, Node root, boolean convertToDiscrete) {
        this.timeline = timeline;
        this.root = root;
        this.convertToDiscrete = convertToDiscrete;
    }

    public void optimize() {
        this.trRemoved = 0;
        this.trTotal = 0;
        this.trCandidate = 0;
        this.trEmpty = 0;
        this.groupsTotal = 0;
        this.emptyParents.clear();
        this.parseTimeline();
        this.optimize(this.root);
        this.removeEmptyGroups();
        this.optimizeMeshes();
        System.out.printf("removed %d (%.2f%%) out of total %d transforms\n", this.trRemoved, 100.0 * (double)this.trRemoved / (double)this.trTotal, this.trTotal);
        System.out.printf("there are %d more multiplications that can be done of matrices that never change\n", this.trCandidate);
        System.out.printf("there are %d (%.2f%%) out of total %d groups with no transforms in them\n", this.trEmpty, 100.0 * (double)this.trEmpty / (double)this.groupsTotal, this.groupsTotal);
    }

    private void optimize(Node node) {
        ObservableList transforms = node.getTransforms();
        Iterator iterator = transforms.iterator();
        boolean prevIsStatic = false;
        while (iterator.hasNext()) {
            Transform transform = (Transform)iterator.next();
            ++this.trTotal;
            if (transform.isIdentity()) {
                if (this.timeline != null && this.bound.contains(transform)) continue;
                iterator.remove();
                ++this.trRemoved;
                continue;
            }
            if (this.timeline == null || !this.bound.contains(transform)) {
                if (prevIsStatic) {
                    ++this.trCandidate;
                }
                prevIsStatic = true;
                continue;
            }
            prevIsStatic = false;
        }
        if (node instanceof Parent) {
            Parent parent;
            ++this.groupsTotal;
            Parent p = (Parent)node;
            for (Node n : p.getChildrenUnmodifiable()) {
                this.optimize(n);
            }
            if (transforms.isEmpty() && (parent = p.getParent()) instanceof Group) {
                ++this.trEmpty;
                this.emptyParents.add(p);
            }
        }
        if (node instanceof MeshView) {
            this.meshViews.add((MeshView)node);
        }
    }

    private void optimizeMeshes() {
        this.optimizePoints();
        this.optimizeTexCoords();
        this.optimizeFaces();
    }

    private void optimizeFaces() {
        int total = 0;
        int sameIndexes = 0;
        int samePoints = 0;
        int smallArea = 0;
        ObservableIntegerArray newFaces = FXCollections.observableIntegerArray();
        ObservableIntegerArray newFaceSmoothingGroups = FXCollections.observableIntegerArray();
        for (MeshView meshView : this.meshViews) {
            TriangleMesh mesh = (TriangleMesh)meshView.getMesh();
            ObservableFaceArray faces = mesh.getFaces();
            ObservableIntegerArray faceSmoothingGroups = mesh.getFaceSmoothingGroups();
            ObservableFloatArray points = mesh.getPoints();
            newFaces.clear();
            newFaces.ensureCapacity(faces.size());
            newFaceSmoothingGroups.clear();
            newFaceSmoothingGroups.ensureCapacity(faceSmoothingGroups.size());
            int pointElementSize = mesh.getPointElementSize();
            int faceElementSize = mesh.getFaceElementSize();
            for (int i = 0; i < faces.size(); i += faceElementSize) {
                ++total;
                int i1 = faces.get(i) * pointElementSize;
                int i2 = faces.get(i + 2) * pointElementSize;
                int i3 = faces.get(i + 4) * pointElementSize;
                if (i1 == i2 || i1 == i3 || i2 == i3) {
                    ++sameIndexes;
                    continue;
                }
                Point3D p1 = new Point3D((double)points.get(i1), (double)points.get(i1 + 1), (double)points.get(i1 + 2));
                Point3D p2 = new Point3D((double)points.get(i2), (double)points.get(i2 + 1), (double)points.get(i2 + 2));
                Point3D p3 = new Point3D((double)points.get(i3), (double)points.get(i3 + 1), (double)points.get(i3 + 2));
                if (p1.equals((Object)p2) || p1.equals((Object)p3) || p2.equals((Object)p3)) {
                    ++samePoints;
                    continue;
                }
                double a = p1.distance(p2);
                double b = p2.distance(p3);
                double c = p3.distance(p1);
                double p = (a + b + c) / 2.0;
                double sqarea = p * (p - a) * (p - b) * (p - c);
                float DEAD_FACE = 9.094947E-13f;
                if (sqarea < 9.094947017729282E-13) {
                    ++smallArea;
                    continue;
                }
                newFaces.addAll((ObservableIntegerArray)faces, i, faceElementSize);
                int fIndex = i / faceElementSize;
                if (fIndex >= faceSmoothingGroups.size()) continue;
                newFaceSmoothingGroups.addAll(new int[]{faceSmoothingGroups.get(fIndex)});
            }
            faces.setAll(newFaces);
            faceSmoothingGroups.setAll(newFaceSmoothingGroups);
            faces.trimToSize();
            faceSmoothingGroups.trimToSize();
        }
        int badTotal = sameIndexes + samePoints + smallArea;
        System.out.printf("Removed %d (%.2f%%) faces with same point indexes, %d (%.2f%%) faces with same points, %d (%.2f%%) faces with small area. Total %d (%.2f%%) bad faces out of %d total.\n", sameIndexes, 100.0 * (double)sameIndexes / (double)total, samePoints, 100.0 * (double)samePoints / (double)total, smallArea, 100.0 * (double)smallArea / (double)total, badTotal, 100.0 * (double)badTotal / (double)total, total);
    }

    private void optimizePoints() {
        int total = 0;
        int duplicates = 0;
        int check = 0;
        HashMap<Point3D, Integer> pp = new HashMap<Point3D, Integer>();
        ObservableIntegerArray reindex = FXCollections.observableIntegerArray();
        ObservableFloatArray newPoints = FXCollections.observableFloatArray();
        for (MeshView meshView : this.meshViews) {
            TriangleMesh mesh = (TriangleMesh)meshView.getMesh();
            ObservableFloatArray points = mesh.getPoints();
            int pointElementSize = mesh.getPointElementSize();
            int os = points.size() / pointElementSize;
            pp.clear();
            newPoints.clear();
            newPoints.ensureCapacity(points.size());
            reindex.clear();
            reindex.resize(os);
            int i = 0;
            int oi = 0;
            int ni = 0;
            while (i < points.size()) {
                float z;
                float y;
                float x = points.get(i);
                Point3D p = new Point3D((double)x, (double)(y = points.get(i + 1)), (double)(z = points.get(i + 2)));
                Integer index = (Integer)pp.get(p);
                if (index == null) {
                    pp.put(p, ni);
                    reindex.set(oi, ni);
                    newPoints.addAll(new float[]{x, y, z});
                    ++ni;
                } else {
                    reindex.set(oi, index.intValue());
                }
                i += pointElementSize;
                ++oi;
            }
            int ns = newPoints.size() / pointElementSize;
            int d = os - ns;
            duplicates += d;
            total += os;
            points.setAll(newPoints);
            points.trimToSize();
            ObservableFaceArray faces = mesh.getFaces();
            for (int i2 = 0; i2 < faces.size(); i2 += 2) {
                faces.set(i2, reindex.get(faces.get(i2)));
            }
            check += mesh.getPoints().size() / pointElementSize;
        }
        System.out.printf("There are %d (%.2f%%) duplicate points out of %d total.\n", duplicates, 100.0 * (double)duplicates / (double)total, total);
        System.out.printf("Now we have %d points.\n", check);
    }

    private void optimizeTexCoords() {
        int total = 0;
        int duplicates = 0;
        int check = 0;
        HashMap<Point2D, Integer> pp = new HashMap<Point2D, Integer>();
        ObservableIntegerArray reindex = FXCollections.observableIntegerArray();
        ObservableFloatArray newTexCoords = FXCollections.observableFloatArray();
        for (MeshView meshView : this.meshViews) {
            TriangleMesh mesh = (TriangleMesh)meshView.getMesh();
            ObservableFloatArray texcoords = mesh.getTexCoords();
            int texcoordElementSize = mesh.getTexCoordElementSize();
            int os = texcoords.size() / texcoordElementSize;
            pp.clear();
            newTexCoords.clear();
            newTexCoords.ensureCapacity(texcoords.size());
            reindex.clear();
            reindex.resize(os);
            int i = 0;
            int oi = 0;
            int ni = 0;
            while (i < texcoords.size()) {
                float y;
                float x = texcoords.get(i);
                Point2D p = new Point2D((double)x, (double)(y = texcoords.get(i + 1)));
                Integer index = (Integer)pp.get(p);
                if (index == null) {
                    pp.put(p, ni);
                    reindex.set(oi, ni);
                    newTexCoords.addAll(new float[]{x, y});
                    ++ni;
                } else {
                    reindex.set(oi, index.intValue());
                }
                i += texcoordElementSize;
                ++oi;
            }
            int ns = newTexCoords.size() / texcoordElementSize;
            int d = os - ns;
            duplicates += d;
            total += os;
            texcoords.setAll(newTexCoords);
            texcoords.trimToSize();
            ObservableFaceArray faces = mesh.getFaces();
            for (int i2 = 1; i2 < faces.size(); i2 += 2) {
                faces.set(i2, reindex.get(faces.get(i2)));
            }
            check += mesh.getTexCoords().size() / texcoordElementSize;
        }
        System.out.printf("There are %d (%.2f%%) duplicate texcoords out of %d total.\n", duplicates, 100.0 * (double)duplicates / (double)total, total);
        System.out.printf("Now we have %d texcoords.\n", check);
    }

    private void cleanUpRepeatingFramesAndValues() {
        SortedList timelineKeyFrames = this.timeline.getKeyFrames().sorted((Comparator)new KeyFrameComparator());
        int kfTotal = timelineKeyFrames.size();
        int kfRemoved = 0;
        int kvTotal = 0;
        int kvRemoved = 0;
        HashMap<Duration, KeyFrame> kfUnique = new HashMap<Duration, KeyFrame>();
        HashMap<WritableValue, KeyValue> kvUnique = new HashMap<WritableValue, KeyValue>();
        MapOfLists<KeyFrame, KeyFrame> duplicates = new MapOfLists<KeyFrame, KeyFrame>();
        Iterator iterator = timelineKeyFrames.iterator();
        while (iterator.hasNext()) {
            KeyFrame duplicate = (KeyFrame)iterator.next();
            KeyFrame original = kfUnique.put(duplicate.getTime(), duplicate);
            if (original != null) {
                ++kfRemoved;
                iterator.remove();
                duplicates.add(original, duplicate);
                kfUnique.put(duplicate.getTime(), original);
            }
            kvUnique.clear();
            for (KeyValue kvDup : duplicate.getValues()) {
                ++kvTotal;
                KeyValue kvOrig = kvUnique.put(kvDup.getTarget(), kvDup);
                if (kvOrig == null) continue;
                ++kvRemoved;
                if (kvOrig.getEndValue().equals(kvDup.getEndValue()) || kvOrig.getTarget() != kvDup.getTarget()) continue;
                System.err.println("KeyValues set different values for KeyFrame " + duplicate.getTime() + ":\n kvOrig = " + kvOrig + ", \nkvDup = " + kvDup);
            }
        }
        for (KeyFrame orig : duplicates.keySet()) {
            ArrayList keyValues = new ArrayList();
            for (KeyFrame dup : (List)duplicates.get(orig)) {
                keyValues.addAll(dup.getValues());
            }
            timelineKeyFrames.set(timelineKeyFrames.indexOf((Object)orig), (Object)new KeyFrame(orig.getTime(), keyValues.toArray(new KeyValue[keyValues.size()])));
        }
        System.out.printf("Removed %d (%.2f%%) duplicate KeyFrames out of total %d.\n", kfRemoved, 100.0 * (double)kfRemoved / (double)kfTotal, kfTotal);
        System.out.printf("Identified %d (%.2f%%) duplicate KeyValues out of total %d.\n", kvRemoved, 100.0 * (double)kvRemoved / (double)kvTotal, kvTotal);
    }

    private void parseTimeline() {
        this.bound.clear();
        if (this.timeline == null) {
            return;
        }
        SortedList sortedKeyFrames = this.timeline.getKeyFrames().sorted((Comparator)new KeyFrameComparator());
        MapOfLists<KeyFrame, KeyValue> toRemove = new MapOfLists<KeyFrame, KeyValue>();
        HashMap<WritableValue, KeyInfo> prevValues = new HashMap<WritableValue, KeyInfo>();
        HashMap<WritableValue, KeyInfo> prevPrevValues = new HashMap<WritableValue, KeyInfo>();
        int kvTotal = 0;
        for (KeyFrame keyFrame : sortedKeyFrames) {
            for (KeyValue keyValue : keyFrame.getValues()) {
                KeyInfo oldPrev;
                WritableValue target = keyValue.getTarget();
                KeyInfo prev = (KeyInfo)prevValues.get(target);
                ++kvTotal;
                if (prev != null && prev.keyValue.getEndValue().equals(keyValue.getEndValue())) {
                    KeyInfo prevPrev = (KeyInfo)prevPrevValues.get(target);
                    if (prevPrev != null && prevPrev.keyValue.getEndValue().equals(keyValue.getEndValue()) || prev.first && target.getValue().equals(prev.keyValue.getEndValue())) {
                        toRemove.add(prev.keyFrame, prev.keyValue);
                    } else {
                        prevPrevValues.put(target, prev);
                    }
                }
                if ((oldPrev = prevValues.put(target, new KeyInfo(keyFrame, keyValue, prev == null))) == null) continue;
                prevPrevValues.put(target, oldPrev);
            }
        }
        for (WritableValue target : prevValues.keySet()) {
            KeyInfo prev = (KeyInfo)prevValues.get(target);
            KeyInfo prevPrev = (KeyInfo)prevPrevValues.get(target);
            if (prevPrev == null || !prevPrev.keyValue.getEndValue().equals(prev.keyValue.getEndValue())) continue;
            toRemove.add(prev.keyFrame, prev.keyValue);
        }
        int kvRemoved = 0;
        int kfRemoved = 0;
        int kfTotal = this.timeline.getKeyFrames().size();
        int kfSimplified = 0;
        int kfNotRemoved = 0;
        ArrayList<KeyValue> newKeyValues = new ArrayList<KeyValue>();
        for (int i = 0; i < this.timeline.getKeyFrames().size(); ++i) {
            KeyFrame keyFrame = (KeyFrame)this.timeline.getKeyFrames().get(i);
            List keyValuesToRemove = (List)toRemove.get(keyFrame);
            if (keyValuesToRemove != null) {
                newKeyValues.clear();
                for (KeyValue keyValue : keyFrame.getValues()) {
                    if (keyValuesToRemove.remove(keyValue)) {
                        ++kvRemoved;
                        continue;
                    }
                    if (this.convertToDiscrete) {
                        newKeyValues.add(new KeyValue(keyValue.getTarget(), keyValue.getEndValue(), Interpolator.DISCRETE));
                        continue;
                    }
                    newKeyValues.add(keyValue);
                }
            } else if (this.convertToDiscrete) {
                newKeyValues.clear();
                for (KeyValue keyValue : keyFrame.getValues()) {
                    newKeyValues.add(new KeyValue(keyValue.getTarget(), keyValue.getEndValue(), Interpolator.DISCRETE));
                }
            }
            if (keyValuesToRemove != null || this.convertToDiscrete) {
                if (newKeyValues.isEmpty()) {
                    if (keyFrame.getOnFinished() == null) {
                        if (keyFrame.getName() != null) {
                            System.err.println("Removed KeyFrame with name = " + keyFrame.getName());
                        }
                        this.timeline.getKeyFrames().remove(i);
                        --i;
                        ++kfRemoved;
                        continue;
                    }
                    ++kfNotRemoved;
                } else {
                    keyFrame = new KeyFrame(keyFrame.getTime(), keyFrame.getName(), keyFrame.getOnFinished(), newKeyValues);
                    this.timeline.getKeyFrames().set(i, (Object)keyFrame);
                    ++kfSimplified;
                }
            }
            for (KeyValue keyValue : keyFrame.getValues()) {
                WritableValue target = keyValue.getTarget();
                if (target instanceof Property) {
                    Property p = (Property)target;
                    Object bean = p.getBean();
                    if (bean instanceof Transform) {
                        this.bound.add((Transform)bean);
                        continue;
                    }
                    throw new UnsupportedOperationException("Bean is not transform, bean = " + bean);
                }
                throw new UnsupportedOperationException("WritableValue is not property, can't identify what it changes, target = " + target);
            }
        }
        System.out.printf("Removed %d (%.2f%%) repeating KeyValues out of total %d.\n", kvRemoved, 100.0 * (double)kvRemoved / (double)kvTotal, kvTotal);
        System.out.printf("Removed %d (%.2f%%) and simplified %d (%.2f%%) KeyFrames out of total %d. %d (%.2f%%) were not removed due to event handler attached.\n", kfRemoved, 100.0 * (double)kfRemoved / (double)kfTotal, kfSimplified, 100.0 * (double)kfSimplified / (double)kfTotal, kfTotal, kfNotRemoved, 100.0 * (double)kfNotRemoved / (double)kfTotal);
        int check = 0;
        for (KeyFrame keyFrame : this.timeline.getKeyFrames()) {
            check += keyFrame.getValues().size();
        }
        System.out.printf("Now there are %d KeyValues and %d KeyFrames.\n", check, this.timeline.getKeyFrames().size());
    }

    private void removeEmptyGroups() {
        for (Parent p : this.emptyParents) {
            Parent parent = p.getParent();
            Group g = (Group)parent;
            g.getChildren().addAll((Collection)p.getChildrenUnmodifiable());
            g.getChildren().remove((Object)p);
        }
    }

    private static class KeyFrameComparator
    implements Comparator<KeyFrame> {
        @Override
        public int compare(KeyFrame o1, KeyFrame o2) {
            return o1.getTime().compareTo(o2.getTime());
        }
    }

    private static class MapOfLists<K, V>
    extends HashMap<K, List<V>> {
        private MapOfLists() {
        }

        public void add(K key, V value) {
            ArrayList<V> p = (ArrayList<V>)this.get(key);
            if (p == null) {
                p = new ArrayList<V>();
                this.put(key, p);
            }
            p.add(value);
        }
    }

    private static class KeyInfo {
        KeyFrame keyFrame;
        KeyValue keyValue;
        boolean first;

        public KeyInfo(KeyFrame keyFrame, KeyValue keyValue) {
            this.keyFrame = keyFrame;
            this.keyValue = keyValue;
            this.first = false;
        }

        public KeyInfo(KeyFrame keyFrame, KeyValue keyValue, boolean first) {
            this.keyFrame = keyFrame;
            this.keyValue = keyValue;
            this.first = first;
        }
    }
}

