/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.SimplePacketComs.bytepacket;

import edu.wpi.SimplePacketComs.PacketType;
import java.nio.ByteBuffer;

public class BytePacketType
extends PacketType {
    public BytePacketType(int id, int size) {
        super(id);
        this.packetSize = size;
        this.numberOfBytesPerValue = 1;
        this.numValues = this.packetSize / this.numberOfBytesPerValue - 4 / this.numberOfBytesPerValue;
        this.init();
    }

    @Override
    public Number[] parse(byte[] bytes) {
        Number[] returnValues = new Number[this.numValues];
        for (int i = 0; i < this.numValues; ++i) {
            int baseIndex = this.numberOfBytesPerValue * i + 4;
            returnValues[i] = bytes[baseIndex];
        }
        return returnValues;
    }

    @Override
    public byte[] command(int idOfCommand, Number[] values) {
        byte[] message = new byte[this.packetSize];
        ByteBuffer.wrap(message).order(this.be).putInt(0, idOfCommand).array();
        for (int i = 0; i < this.numValues && i < values.length; ++i) {
            int baseIndex = this.numberOfBytesPerValue * i + 4;
            message[baseIndex] = values[i].byteValue();
        }
        return message;
    }
}

